/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.index.account;

import com.google.common.base.Preconditions;
import com.google.gerrit.server.account.AccountState;
import com.google.gerrit.server.index.IndexRewriter;
import com.google.gerrit.server.index.QueryOptions;
import com.google.gerrit.server.index.account.AccountIndex;
import com.google.gerrit.server.index.account.AccountIndexCollection;
import com.google.gerrit.server.index.account.IndexedAccountQuery;
import com.google.gerrit.server.query.Predicate;
import com.google.gerrit.server.query.QueryParseException;
import com.google.gerrit.server.query.account.AccountPredicates;
import com.google.inject.Inject;
import com.google.inject.Singleton;

@Singleton
public class AccountIndexRewriter
implements IndexRewriter<AccountState> {
    private final AccountIndexCollection indexes;

    @Inject
    AccountIndexRewriter(AccountIndexCollection indexes) {
        this.indexes = indexes;
    }

    @Override
    public Predicate<AccountState> rewrite(Predicate<AccountState> in, QueryOptions opts) throws QueryParseException {
        if (!AccountPredicates.hasActive(in)) {
            in = Predicate.and(in, AccountPredicates.isActive());
        }
        AccountIndex index = (AccountIndex)this.indexes.getSearchIndex();
        Preconditions.checkNotNull(index, "no active search index configured for accounts");
        return new IndexedAccountQuery(index, in, opts);
    }
}

