/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.index.change;

import com.google.common.base.Function;
import com.google.common.util.concurrent.Atomics;
import com.google.common.util.concurrent.CheckedFuture;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.gerrit.extensions.events.ChangeIndexedListener;
import com.google.gerrit.extensions.registration.DynamicSet;
import com.google.gerrit.reviewdb.client.Change;
import com.google.gerrit.reviewdb.client.Project;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.CurrentUser;
import com.google.gerrit.server.config.GerritServerConfig;
import com.google.gerrit.server.extensions.events.EventUtil;
import com.google.gerrit.server.git.QueueProvider;
import com.google.gerrit.server.index.Index;
import com.google.gerrit.server.index.IndexExecutor;
import com.google.gerrit.server.index.change.ChangeIndex;
import com.google.gerrit.server.index.change.ChangeIndexCollection;
import com.google.gerrit.server.index.change.StalenessChecker;
import com.google.gerrit.server.notedb.ChangeNotes;
import com.google.gerrit.server.notedb.NotesMigration;
import com.google.gerrit.server.project.NoSuchChangeException;
import com.google.gerrit.server.query.change.ChangeData;
import com.google.gerrit.server.util.RequestContext;
import com.google.gerrit.server.util.ThreadLocalRequestContext;
import com.google.gwtorm.server.OrmException;
import com.google.gwtorm.server.SchemaFactory;
import com.google.inject.OutOfScopeException;
import com.google.inject.Provider;
import com.google.inject.ProvisionException;
import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;
import com.google.inject.util.Providers;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.jgit.errors.RepositoryNotFoundException;
import org.eclipse.jgit.lib.Config;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChangeIndexer {
    private static final Logger log = LoggerFactory.getLogger(ChangeIndexer.class);
    private static final Function<Exception, IOException> MAPPER = new Function<Exception, IOException>(){

        @Override
        public IOException apply(Exception in) {
            if (in instanceof IOException) {
                return (IOException)in;
            }
            if (in instanceof ExecutionException && in.getCause() instanceof IOException) {
                return (IOException)in.getCause();
            }
            return new IOException(in);
        }
    };
    private final ChangeIndexCollection indexes;
    private final ChangeIndex index;
    private final SchemaFactory<ReviewDb> schemaFactory;
    private final NotesMigration notesMigration;
    private final ChangeNotes.Factory changeNotesFactory;
    private final ChangeData.Factory changeDataFactory;
    private final ThreadLocalRequestContext context;
    private final ListeningExecutorService batchExecutor;
    private final ListeningExecutorService executor;
    private final DynamicSet<ChangeIndexedListener> indexedListeners;
    private final StalenessChecker stalenessChecker;
    private final boolean autoReindexIfStale;

    public static CheckedFuture<?, IOException> allAsList(List<? extends ListenableFuture<?>> futures) {
        return Futures.makeChecked(Futures.allAsList(futures), MAPPER);
    }

    @AssistedInject
    ChangeIndexer(@GerritServerConfig Config cfg, SchemaFactory<ReviewDb> schemaFactory, NotesMigration notesMigration, ChangeNotes.Factory changeNotesFactory, ChangeData.Factory changeDataFactory, ThreadLocalRequestContext context, DynamicSet<ChangeIndexedListener> indexedListeners, StalenessChecker stalenessChecker, @IndexExecutor(value=QueueProvider.QueueType.BATCH) ListeningExecutorService batchExecutor, @Assisted ListeningExecutorService executor, @Assisted ChangeIndex index) {
        this.executor = executor;
        this.schemaFactory = schemaFactory;
        this.notesMigration = notesMigration;
        this.changeNotesFactory = changeNotesFactory;
        this.changeDataFactory = changeDataFactory;
        this.context = context;
        this.indexedListeners = indexedListeners;
        this.stalenessChecker = stalenessChecker;
        this.batchExecutor = batchExecutor;
        this.autoReindexIfStale = ChangeIndexer.autoReindexIfStale(cfg);
        this.index = index;
        this.indexes = null;
    }

    @AssistedInject
    ChangeIndexer(SchemaFactory<ReviewDb> schemaFactory, @GerritServerConfig Config cfg, NotesMigration notesMigration, ChangeNotes.Factory changeNotesFactory, ChangeData.Factory changeDataFactory, ThreadLocalRequestContext context, DynamicSet<ChangeIndexedListener> indexedListeners, StalenessChecker stalenessChecker, @IndexExecutor(value=QueueProvider.QueueType.BATCH) ListeningExecutorService batchExecutor, @Assisted ListeningExecutorService executor, @Assisted ChangeIndexCollection indexes) {
        this.executor = executor;
        this.schemaFactory = schemaFactory;
        this.notesMigration = notesMigration;
        this.changeNotesFactory = changeNotesFactory;
        this.changeDataFactory = changeDataFactory;
        this.context = context;
        this.indexedListeners = indexedListeners;
        this.stalenessChecker = stalenessChecker;
        this.batchExecutor = batchExecutor;
        this.autoReindexIfStale = ChangeIndexer.autoReindexIfStale(cfg);
        this.index = null;
        this.indexes = indexes;
    }

    private static boolean autoReindexIfStale(Config cfg) {
        return cfg.getBoolean("index", null, "autoReindexIfStale", false);
    }

    public CheckedFuture<?, IOException> indexAsync(Project.NameKey project, Change.Id id) {
        return this.submit(new IndexTask(project, id));
    }

    public CheckedFuture<?, IOException> indexAsync(Project.NameKey project, Collection<Change.Id> ids) {
        ArrayList futures = new ArrayList(ids.size());
        for (Change.Id id : ids) {
            futures.add(this.indexAsync(project, id));
        }
        return ChangeIndexer.allAsList(futures);
    }

    public void index(ChangeData cd) throws IOException {
        for (Index index : this.getWriteIndexes()) {
            index.replace(cd);
        }
        this.fireChangeIndexedEvent(cd.getId().get());
        this.autoReindexIfStale(cd);
    }

    private void fireChangeIndexedEvent(int id) {
        for (ChangeIndexedListener listener : this.indexedListeners) {
            try {
                listener.onChangeIndexed(id);
            }
            catch (Exception e) {
                EventUtil.logEventListenerError(listener, e);
            }
        }
    }

    private void fireChangeDeletedFromIndexEvent(int id) {
        for (ChangeIndexedListener listener : this.indexedListeners) {
            try {
                listener.onChangeDeleted(id);
            }
            catch (Exception e) {
                EventUtil.logEventListenerError(listener, e);
            }
        }
    }

    public void index(ReviewDb db, Change change) throws IOException, OrmException {
        this.index(this.newChangeData(db, change));
        this.autoReindexIfStale(change.getProject(), change.getId());
    }

    public void index(ReviewDb db, Project.NameKey project, Change.Id changeId) throws IOException, OrmException {
        ChangeData cd = this.newChangeData(db, project, changeId);
        this.index(cd);
        this.autoReindexIfStale(cd);
    }

    public CheckedFuture<?, IOException> deleteAsync(Change.Id id) {
        return this.submit(new DeleteTask(id));
    }

    public void delete(Change.Id id) throws IOException {
        new DeleteTask(id).call();
    }

    public CheckedFuture<Boolean, IOException> reindexIfStale(Project.NameKey project, Change.Id id) {
        return ChangeIndexer.submit(new ReindexIfStaleTask(project, id), this.batchExecutor);
    }

    private void autoReindexIfStale(ChangeData cd) throws IOException {
        try {
            this.autoReindexIfStale(cd.project(), cd.getId());
        }
        catch (OrmException e) {
            throw new IOException(e);
        }
    }

    private void autoReindexIfStale(Project.NameKey project, Change.Id id) {
        if (this.autoReindexIfStale) {
            CheckedFuture<Boolean, IOException> checkedFuture = this.reindexIfStale(project, id);
        }
    }

    private Collection<ChangeIndex> getWriteIndexes() {
        return this.indexes != null ? this.indexes.getWriteIndexes() : Collections.singleton(this.index);
    }

    private <T> CheckedFuture<T, IOException> submit(Callable<T> task) {
        return ChangeIndexer.submit(task, this.executor);
    }

    private static <T> CheckedFuture<T, IOException> submit(Callable<T> task, ListeningExecutorService executor) {
        return Futures.makeChecked(Futures.nonCancellationPropagating(executor.submit((Callable)task)), MAPPER);
    }

    private boolean isCausedByRepositoryNotFoundException(Throwable throwable) {
        while (throwable != null) {
            if (throwable instanceof RepositoryNotFoundException) {
                return true;
            }
            throwable = throwable.getCause();
        }
        return false;
    }

    private ChangeData newChangeData(ReviewDb db, Change change) throws OrmException {
        if (!this.notesMigration.readChanges()) {
            ChangeNotes notes = this.changeNotesFactory.createWithAutoRebuildingDisabled(change, null);
            return this.changeDataFactory.create(db, notes);
        }
        return this.changeDataFactory.create(db, change);
    }

    private ChangeData newChangeData(ReviewDb db, Project.NameKey project, Change.Id changeId) throws OrmException {
        if (!this.notesMigration.readChanges()) {
            ChangeNotes notes = this.changeNotesFactory.createWithAutoRebuildingDisabled(db, project, changeId);
            return this.changeDataFactory.create(db, notes);
        }
        return this.changeDataFactory.create(db, project, changeId);
    }

    private class ReindexIfStaleTask
    extends AbstractIndexTask<Boolean> {
        private ReindexIfStaleTask(Project.NameKey project, Change.Id id) {
            super(project, id);
        }

        @Override
        public Boolean callImpl(Provider<ReviewDb> db) throws Exception {
            try {
                if (ChangeIndexer.this.stalenessChecker.isStale(this.id)) {
                    ChangeIndexer.this.index(ChangeIndexer.this.newChangeData(db.get(), this.project, this.id));
                    return true;
                }
            }
            catch (NoSuchChangeException nsce) {
                log.debug("Change {} was deleted, aborting reindexing the change.", (Object)this.id.get());
            }
            catch (Exception e) {
                if (!ChangeIndexer.this.isCausedByRepositoryNotFoundException(e)) {
                    throw e;
                }
                log.debug("Change {} belongs to deleted project {}, aborting reindexing the change.", (Object)this.id.get(), (Object)this.project.get());
            }
            return false;
        }

        @Override
        public String toString() {
            return "reindex-if-stale-change-" + this.id;
        }
    }

    private class DeleteTask
    implements Callable<Void> {
        private final Change.Id id;

        private DeleteTask(Change.Id id) {
            this.id = id;
        }

        @Override
        public Void call() throws IOException {
            for (ChangeIndex i : ChangeIndexer.this.getWriteIndexes()) {
                i.delete(this.id);
            }
            log.info("Deleted change {} from index.", (Object)this.id.get());
            ChangeIndexer.this.fireChangeDeletedFromIndexEvent(this.id.get());
            return null;
        }
    }

    private class IndexTask
    extends AbstractIndexTask<Void> {
        private IndexTask(Project.NameKey project, Change.Id id) {
            super(project, id);
        }

        @Override
        public Void callImpl(Provider<ReviewDb> db) throws Exception {
            ChangeData cd = ChangeIndexer.this.newChangeData(db.get(), this.project, this.id);
            ChangeIndexer.this.index(cd);
            return null;
        }

        @Override
        public String toString() {
            return "index-change-" + this.id;
        }
    }

    private abstract class AbstractIndexTask<T>
    implements Callable<T> {
        protected final Project.NameKey project;
        protected final Change.Id id;

        protected AbstractIndexTask(Project.NameKey project, Change.Id id) {
            this.project = project;
            this.id = id;
        }

        protected abstract T callImpl(Provider<ReviewDb> var1) throws Exception;

        public abstract String toString();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public final T call() throws Exception {
            try {
                final AtomicReference dbRef = Atomics.newReference();
                RequestContext newCtx = new RequestContext(){

                    @Override
                    public Provider<ReviewDb> getReviewDbProvider() {
                        Provider<ReviewDb> db = (Provider<ReviewDb>)dbRef.get();
                        if (db == null) {
                            try {
                                db = Providers.of((ReviewDb)ChangeIndexer.this.schemaFactory.open());
                            }
                            catch (OrmException e) {
                                ProvisionException pe = new ProvisionException("error opening ReviewDb");
                                pe.initCause(e);
                                throw pe;
                            }
                            dbRef.set(db);
                        }
                        return db;
                    }

                    @Override
                    public CurrentUser getUser() {
                        throw new OutOfScopeException("No user during ChangeIndexer");
                    }
                };
                RequestContext oldCtx = ChangeIndexer.this.context.setContext(newCtx);
                try {
                    T t = this.callImpl(newCtx.getReviewDbProvider());
                    return t;
                }
                finally {
                    ChangeIndexer.this.context.setContext(oldCtx);
                    Provider db = (Provider)dbRef.get();
                    if (db != null) {
                        ((ReviewDb)db.get()).close();
                    }
                }
            }
            catch (Exception e) {
                log.error("Failed to execute " + this, e);
                throw e;
            }
        }
    }

    public static interface Factory {
        public ChangeIndexer create(ListeningExecutorService var1, ChangeIndex var2);

        public ChangeIndexer create(ListeningExecutorService var1, ChangeIndexCollection var2);
    }
}

