/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.mail.receive;

import com.google.common.base.Strings;
import com.google.common.collect.Iterators;
import com.google.common.collect.PeekingIterator;
import com.google.gerrit.reviewdb.client.Comment;
import com.google.gerrit.server.mail.receive.MailComment;
import com.google.gerrit.server.mail.receive.MailMessage;
import com.google.gerrit.server.mail.receive.ParserUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class TextParser {
    public static List<MailComment> parse(MailMessage email, Collection<Comment> comments, String changeUrl) {
        String body = email.textContent();
        body = body.replace("\r\n", "\n");
        ArrayList<MailComment> parsedComments = new ArrayList<MailComment>();
        String singleQuotePattern = "\n> ";
        String doubleQuotePattern = "\n>> ";
        if (TextParser.countOccurrences(body, doubleQuotePattern) > TextParser.countOccurrences(body, singleQuotePattern)) {
            body = body.replace(doubleQuotePattern, singleQuotePattern);
        }
        PeekingIterator<Comment> iter = Iterators.peekingIterator(comments.iterator());
        String[] lines = body.split("\n");
        MailComment currentComment = null;
        String lastEncounteredFileName = null;
        Comment lastEncounteredComment = null;
        for (String line : lines) {
            if (line.equals(">")) continue;
            if (line.startsWith("> ")) {
                line = line.substring("> ".length()).trim();
                if (currentComment != null) {
                    if (currentComment.type == MailComment.CommentType.CHANGE_MESSAGE) {
                        currentComment.message = ParserUtil.trimQuotation(currentComment.message);
                    }
                    if (!Strings.isNullOrEmpty(currentComment.message)) {
                        parsedComments.add(currentComment);
                    }
                    currentComment = null;
                }
                if (!iter.hasNext()) continue;
                Comment perspectiveComment = iter.peek();
                if (line.equals(ParserUtil.filePath(changeUrl, perspectiveComment))) {
                    if (lastEncounteredFileName == null || !lastEncounteredFileName.equals(perspectiveComment.key.filename)) {
                        lastEncounteredFileName = perspectiveComment.key.filename;
                        lastEncounteredComment = null;
                        continue;
                    }
                    if (perspectiveComment.lineNbr != 0) continue;
                    lastEncounteredComment = perspectiveComment;
                    iter.next();
                    continue;
                }
                if (!ParserUtil.isCommentUrl(line, changeUrl, perspectiveComment)) continue;
                lastEncounteredComment = perspectiveComment;
                iter.next();
                continue;
            }
            if (currentComment == null) {
                currentComment = new MailComment();
                currentComment.message = line;
                if (lastEncounteredComment == null) {
                    if (lastEncounteredFileName == null) {
                        currentComment.type = MailComment.CommentType.CHANGE_MESSAGE;
                        continue;
                    }
                    currentComment.type = MailComment.CommentType.FILE_COMMENT;
                    currentComment.fileName = lastEncounteredFileName;
                    continue;
                }
                currentComment.inReplyTo = lastEncounteredComment;
                currentComment.type = MailComment.CommentType.INLINE_COMMENT;
                continue;
            }
            currentComment.message = currentComment.message + "\n" + line;
        }
        return parsedComments;
    }

    private static int countOccurrences(String s, String pattern) {
        return (s.length() - s.replace(pattern, "").length()) / pattern.length();
    }
}

