/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.mail.send;

import com.google.common.collect.ListMultimap;
import com.google.gerrit.common.errors.EmailException;
import com.google.gerrit.extensions.api.changes.NotifyHandling;
import com.google.gerrit.extensions.api.changes.RecipientType;
import com.google.gerrit.reviewdb.client.Account;
import com.google.gerrit.reviewdb.client.AccountGroup;
import com.google.gerrit.reviewdb.client.Change;
import com.google.gerrit.reviewdb.client.ChangeMessage;
import com.google.gerrit.reviewdb.client.Patch;
import com.google.gerrit.reviewdb.client.PatchSet;
import com.google.gerrit.reviewdb.client.PatchSetInfo;
import com.google.gerrit.reviewdb.client.Project;
import com.google.gerrit.server.IdentifiedUser;
import com.google.gerrit.server.account.AccountState;
import com.google.gerrit.server.account.WatchConfig;
import com.google.gerrit.server.mail.send.EmailArguments;
import com.google.gerrit.server.mail.send.NotificationEmail;
import com.google.gerrit.server.mail.send.ProjectWatch;
import com.google.gerrit.server.notedb.ReviewerStateInternal;
import com.google.gerrit.server.patch.PatchList;
import com.google.gerrit.server.patch.PatchListEntry;
import com.google.gerrit.server.patch.PatchListNotAvailableException;
import com.google.gerrit.server.patch.PatchSetInfoNotAvailableException;
import com.google.gerrit.server.project.ProjectState;
import com.google.gerrit.server.query.change.ChangeData;
import com.google.gwtorm.server.OrmException;
import java.io.IOException;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.jgit.diff.DiffFormatter;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.util.RawParseUtils;
import org.eclipse.jgit.util.TemporaryBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ChangeEmail
extends NotificationEmail {
    private static final Logger log = LoggerFactory.getLogger(ChangeEmail.class);
    protected final Change change;
    protected final ChangeData changeData;
    protected ListMultimap<Account.Id, String> stars;
    protected PatchSet patchSet;
    protected PatchSetInfo patchSetInfo;
    protected String changeMessage;
    protected Timestamp timestamp;
    protected ProjectState projectState;
    protected Set<Account.Id> authors;
    protected boolean emailOnlyAuthors;
    private static final int HEAP_EST_SIZE = 32768;

    protected static ChangeData newChangeData(EmailArguments ea, Project.NameKey project, Change.Id id) {
        return ea.changeDataFactory.create(ea.db.get(), project, id);
    }

    protected ChangeEmail(EmailArguments ea, String mc, ChangeData cd) throws OrmException {
        super(ea, mc, cd.change().getDest());
        this.changeData = cd;
        this.change = cd.change();
        this.emailOnlyAuthors = false;
    }

    @Override
    public void setFrom(Account.Id id) {
        super.setFrom(id);
        IdentifiedUser user = this.args.identifiedUserFactory.create(id);
        this.emailOnlyAuthors = !user.getCapabilities().canEmailReviewers();
    }

    public void setPatchSet(PatchSet ps) {
        this.patchSet = ps;
    }

    public void setPatchSet(PatchSet ps, PatchSetInfo psi) {
        this.patchSet = ps;
        this.patchSetInfo = psi;
    }

    @Deprecated
    public void setChangeMessage(ChangeMessage cm) {
        this.setChangeMessage(cm.getMessage(), cm.getWrittenOn());
    }

    public void setChangeMessage(String cm, Timestamp t) {
        this.changeMessage = cm;
        this.timestamp = t;
    }

    @Override
    protected void format() throws EmailException {
        this.formatChange();
        this.appendText(this.textTemplate("ChangeFooter"));
        if (this.useHtml()) {
            this.appendHtml(this.soyHtmlTemplate("ChangeFooterHtml"));
        }
        this.formatFooter();
    }

    protected abstract void formatChange() throws EmailException;

    protected void formatFooter() throws EmailException {
    }

    @Override
    protected void init() throws EmailException {
        this.projectState = this.args.projectCache != null ? this.args.projectCache.get(this.change.getProject()) : null;
        if (this.patchSet == null) {
            try {
                this.patchSet = this.changeData.currentPatchSet();
            }
            catch (OrmException err) {
                this.patchSet = null;
            }
        }
        if (this.patchSet != null) {
            this.setHeader("X-Gerrit-PatchSet", this.patchSet.getPatchSetId() + "");
            if (this.patchSetInfo == null) {
                try {
                    this.patchSetInfo = this.args.patchSetInfoFactory.get(this.args.db.get(), this.changeData.notes(), this.patchSet.getId());
                }
                catch (PatchSetInfoNotAvailableException | OrmException err) {
                    this.patchSetInfo = null;
                }
            }
        }
        this.authors = this.getAuthors();
        try {
            this.stars = this.args.starredChangesUtil.byChangeFromIndex(this.change.getId());
        }
        catch (OrmException e) {
            throw new EmailException("Failed to load stars for change " + this.change.getChangeId(), e);
        }
        super.init();
        if (this.timestamp != null) {
            this.setHeader("Date", new Date(this.timestamp.getTime()));
        }
        this.setChangeSubjectHeader();
        this.setHeader("X-Gerrit-Change-Id", "" + this.change.getKey().get());
        this.setHeader("X-Gerrit-Change-Number", "" + this.change.getChangeId());
        this.setChangeUrlHeader();
        this.setCommitIdHeader();
    }

    private void setChangeUrlHeader() {
        String u = this.getChangeUrl();
        if (u != null) {
            this.setHeader("X-Gerrit-ChangeURL", "<" + u + ">");
        }
    }

    private void setCommitIdHeader() {
        if (this.patchSet != null && this.patchSet.getRevision() != null && this.patchSet.getRevision().get() != null && this.patchSet.getRevision().get().length() > 0) {
            this.setHeader("X-Gerrit-Commit", this.patchSet.getRevision().get());
        }
    }

    private void setChangeSubjectHeader() throws EmailException {
        this.setHeader("Subject", this.textTemplate("ChangeSubject"));
    }

    public String getChangeUrl() {
        if (this.getGerritUrl() != null) {
            StringBuilder r = new StringBuilder();
            r.append(this.getGerritUrl());
            r.append(this.change.getChangeId());
            return r.toString();
        }
        return null;
    }

    public String getChangeMessageThreadId() throws EmailException {
        return this.velocify("<gerrit.${change.createdOn.time}.$change.key.get()@$email.gerritHost>");
    }

    protected void formatCoverLetter() {
        String cover = this.getCoverLetter();
        if (!"".equals(cover)) {
            this.appendText(cover);
            this.appendText("\n\n");
        }
    }

    public String getCoverLetter() {
        if (this.changeMessage != null) {
            return this.changeMessage.trim();
        }
        return "";
    }

    protected void formatChangeDetail() {
        this.appendText(this.getChangeDetail());
    }

    public String getChangeDetail() {
        try {
            StringBuilder detail = new StringBuilder();
            if (this.patchSetInfo != null) {
                detail.append(this.patchSetInfo.getMessage().trim()).append("\n");
            } else {
                detail.append(this.change.getSubject().trim()).append("\n");
            }
            if (this.patchSet != null) {
                detail.append("---\n");
                PatchList patchList = this.getPatchList();
                for (PatchListEntry p : patchList.getPatches()) {
                    if (Patch.isMagic(p.getNewName())) continue;
                    detail.append(p.getChangeType().getCode()).append(" ").append(p.getNewName()).append("\n");
                }
                detail.append(MessageFormat.format("{0,choice,0#0 files|1#1 file|1<{0} files} changed, {1,choice,0#0 insertions|1#1 insertion|1<{1} insertions}(+), {2,choice,0#0 deletions|1#1 deletion|1<{2} deletions}(-)\n", patchList.getPatches().size() - 1, patchList.getInsertions(), patchList.getDeletions()));
                detail.append("\n");
            }
            return detail.toString();
        }
        catch (Exception err) {
            log.warn("Cannot format change detail", err);
            return "";
        }
    }

    protected PatchList getPatchList() throws PatchListNotAvailableException {
        if (this.patchSet != null) {
            return this.args.patchListCache.get(this.change, this.patchSet);
        }
        throw new PatchListNotAvailableException("no patchSet specified");
    }

    protected ProjectState getProjectState() {
        return this.projectState;
    }

    protected Set<AccountGroup.UUID> getProjectOwners() {
        ProjectState r = this.args.projectCache.get(this.change.getProject());
        return r != null ? r.getOwners() : Collections.emptySet();
    }

    protected void rcptToAuthors(RecipientType rt) {
        for (Account.Id id : this.authors) {
            this.add(rt, id);
        }
    }

    protected void bccStarredBy() {
        if (!NotifyHandling.ALL.equals((Object)this.notify)) {
            return;
        }
        for (Map.Entry<Account.Id, Collection<String>> e : this.stars.asMap().entrySet()) {
            if (!e.getValue().contains("star")) continue;
            super.add(RecipientType.BCC, e.getKey());
        }
    }

    protected void removeUsersThatIgnoredTheChange() {
        for (Map.Entry<Account.Id, Collection<String>> e : this.stars.asMap().entrySet()) {
            AccountState accountState;
            if (!e.getValue().contains("ignore") || (accountState = this.args.accountCache.get(e.getKey())) == null) continue;
            this.removeUser(accountState.getAccount());
        }
    }

    @Override
    protected final ProjectWatch.Watchers getWatchers(WatchConfig.NotifyType type, boolean includeWatchersFromNotifyConfig) throws OrmException {
        if (!NotifyHandling.ALL.equals((Object)this.notify)) {
            return new ProjectWatch.Watchers();
        }
        ProjectWatch watch = new ProjectWatch(this.args, this.branch.getParentKey(), this.projectState, this.changeData);
        return watch.getWatchers(type, includeWatchersFromNotifyConfig);
    }

    protected void ccAllApprovals() {
        if (!NotifyHandling.ALL.equals((Object)this.notify) && !NotifyHandling.OWNER_REVIEWERS.equals((Object)this.notify)) {
            return;
        }
        try {
            for (Account.Id id : this.changeData.reviewers().all()) {
                this.add(RecipientType.CC, id);
            }
        }
        catch (OrmException err) {
            log.warn("Cannot CC users that reviewed updated change", err);
        }
    }

    protected void ccExistingReviewers() {
        if (!NotifyHandling.ALL.equals((Object)this.notify) && !NotifyHandling.OWNER_REVIEWERS.equals((Object)this.notify)) {
            return;
        }
        try {
            for (Account.Id id : this.changeData.reviewers().byState(ReviewerStateInternal.REVIEWER)) {
                this.add(RecipientType.CC, id);
            }
        }
        catch (OrmException err) {
            log.warn("Cannot CC users that commented on updated change", err);
        }
    }

    @Override
    protected void add(RecipientType rt, Account.Id to) {
        if (!this.emailOnlyAuthors || this.authors.contains(to)) {
            super.add(rt, to);
        }
    }

    @Override
    protected boolean isVisibleTo(Account.Id to) throws OrmException {
        return this.projectState == null || this.projectState.controlFor(this.args.identifiedUserFactory.create(to)).controlFor(this.args.db.get(), this.change).isVisible(this.args.db.get());
    }

    protected Set<Account.Id> getAuthors() {
        HashSet<Account.Id> authors = new HashSet<Account.Id>();
        switch (this.notify) {
            case NONE: {
                break;
            }
            default: {
                if (this.patchSet != null) {
                    authors.add(this.patchSet.getUploader());
                }
                if (this.patchSetInfo != null) {
                    if (this.patchSetInfo.getAuthor().getAccount() != null) {
                        authors.add(this.patchSetInfo.getAuthor().getAccount());
                    }
                    if (this.patchSetInfo.getCommitter().getAccount() != null) {
                        authors.add(this.patchSetInfo.getCommitter().getAccount());
                    }
                }
            }
            case OWNER_REVIEWERS: 
            case OWNER: {
                authors.add(this.change.getOwner());
            }
        }
        return authors;
    }

    @Override
    protected void setupVelocityContext() {
        super.setupVelocityContext();
        this.velocityContext.put("change", this.change);
        this.velocityContext.put("changeId", this.change.getKey());
        this.velocityContext.put("coverLetter", this.getCoverLetter());
        this.velocityContext.put("fromName", this.getNameFor(this.fromId));
        this.velocityContext.put("patchSet", this.patchSet);
        this.velocityContext.put("patchSetInfo", this.patchSetInfo);
    }

    @Override
    protected void setupSoyContext() {
        super.setupSoyContext();
        this.soyContext.put("changeId", this.change.getKey().get());
        this.soyContext.put("coverLetter", this.getCoverLetter());
        this.soyContext.put("fromName", this.getNameFor(this.fromId));
        this.soyContext.put("fromEmail", this.getNameEmailFor(this.fromId));
        this.soyContextEmailData.put("unifiedDiff", this.getUnifiedDiff());
        this.soyContextEmailData.put("changeDetail", this.getChangeDetail());
        this.soyContextEmailData.put("changeUrl", this.getChangeUrl());
        this.soyContextEmailData.put("includeDiff", this.getIncludeDiff());
        HashMap<String, String> changeData = new HashMap<String, String>();
        changeData.put("subject", this.change.getSubject());
        changeData.put("originalSubject", this.change.getOriginalSubject());
        changeData.put("ownerName", this.getNameFor(this.change.getOwner()));
        changeData.put("ownerEmail", this.getNameEmailFor(this.change.getOwner()));
        changeData.put("changeNumber", Integer.toString(this.change.getChangeId()));
        this.soyContext.put("change", changeData);
        String subject = this.change.getSubject();
        changeData.put("subject", subject);
        if (subject.length() < 73) {
            changeData.put("shortSubject", subject);
        } else {
            changeData.put("shortSubject", subject.substring(0, 69) + "...");
        }
        HashMap<String, Object> patchSetData = new HashMap<String, Object>();
        patchSetData.put("patchSetId", this.patchSet.getPatchSetId());
        patchSetData.put("refName", this.patchSet.getRefName());
        this.soyContext.put("patchSet", patchSetData);
        this.footers.add("Gerrit-MessageType: " + this.messageClass);
        this.footers.add("Gerrit-Change-Id: " + this.change.getKey().get());
        this.footers.add("Gerrit-Change-Number: " + Integer.toString(this.change.getChangeId()));
        this.footers.add("Gerrit-PatchSet: " + this.patchSet.getPatchSetId());
        this.footers.add("Gerrit-Owner: " + this.getNameEmailFor(this.change.getOwner()));
        for (String reviewer : this.getEmailsByState(ReviewerStateInternal.REVIEWER)) {
            this.footers.add("Gerrit-Reviewer: " + reviewer);
        }
        for (String reviewer : this.getEmailsByState(ReviewerStateInternal.CC)) {
            this.footers.add("Gerrit-CC: " + reviewer);
        }
    }

    private Set<String> getEmailsByState(ReviewerStateInternal state) {
        TreeSet<String> reviewers = new TreeSet<String>();
        try {
            for (Account.Id who : this.changeData.reviewers().byState(state)) {
                reviewers.add(this.getNameEmailFor(who));
            }
        }
        catch (OrmException e) {
            log.warn("Cannot get change reviewers", e);
        }
        return reviewers;
    }

    public boolean getIncludeDiff() {
        return this.args.settings.includeDiff;
    }

    /*
     * Loose catch block
     */
    public String getUnifiedDiff() {
        PatchList patchList;
        try {
            patchList = this.getPatchList();
            if (patchList.getOldId() == null) {
                return "[Octopus merge; cannot be formatted as a diff.]\n";
            }
        }
        catch (PatchListNotAvailableException e) {
            log.error("Cannot format patch", e);
            return "";
        }
        int maxSize = this.args.settings.maximumDiffSize;
        TemporaryBuffer.Heap buf = new TemporaryBuffer.Heap(Math.min(32768, maxSize), maxSize);
        DiffFormatter fmt = new DiffFormatter(buf);
        Repository git = this.args.server.openRepository(this.change.getProject());
        try {
            fmt.setRepository(git);
            fmt.setDetectRenames(true);
            fmt.format(patchList.getOldId(), patchList.getNewId());
            String string = RawParseUtils.decode(buf.toByteArray());
            if (git != null) {
                git.close();
            }
            fmt.close();
            return string;
        }
        catch (IOException e) {
            block24: {
                if (!JGitText.get().inMemoryBufferLimitExceeded.equals(e.getMessage())) break block24;
                String string = "";
                if (git != null) {
                    git.close();
                }
                fmt.close();
                return string;
            }
            log.error("Cannot format patch", e);
            String string = "";
            if (git != null) {
                git.close();
            }
            fmt.close();
            return string;
            {
                catch (Throwable throwable) {
                    try {
                        try {
                            if (git != null) {
                                try {
                                    git.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        catch (IOException e2) {
                            log.error("Cannot open repository to format patch", e2);
                            String string2 = "";
                            return string2;
                        }
                    }
                    catch (Throwable throwable3) {
                        throw throwable3;
                    }
                    finally {
                        fmt.close();
                    }
                }
            }
        }
    }
}

