/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.mail.send;

import com.google.common.base.Strings;
import com.google.gerrit.common.data.GroupDescription;
import com.google.gerrit.common.data.GroupDescriptions;
import com.google.gerrit.common.data.GroupReference;
import com.google.gerrit.reviewdb.client.Account;
import com.google.gerrit.reviewdb.client.AccountGroup;
import com.google.gerrit.reviewdb.client.AccountGroupMember;
import com.google.gerrit.reviewdb.client.Project;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.CurrentUser;
import com.google.gerrit.server.IdentifiedUser;
import com.google.gerrit.server.account.AccountState;
import com.google.gerrit.server.account.WatchConfig;
import com.google.gerrit.server.git.NotifyConfig;
import com.google.gerrit.server.mail.Address;
import com.google.gerrit.server.mail.send.EmailArguments;
import com.google.gerrit.server.project.ProjectState;
import com.google.gerrit.server.query.Predicate;
import com.google.gerrit.server.query.QueryParseException;
import com.google.gerrit.server.query.change.ChangeData;
import com.google.gerrit.server.query.change.ChangeQueryBuilder;
import com.google.gerrit.server.query.change.SingleGroupUser;
import com.google.gwtorm.server.OrmException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProjectWatch {
    private static final Logger log = LoggerFactory.getLogger(ProjectWatch.class);
    protected final EmailArguments args;
    protected final ProjectState projectState;
    protected final Project.NameKey project;
    protected final ChangeData changeData;

    public ProjectWatch(EmailArguments args, Project.NameKey project, ProjectState projectState, ChangeData changeData) {
        this.args = args;
        this.project = project;
        this.projectState = projectState;
        this.changeData = changeData;
    }

    public final Watchers getWatchers(WatchConfig.NotifyType type, boolean includeWatchersFromNotifyConfig) throws OrmException {
        Watchers matching = new Watchers();
        HashSet<Account.Id> projectWatchers = new HashSet<Account.Id>();
        for (AccountState a : this.args.accountQueryProvider.get().byWatchedProject(this.project)) {
            Account.Id accountId = a.getAccount().getId();
            for (Map.Entry<WatchConfig.ProjectWatchKey, Set<WatchConfig.NotifyType>> e : a.getProjectWatches().entrySet()) {
                if (!this.project.equals(e.getKey().project()) || !this.add(matching, accountId, e.getKey(), e.getValue(), type)) continue;
                projectWatchers.add(accountId);
            }
        }
        for (AccountState a : this.args.accountQueryProvider.get().byWatchedProject(this.args.allProjectsName)) {
            for (Map.Entry<WatchConfig.ProjectWatchKey, Set<WatchConfig.NotifyType>> e : a.getProjectWatches().entrySet()) {
                Account.Id accountId;
                if (!this.args.allProjectsName.equals(e.getKey().project()) || projectWatchers.contains(accountId = a.getAccount().getId())) continue;
                this.add(matching, accountId, e.getKey(), e.getValue(), type);
            }
        }
        if (!includeWatchersFromNotifyConfig) {
            return matching;
        }
        for (ProjectState state : this.projectState.tree()) {
            for (NotifyConfig nc : state.getConfig().getNotifyConfigs()) {
                if (!nc.isNotify(type)) continue;
                try {
                    this.add(matching, nc);
                }
                catch (QueryParseException e) {
                    log.warn("Project {} has invalid notify {} filter \"{}\": {}", state.getProject().getName(), nc.getName(), nc.getFilter(), e.getMessage());
                }
            }
        }
        return matching;
    }

    private void add(Watchers matching, NotifyConfig nc) throws OrmException, QueryParseException {
        for (GroupReference ref : nc.getGroups()) {
            SingleGroupUser user = new SingleGroupUser(this.args.capabilityControlFactory, ref.getUUID());
            if (!this.filterMatch(user, nc.getFilter())) continue;
            this.deliverToMembers(matching.list(nc.getHeader()), ref.getUUID());
        }
        if (!nc.getAddresses().isEmpty() && this.filterMatch(null, nc.getFilter())) {
            matching.list((NotifyConfig.Header)nc.getHeader()).emails.addAll(nc.getAddresses());
        }
    }

    private void deliverToMembers(Watchers.List matching, AccountGroup.UUID startUUID) throws OrmException {
        ReviewDb db = this.args.db.get();
        HashSet<AccountGroup.UUID> seen = new HashSet<AccountGroup.UUID>();
        ArrayList<AccountGroup.UUID> q = new ArrayList<AccountGroup.UUID>();
        seen.add(startUUID);
        q.add(startUUID);
        while (!q.isEmpty()) {
            AccountGroup.UUID uuid = (AccountGroup.UUID)q.remove(q.size() - 1);
            GroupDescription.Basic group = this.args.groupBackend.get(uuid);
            if (!Strings.isNullOrEmpty(group.getEmailAddress())) {
                matching.emails.add(new Address(group.getEmailAddress()));
                continue;
            }
            AccountGroup ig = GroupDescriptions.toAccountGroup(group);
            if (ig == null) continue;
            for (AccountGroupMember accountGroupMember : db.accountGroupMembers().byGroup(ig.getId())) {
                matching.accounts.add(accountGroupMember.getAccountId());
            }
            for (AccountGroup.UUID uUID : this.args.groupIncludes.subgroupsOf(uuid)) {
                if (!seen.add(uUID)) continue;
                q.add(uUID);
            }
        }
    }

    private boolean add(Watchers matching, Account.Id accountId, WatchConfig.ProjectWatchKey key, Set<WatchConfig.NotifyType> watchedTypes, WatchConfig.NotifyType type) throws OrmException {
        IdentifiedUser user = this.args.identifiedUserFactory.create(accountId);
        try {
            if (this.filterMatch(user, key.filter())) {
                if (watchedTypes.contains((Object)type)) {
                    matching.bcc.accounts.add(accountId);
                }
                return true;
            }
        }
        catch (QueryParseException queryParseException) {
            // empty catch block
        }
        return false;
    }

    private boolean filterMatch(CurrentUser user, String filter) throws OrmException, QueryParseException {
        ChangeQueryBuilder qb;
        Predicate<ChangeData> p = null;
        if (user == null) {
            qb = this.args.queryBuilder.asUser(this.args.anonymousUser);
        } else {
            qb = this.args.queryBuilder.asUser(user);
            p = qb.is_visible();
        }
        if (filter != null) {
            Predicate filterPredicate = qb.parse(filter);
            p = p == null ? filterPredicate : Predicate.and(filterPredicate, p);
        }
        return p == null || p.asMatchable().match(this.changeData);
    }

    public static class Watchers {
        protected final List to = new List();
        protected final List cc = new List();
        protected final List bcc = new List();

        List list(NotifyConfig.Header header) {
            switch (header) {
                case TO: {
                    return this.to;
                }
                case CC: {
                    return this.cc;
                }
            }
            return this.bcc;
        }

        static class List {
            protected final Set<Account.Id> accounts = new HashSet<Account.Id>();
            protected final Set<Address> emails = new HashSet<Address>();

            List() {
            }
        }
    }
}

