/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.mail.send;

import com.google.gerrit.common.errors.EmailException;
import com.google.gerrit.extensions.api.changes.RecipientType;
import com.google.gerrit.reviewdb.client.Account;
import com.google.gerrit.reviewdb.client.Change;
import com.google.gerrit.reviewdb.client.Project;
import com.google.gerrit.server.mail.send.ChangeEmail;
import com.google.gerrit.server.mail.send.EmailArguments;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import com.google.inject.assistedinject.Assisted;

public class SetAssigneeSender
extends ChangeEmail {
    private final Account.Id assignee;

    @Inject
    public SetAssigneeSender(EmailArguments ea, @Assisted Project.NameKey project, @Assisted Change.Id id, @Assisted Account.Id assignee) throws OrmException {
        super(ea, "setassignee", SetAssigneeSender.newChangeData(ea, project, id));
        this.assignee = assignee;
    }

    @Override
    protected void init() throws EmailException {
        super.init();
        this.add(RecipientType.TO, this.assignee);
    }

    @Override
    protected void formatChange() throws EmailException {
        this.appendText(this.textTemplate("SetAssignee"));
        if (this.useHtml()) {
            this.appendHtml(this.soyHtmlTemplate("SetAssigneeHtml"));
        }
    }

    public String getAssigneeName() {
        return this.getNameFor(this.assignee);
    }

    @Override
    protected void setupSoyContext() {
        super.setupSoyContext();
        this.soyContextEmailData.put("assigneeName", this.getAssigneeName());
    }

    @Override
    protected boolean supportsHtml() {
        return true;
    }

    public static interface Factory {
        public SetAssigneeSender create(Project.NameKey var1, Change.Id var2, Account.Id var3);
    }
}

