/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.notedb;

import com.google.common.primitives.Bytes;
import com.google.gerrit.reviewdb.client.Change;
import com.google.gerrit.reviewdb.client.Comment;
import com.google.gerrit.reviewdb.client.PatchLineComment;
import com.google.gerrit.server.notedb.ChangeNoteUtil;
import com.google.gerrit.server.notedb.ChangeNotes;
import com.google.gerrit.server.notedb.RevisionNote;
import com.google.gerrit.server.notedb.RevisionNoteData;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.eclipse.jgit.errors.ConfigInvalidException;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.util.MutableInteger;
import org.eclipse.jgit.util.RawParseUtils;

class ChangeRevisionNote
extends RevisionNote<Comment> {
    private static final byte[] CERT_HEADER = "certificate version ".getBytes(StandardCharsets.UTF_8);
    private static final byte[] END_SIGNATURE = "-----END PGP SIGNATURE-----\n".getBytes(StandardCharsets.UTF_8);
    private final ChangeNoteUtil noteUtil;
    private final Change.Id changeId;
    private final PatchLineComment.Status status;
    private String pushCert;

    ChangeRevisionNote(ChangeNoteUtil noteUtil, Change.Id changeId, ObjectReader reader, ObjectId noteId, PatchLineComment.Status status) {
        super(reader, noteId);
        this.noteUtil = noteUtil;
        this.changeId = changeId;
        this.status = status;
    }

    public String getPushCert() {
        this.checkParsed();
        return this.pushCert;
    }

    @Override
    protected List<Comment> parse(byte[] raw, int offset) throws IOException, ConfigInvalidException {
        MutableInteger p = new MutableInteger();
        p.value = offset;
        if (ChangeRevisionNote.isJson(raw, p.value)) {
            RevisionNoteData data = this.parseJson(this.noteUtil, raw, p.value);
            this.pushCert = this.status == PatchLineComment.Status.PUBLISHED ? data.pushCert : null;
            return data.comments;
        }
        if (this.status == PatchLineComment.Status.PUBLISHED) {
            this.pushCert = ChangeRevisionNote.parsePushCert(this.changeId, raw, p);
            ChangeRevisionNote.trimLeadingEmptyLines(raw, p);
        } else {
            this.pushCert = null;
        }
        return this.noteUtil.parseNote(raw, p, this.changeId);
    }

    private static boolean isJson(byte[] raw, int offset) {
        return raw[offset] == 123 || raw[offset] == 91;
    }

    private RevisionNoteData parseJson(ChangeNoteUtil noteUtil, byte[] raw, int offset) throws IOException {
        try (ByteArrayInputStream is = new ByteArrayInputStream(raw, offset, raw.length - offset);){
            RevisionNoteData revisionNoteData;
            try (InputStreamReader r = new InputStreamReader((InputStream)is, StandardCharsets.UTF_8);){
                revisionNoteData = noteUtil.getGson().fromJson((Reader)r, RevisionNoteData.class);
            }
            return revisionNoteData;
        }
    }

    private static String parsePushCert(Change.Id changeId, byte[] bytes, MutableInteger p) throws ConfigInvalidException {
        if (RawParseUtils.match(bytes, p.value, CERT_HEADER) < 0) {
            return null;
        }
        int end = Bytes.indexOf(bytes, END_SIGNATURE);
        if (end < 0) {
            throw ChangeNotes.parseException(changeId, "invalid push certificate in note", new Object[0]);
        }
        int start = p.value;
        p.value = end + END_SIGNATURE.length;
        return new String(bytes, start, p.value, StandardCharsets.UTF_8);
    }
}

