/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.patch;

import com.google.common.base.Throwables;
import com.google.gerrit.server.config.ConfigUtil;
import com.google.gerrit.server.config.GerritServerConfig;
import com.google.gerrit.server.patch.CharText;
import com.google.gerrit.server.patch.CharTextComparator;
import com.google.gerrit.server.patch.DiffExecutor;
import com.google.gerrit.server.patch.IntraLineDiff;
import com.google.gerrit.server.patch.IntraLineDiffArgs;
import com.google.gerrit.server.patch.IntraLineDiffKey;
import com.google.gerrit.server.patch.Text;
import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.regex.Pattern;
import org.eclipse.jgit.diff.Edit;
import org.eclipse.jgit.diff.EditList;
import org.eclipse.jgit.diff.MyersDiff;
import org.eclipse.jgit.diff.ReplaceEdit;
import org.eclipse.jgit.lib.Config;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class IntraLineLoader
implements Callable<IntraLineDiff> {
    static final Logger log = LoggerFactory.getLogger(IntraLineLoader.class);
    private static final Pattern BLANK_LINE_RE = Pattern.compile("^[ \\t]*(|[{}]|/\\*\\*?|\\*)[ \\t]*$");
    private static final Pattern CONTROL_BLOCK_START_RE = Pattern.compile("[{:][ \\t]*$");
    private final ExecutorService diffExecutor;
    private final long timeoutMillis;
    private final IntraLineDiffKey key;
    private final IntraLineDiffArgs args;

    @AssistedInject
    IntraLineLoader(@DiffExecutor ExecutorService diffExecutor, @GerritServerConfig Config cfg, @Assisted IntraLineDiffKey key, @Assisted IntraLineDiffArgs args) {
        this.diffExecutor = diffExecutor;
        this.timeoutMillis = ConfigUtil.getTimeUnit(cfg, "cache", "diff_intraline", "timeout", TimeUnit.MILLISECONDS.convert(5L, TimeUnit.SECONDS), TimeUnit.MILLISECONDS);
        this.key = key;
        this.args = args;
    }

    @Override
    public IntraLineDiff call() throws Exception {
        Future<IntraLineDiff> result = this.diffExecutor.submit(new Callable<IntraLineDiff>(){

            @Override
            public IntraLineDiff call() throws Exception {
                return IntraLineLoader.compute(IntraLineLoader.this.args.aText(), IntraLineLoader.this.args.bText(), IntraLineLoader.this.args.edits());
            }
        });
        try {
            return result.get(this.timeoutMillis, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException | TimeoutException e) {
            log.warn(this.timeoutMillis + " ms timeout reached for IntraLineDiff in project " + this.args.project() + " on commit " + this.args.commit().name() + " for path " + this.args.path() + " comparing " + this.key.getBlobA().name() + ".." + this.key.getBlobB().name());
            result.cancel(true);
            return new IntraLineDiff(IntraLineDiff.Status.TIMEOUT);
        }
        catch (ExecutionException e) {
            Throwables.throwIfInstanceOf(e.getCause(), Exception.class);
            throw new Exception(e.getMessage(), e.getCause());
        }
    }

    static IntraLineDiff compute(Text aText, Text bText, List<Edit> edits) throws Exception {
        IntraLineLoader.combineLineEdits(edits, aText, bText);
        for (int i = 0; i < edits.size(); ++i) {
            Edit c;
            Edit e = edits.get(i);
            if (e.getType() != Edit.Type.REPLACE) continue;
            CharText a = new CharText(aText, e.getBeginA(), e.getEndA());
            CharText b = new CharText(bText, e.getBeginB(), e.getEndB());
            CharTextComparator cmp = new CharTextComparator();
            EditList wordEdits = MyersDiff.INSTANCE.diff(cmp, a, b);
            int j = 0;
            while (j < wordEdits.size() - 1) {
                c = (Edit)wordEdits.get(j);
                Edit n = (Edit)wordEdits.get(j + 1);
                if (n.getBeginA() - c.getEndA() <= 5 || n.getBeginB() - c.getEndB() <= 5) {
                    int ab = c.getBeginA();
                    int ae = n.getEndA();
                    int bb = c.getBeginB();
                    int be = n.getEndB();
                    if (IntraLineLoader.canCoalesce(a, c.getEndA(), n.getBeginA()) && IntraLineLoader.canCoalesce(b, c.getEndB(), n.getBeginB())) {
                        wordEdits.set(j, new Edit(ab, ae, bb, be));
                        wordEdits.remove(j + 1);
                        continue;
                    }
                }
                ++j;
            }
            for (j = 0; j < wordEdits.size(); ++j) {
                Edit p;
                c = (Edit)wordEdits.get(j);
                int ab = c.getBeginA();
                int ae = c.getEndA();
                int bb = c.getBeginB();
                int be = c.getEndB();
                if (1 < j && ((p = (Edit)wordEdits.get(j - 1)).getEndA() == ab || p.getEndB() == bb)) {
                    if (p.getEndA() == ab && p.getBeginA() < p.getEndA()) {
                        ab = p.getBeginA();
                    }
                    if (p.getEndB() == bb && p.getBeginB() < p.getEndB()) {
                        bb = p.getBeginB();
                    }
                    wordEdits.remove(--j);
                }
                while (ab < ae && bb < be && cmp.equals(a, ab, b, bb)) {
                    ++ab;
                    ++bb;
                }
                while (ab < ae && bb < be && cmp.equals(a, ae - 1, b, be - 1)) {
                    --ae;
                    --be;
                }
                while (0 < ab && ab < ae && a.charAt(ab - 1) != '\n' && cmp.equals(a, ab - 1, a, ae - 1)) {
                    --ab;
                    --ae;
                }
                if (!a.isLineStart(ab) || !a.contains(ab, ae, '\n')) {
                    while (ab < ae && ae < a.size() && cmp.equals(a, ab, a, ae)) {
                        ++ab;
                        if (a.charAt(++ae - 1) != '\n') continue;
                    }
                }
                while (0 < bb && bb < be && b.charAt(bb - 1) != '\n' && cmp.equals(b, bb - 1, b, be - 1)) {
                    --bb;
                    --be;
                }
                if (!b.isLineStart(bb) || !b.contains(bb, be, '\n')) {
                    while (bb < be && be < b.size() && cmp.equals(b, bb, b, be)) {
                        ++bb;
                        if (b.charAt(++be - 1) != '\n') continue;
                    }
                }
                if (ab < ae && (ab == 0 || a.charAt(ab - 1) == '\n') && ae < a.size() && a.charAt(ae - 1) != '\n' && a.charAt(ae) == '\n') {
                    ++ae;
                }
                if (bb < be && (bb == 0 || b.charAt(bb - 1) == '\n') && be < b.size() && b.charAt(be - 1) != '\n' && b.charAt(be) == '\n') {
                    ++be;
                }
                wordEdits.set(j, new Edit(ab, ae, bb, be));
            }
            edits.set(i, new ReplaceEdit(e, wordEdits));
        }
        return new IntraLineDiff(edits);
    }

    private static void combineLineEdits(List<Edit> edits, Text a, Text b) {
        int j = 0;
        while (j < edits.size() - 1) {
            Edit c = edits.get(j);
            Edit n = edits.get(j + 1);
            int ad = n.getBeginA() - c.getEndA();
            int bd = n.getBeginB() - c.getEndB();
            if (1 <= ad && IntraLineLoader.isBlankLineGap(a, c.getEndA(), n.getBeginA()) || 1 <= bd && IntraLineLoader.isBlankLineGap(b, c.getEndB(), n.getBeginB()) || ad == 1 && bd == 1 && IntraLineLoader.isControlBlockStart(a, c.getEndA())) {
                int ab = c.getBeginA();
                int ae = n.getEndA();
                int bb = c.getBeginB();
                int be = n.getEndB();
                edits.set(j, new Edit(ab, ae, bb, be));
                edits.remove(j + 1);
                continue;
            }
            ++j;
        }
    }

    private static boolean isBlankLineGap(Text a, int b, int e) {
        while (b < e) {
            if (!BLANK_LINE_RE.matcher(a.getString(b)).matches()) {
                return false;
            }
            ++b;
        }
        return true;
    }

    private static boolean isControlBlockStart(Text a, int idx) {
        return CONTROL_BLOCK_START_RE.matcher(a.getString(idx)).find();
    }

    private static boolean canCoalesce(CharText a, int b, int e) {
        while (b < e) {
            if (a.charAt(b++) != '\n') continue;
            return false;
        }
        return true;
    }

    static interface Factory {
        public IntraLineLoader create(IntraLineDiffKey var1, IntraLineDiffArgs var2);
    }
}

