/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.patch;

import com.google.common.cache.Cache;
import com.google.common.util.concurrent.UncheckedExecutionException;
import com.google.gerrit.extensions.client.DiffPreferencesInfo;
import com.google.gerrit.reviewdb.client.Change;
import com.google.gerrit.reviewdb.client.PatchSet;
import com.google.gerrit.reviewdb.client.Project;
import com.google.gerrit.server.cache.CacheModule;
import com.google.gerrit.server.config.GerritServerConfig;
import com.google.gerrit.server.patch.DiffSummary;
import com.google.gerrit.server.patch.DiffSummaryKey;
import com.google.gerrit.server.patch.DiffSummaryLoader;
import com.google.gerrit.server.patch.DiffSummaryWeigher;
import com.google.gerrit.server.patch.IntraLineDiff;
import com.google.gerrit.server.patch.IntraLineDiffArgs;
import com.google.gerrit.server.patch.IntraLineDiffKey;
import com.google.gerrit.server.patch.IntraLineLoader;
import com.google.gerrit.server.patch.IntraLineWeigher;
import com.google.gerrit.server.patch.PatchList;
import com.google.gerrit.server.patch.PatchListCache;
import com.google.gerrit.server.patch.PatchListKey;
import com.google.gerrit.server.patch.PatchListLoader;
import com.google.gerrit.server.patch.PatchListNotAvailableException;
import com.google.gerrit.server.patch.PatchListWeigher;
import com.google.inject.Inject;
import com.google.inject.Module;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import java.util.concurrent.ExecutionException;
import org.eclipse.jgit.errors.LargeObjectException;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.lib.ObjectId;

@Singleton
public class PatchListCacheImpl
implements PatchListCache {
    static final String FILE_NAME = "diff";
    static final String INTRA_NAME = "diff_intraline";
    static final String DIFF_SUMMARY = "diff_summary";
    private final Cache<PatchListKey, PatchList> fileCache;
    private final Cache<IntraLineDiffKey, IntraLineDiff> intraCache;
    private final Cache<DiffSummaryKey, DiffSummary> diffSummaryCache;
    private final PatchListLoader.Factory fileLoaderFactory;
    private final IntraLineLoader.Factory intraLoaderFactory;
    private final DiffSummaryLoader.Factory diffSummaryLoaderFactory;
    private final boolean computeIntraline;

    public static Module module() {
        return new CacheModule(){

            @Override
            protected void configure() {
                this.factory(PatchListLoader.Factory.class);
                this.persist(PatchListCacheImpl.FILE_NAME, PatchListKey.class, PatchList.class).maximumWeight(0xA00000L).weigher(PatchListWeigher.class);
                this.factory(IntraLineLoader.Factory.class);
                this.persist(PatchListCacheImpl.INTRA_NAME, IntraLineDiffKey.class, IntraLineDiff.class).maximumWeight(0xA00000L).weigher(IntraLineWeigher.class);
                this.factory(DiffSummaryLoader.Factory.class);
                this.persist(PatchListCacheImpl.DIFF_SUMMARY, DiffSummaryKey.class, DiffSummary.class).maximumWeight(0xA00000L).weigher(DiffSummaryWeigher.class).diskLimit(0x40000000L);
                this.bind(PatchListCacheImpl.class);
                this.bind(PatchListCache.class).to(PatchListCacheImpl.class);
            }
        };
    }

    @Inject
    PatchListCacheImpl(@Named(value="diff") Cache<PatchListKey, PatchList> fileCache, @Named(value="diff_intraline") Cache<IntraLineDiffKey, IntraLineDiff> intraCache, @Named(value="diff_summary") Cache<DiffSummaryKey, DiffSummary> diffSummaryCache, PatchListLoader.Factory fileLoaderFactory, IntraLineLoader.Factory intraLoaderFactory, DiffSummaryLoader.Factory diffSummaryLoaderFactory, @GerritServerConfig Config cfg) {
        this.fileCache = fileCache;
        this.intraCache = intraCache;
        this.diffSummaryCache = diffSummaryCache;
        this.fileLoaderFactory = fileLoaderFactory;
        this.intraLoaderFactory = intraLoaderFactory;
        this.diffSummaryLoaderFactory = diffSummaryLoaderFactory;
        this.computeIntraline = cfg.getBoolean("cache", INTRA_NAME, "enabled", cfg.getBoolean("cache", FILE_NAME, "intraline", true));
    }

    @Override
    public PatchList get(PatchListKey key, Project.NameKey project) throws PatchListNotAvailableException {
        try {
            PatchList pl = this.fileCache.get(key, this.fileLoaderFactory.create(key, project));
            return pl;
        }
        catch (ExecutionException e) {
            PatchListLoader.log.warn("Error computing " + key, e);
            throw new PatchListNotAvailableException(e);
        }
        catch (UncheckedExecutionException e) {
            if (e.getCause() instanceof LargeObjectException) {
                PatchListLoader.log.warn("Error computing " + key, e);
                throw new PatchListNotAvailableException(e);
            }
            throw e;
        }
    }

    @Override
    public PatchList get(Change change, PatchSet patchSet) throws PatchListNotAvailableException {
        return this.get(change, patchSet, null);
    }

    @Override
    public ObjectId getOldId(Change change, PatchSet patchSet, Integer parentNum) throws PatchListNotAvailableException {
        return this.get(change, patchSet, parentNum).getOldId();
    }

    private PatchList get(Change change, PatchSet patchSet, Integer parentNum) throws PatchListNotAvailableException {
        Project.NameKey project = change.getProject();
        if (patchSet.getRevision() == null) {
            throw new PatchListNotAvailableException("revision is null for " + patchSet.getId());
        }
        ObjectId b = ObjectId.fromString(patchSet.getRevision().get());
        DiffPreferencesInfo.Whitespace ws = DiffPreferencesInfo.Whitespace.IGNORE_NONE;
        if (parentNum != null) {
            return this.get(PatchListKey.againstParentNum(parentNum, b, ws), project);
        }
        return this.get(PatchListKey.againstDefaultBase(b, ws), project);
    }

    @Override
    public IntraLineDiff getIntraLineDiff(IntraLineDiffKey key, IntraLineDiffArgs args) {
        if (this.computeIntraline) {
            try {
                return this.intraCache.get(key, this.intraLoaderFactory.create(key, args));
            }
            catch (ExecutionException | LargeObjectException e) {
                IntraLineLoader.log.warn("Error computing " + key, e);
                return new IntraLineDiff(IntraLineDiff.Status.ERROR);
            }
        }
        return new IntraLineDiff(IntraLineDiff.Status.DISABLED);
    }

    @Override
    public DiffSummary getDiffSummary(Change change, PatchSet patchSet) throws PatchListNotAvailableException {
        Project.NameKey project = change.getProject();
        ObjectId b = ObjectId.fromString(patchSet.getRevision().get());
        DiffPreferencesInfo.Whitespace ws = DiffPreferencesInfo.Whitespace.IGNORE_NONE;
        return this.getDiffSummary(DiffSummaryKey.fromPatchListKey(PatchListKey.againstDefaultBase(b, ws)), project);
    }

    @Override
    public DiffSummary getDiffSummary(DiffSummaryKey key, Project.NameKey project) throws PatchListNotAvailableException {
        try {
            return this.diffSummaryCache.get(key, this.diffSummaryLoaderFactory.create(key, project));
        }
        catch (ExecutionException e) {
            PatchListLoader.log.warn("Error computing " + key, e);
            throw new PatchListNotAvailableException(e);
        }
        catch (UncheckedExecutionException e) {
            if (e.getCause() instanceof LargeObjectException) {
                PatchListLoader.log.warn("Error computing " + key, e);
                throw new PatchListNotAvailableException(e);
            }
            throw e;
        }
    }
}

