/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.patch;

import com.google.gerrit.reviewdb.client.Account;
import com.google.gerrit.reviewdb.client.PatchSet;
import com.google.gerrit.reviewdb.client.PatchSetInfo;
import com.google.gerrit.reviewdb.client.Project;
import com.google.gerrit.reviewdb.client.RevId;
import com.google.gerrit.reviewdb.client.UserIdentity;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.PatchSetUtil;
import com.google.gerrit.server.account.AccountByEmailCache;
import com.google.gerrit.server.git.GitRepositoryManager;
import com.google.gerrit.server.notedb.ChangeNotes;
import com.google.gerrit.server.patch.PatchSetInfoNotAvailableException;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.io.IOException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;

@Singleton
public class PatchSetInfoFactory {
    private final GitRepositoryManager repoManager;
    private final PatchSetUtil psUtil;
    private final AccountByEmailCache byEmailCache;

    @Inject
    public PatchSetInfoFactory(GitRepositoryManager repoManager, PatchSetUtil psUtil, AccountByEmailCache byEmailCache) {
        this.repoManager = repoManager;
        this.psUtil = psUtil;
        this.byEmailCache = byEmailCache;
    }

    public PatchSetInfo get(RevWalk rw, RevCommit src, PatchSet.Id psi) throws IOException {
        rw.parseBody(src);
        PatchSetInfo info = new PatchSetInfo(psi);
        info.setSubject(src.getShortMessage());
        info.setMessage(src.getFullMessage());
        info.setAuthor(this.toUserIdentity(src.getAuthorIdent()));
        info.setCommitter(this.toUserIdentity(src.getCommitterIdent()));
        info.setRevId(src.getName());
        return info;
    }

    public PatchSetInfo get(ReviewDb db, ChangeNotes notes, PatchSet.Id psId) throws PatchSetInfoNotAvailableException {
        try {
            PatchSet patchSet = this.psUtil.get(db, notes, psId);
            return this.get(notes.getProjectName(), patchSet);
        }
        catch (OrmException e) {
            throw new PatchSetInfoNotAvailableException(e);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public PatchSetInfo get(Project.NameKey project, PatchSet patchSet) throws PatchSetInfoNotAvailableException {
        try (Repository repo = this.repoManager.openRepository(project);){
            RevWalk rw = new RevWalk(repo);
            try {
                RevCommit src = rw.parseCommit(ObjectId.fromString(patchSet.getRevision().get()));
                PatchSetInfo info = this.get(rw, src, patchSet.getId());
                info.setParents(this.toParentInfos(src.getParents(), rw));
                PatchSetInfo patchSetInfo = info;
                rw.close();
                return patchSetInfo;
            }
            catch (Throwable throwable) {
                try {
                    rw.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new PatchSetInfoNotAvailableException(e);
        }
    }

    private UserIdentity toUserIdentity(PersonIdent who) {
        UserIdentity u = new UserIdentity();
        u.setName(who.getName());
        u.setEmail(who.getEmailAddress());
        u.setDate(new Timestamp(who.getWhen().getTime()));
        u.setTimeZone(who.getTimeZoneOffset());
        Set<Account.Id> a = this.byEmailCache.get(u.getEmail());
        if (a.size() == 1) {
            u.setAccount(a.iterator().next());
        }
        return u;
    }

    private List<PatchSetInfo.ParentInfo> toParentInfos(RevCommit[] parents, RevWalk walk) throws IOException, MissingObjectException {
        ArrayList<PatchSetInfo.ParentInfo> pInfos = new ArrayList<PatchSetInfo.ParentInfo>(parents.length);
        for (RevCommit parent : parents) {
            walk.parseBody(parent);
            RevId rev = new RevId(parent.getId().name());
            String msg = parent.getShortMessage();
            pInfos.add(new PatchSetInfo.ParentInfo(rev, msg));
        }
        return pInfos;
    }
}

