/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.plugins;

import com.google.common.base.MoreObjects;
import com.google.gerrit.server.config.PluginConfig;
import com.google.gerrit.server.config.PluginConfigFactory;
import com.google.gerrit.server.config.SitePaths;
import com.google.gerrit.server.plugins.CleanupHandle;
import com.google.gerrit.server.plugins.InvalidPluginException;
import com.google.gerrit.server.plugins.JarScanner;
import com.google.gerrit.server.plugins.Plugin;
import com.google.gerrit.server.plugins.PluginLoader;
import com.google.gerrit.server.plugins.ServerPlugin;
import com.google.gerrit.server.plugins.ServerPluginProvider;
import com.google.inject.Inject;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.eclipse.jgit.internal.storage.file.FileSnapshot;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JarPluginProvider
implements ServerPluginProvider {
    static final String PLUGIN_TMP_PREFIX = "plugin_";
    static final String JAR_EXTENSION = ".jar";
    static final Logger log = LoggerFactory.getLogger(JarPluginProvider.class);
    private final Path tmpDir;
    private final PluginConfigFactory configFactory;

    @Inject
    JarPluginProvider(SitePaths sitePaths, PluginConfigFactory configFactory) {
        this.tmpDir = sitePaths.tmp_dir;
        this.configFactory = configFactory;
    }

    @Override
    public boolean handles(Path srcPath) {
        String fileName = srcPath.getFileName().toString();
        return fileName.endsWith(JAR_EXTENSION) || fileName.endsWith(".jar.disabled");
    }

    @Override
    public String getPluginName(Path srcPath) {
        try {
            return MoreObjects.firstNonNull(JarPluginProvider.getJarPluginName(srcPath), PluginLoader.nameOf(srcPath));
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Invalid plugin file " + srcPath + ": cannot get plugin name", e);
        }
    }

    public static String getJarPluginName(Path srcPath) throws IOException {
        try (JarFile jarFile = new JarFile(srcPath.toFile());){
            String string = jarFile.getManifest().getMainAttributes().getValue("Gerrit-PluginName");
            return string;
        }
    }

    @Override
    public ServerPlugin get(Path srcPath, FileSnapshot snapshot, ServerPluginProvider.PluginDescription description) throws InvalidPluginException {
        ServerPlugin serverPlugin;
        block8: {
            String name = this.getPluginName(srcPath);
            String extension = JarPluginProvider.getExtension(srcPath);
            InputStream in = Files.newInputStream(srcPath, new OpenOption[0]);
            try {
                Path tmp = PluginLoader.asTemp(in, JarPluginProvider.tempNameFor(name), extension, this.tmpDir);
                serverPlugin = this.loadJarPlugin(name, srcPath, snapshot, tmp, description);
                if (in == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new InvalidPluginException("Cannot load Jar plugin " + srcPath, e);
                }
            }
            in.close();
        }
        return serverPlugin;
    }

    @Override
    public String getProviderPluginName() {
        return "gerrit";
    }

    private static String getExtension(Path path) {
        return JarPluginProvider.getExtension(path.getFileName().toString());
    }

    private static String getExtension(String name) {
        int ext = name.lastIndexOf(46);
        return 0 < ext ? name.substring(ext) : "";
    }

    private static String tempNameFor(String name) {
        SimpleDateFormat fmt = new SimpleDateFormat("yyMMdd_HHmm");
        return PLUGIN_TMP_PREFIX + name + "_" + fmt.format(new Date()) + "_";
    }

    public static Path storeInTemp(String pluginName, InputStream in, SitePaths sitePaths) throws IOException {
        if (!Files.exists(sitePaths.tmp_dir, new LinkOption[0])) {
            Files.createDirectories(sitePaths.tmp_dir, new FileAttribute[0]);
        }
        return PluginLoader.asTemp(in, JarPluginProvider.tempNameFor(pluginName), JAR_EXTENSION, sitePaths.tmp_dir);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ServerPlugin loadJarPlugin(String name, Path srcJar, FileSnapshot snapshot, Path tmp, ServerPluginProvider.PluginDescription description) throws IOException, InvalidPluginException, MalformedURLException {
        JarFile jarFile = new JarFile(tmp.toFile());
        boolean keep = false;
        try {
            Path classes;
            Manifest manifest = jarFile.getManifest();
            Plugin.ApiType type = Plugin.getApiType(manifest);
            ArrayList<URL> urls = new ArrayList<URL>(2);
            String overlay = System.getProperty("gerrit.plugin-classes");
            if (overlay != null && Files.isDirectory(classes = Paths.get(overlay, new String[0]).resolve(name).resolve("main"), new LinkOption[0])) {
                log.info("plugin {}: including {}", (Object)name, (Object)classes);
                urls.add(classes.toUri().toURL());
            }
            urls.add(tmp.toUri().toURL());
            URLClassLoader pluginLoader = new URLClassLoader(urls.toArray(new URL[urls.size()]), PluginLoader.parentFor(type));
            JarScanner jarScanner = this.createJarScanner(tmp);
            PluginConfig pluginConfig = this.configFactory.getFromGerritConfig(name);
            ServerPlugin plugin = new ServerPlugin(name, description.canonicalUrl, description.user, srcJar, snapshot, jarScanner, description.dataDir, pluginLoader, pluginConfig.getString("metricsPrefix", null));
            plugin.setCleanupHandle(new CleanupHandle(tmp, jarFile));
            keep = true;
            ServerPlugin serverPlugin = plugin;
            return serverPlugin;
        }
        finally {
            if (!keep) {
                jarFile.close();
            }
        }
    }

    private JarScanner createJarScanner(Path srcJar) throws InvalidPluginException {
        try {
            return new JarScanner(srcJar);
        }
        catch (IOException e) {
            throw new InvalidPluginException("Cannot scan plugin file " + srcJar, e);
        }
    }
}

