/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.project;

import com.google.common.collect.Iterables;
import com.google.gerrit.extensions.restapi.RestResource;
import com.google.gerrit.extensions.restapi.RestView;
import com.google.gerrit.server.project.ProjectControl;
import com.google.gerrit.server.project.ProjectResource;
import com.google.gerrit.server.project.ProjectState;
import com.google.inject.TypeLiteral;

public class ChildProjectResource
implements RestResource {
    public static final TypeLiteral<RestView<ChildProjectResource>> CHILD_PROJECT_KIND = new TypeLiteral<RestView<ChildProjectResource>>(){};
    private final ProjectResource parent;
    private final ProjectControl child;

    public ChildProjectResource(ProjectResource parent, ProjectControl child) {
        this.parent = parent;
        this.child = child;
    }

    public ProjectResource getParent() {
        return this.parent;
    }

    public ProjectControl getChild() {
        return this.child;
    }

    public boolean isDirectChild() {
        ProjectState firstParent = Iterables.getFirst(this.child.getProjectState().parents(), null);
        return firstParent != null && this.parent.getNameKey().equals(firstParent.getProject().getNameKey());
    }
}

