/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.project;

import com.google.common.base.Joiner;
import com.google.common.base.MoreObjects;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.gerrit.extensions.registration.DynamicMap;
import com.google.gerrit.extensions.restapi.AcceptsCreate;
import com.google.gerrit.extensions.restapi.ChildCollection;
import com.google.gerrit.extensions.restapi.IdString;
import com.google.gerrit.extensions.restapi.ResourceNotFoundException;
import com.google.gerrit.extensions.restapi.RestApiException;
import com.google.gerrit.extensions.restapi.RestModifyView;
import com.google.gerrit.extensions.restapi.RestView;
import com.google.gerrit.extensions.restapi.Url;
import com.google.gerrit.reviewdb.client.Project;
import com.google.gerrit.server.CurrentUser;
import com.google.gerrit.server.UrlEncoded;
import com.google.gerrit.server.git.GitRepositoryManager;
import com.google.gerrit.server.project.DashboardResource;
import com.google.gerrit.server.project.ListDashboards;
import com.google.gerrit.server.project.ProjectControl;
import com.google.gerrit.server.project.ProjectResource;
import com.google.gerrit.server.project.ProjectState;
import com.google.gerrit.server.project.SetDefaultDashboard;
import com.google.gson.annotations.SerializedName;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jgit.errors.AmbiguousObjectException;
import org.eclipse.jgit.errors.ConfigInvalidException;
import org.eclipse.jgit.errors.IncorrectObjectTypeException;
import org.eclipse.jgit.errors.RepositoryNotFoundException;
import org.eclipse.jgit.lib.BlobBasedConfig;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Repository;

@Singleton
class DashboardsCollection
implements ChildCollection<ProjectResource, DashboardResource>,
AcceptsCreate<ProjectResource> {
    private final GitRepositoryManager gitManager;
    private final DynamicMap<RestView<DashboardResource>> views;
    private final Provider<ListDashboards> list;
    private final Provider<SetDefaultDashboard.CreateDefault> createDefault;

    @Inject
    DashboardsCollection(GitRepositoryManager gitManager, DynamicMap<RestView<DashboardResource>> views, Provider<ListDashboards> list, Provider<SetDefaultDashboard.CreateDefault> createDefault) {
        this.gitManager = gitManager;
        this.views = views;
        this.list = list;
        this.createDefault = createDefault;
    }

    @Override
    public RestView<ProjectResource> list() throws ResourceNotFoundException {
        return this.list.get();
    }

    @Override
    public RestModifyView<ProjectResource, ?> create(ProjectResource parent, IdString id) throws RestApiException {
        if (id.toString().equals("default")) {
            return this.createDefault.get();
        }
        throw new ResourceNotFoundException(id);
    }

    @Override
    public DashboardResource parse(ProjectResource parent, IdString id) throws ResourceNotFoundException, IOException, ConfigInvalidException {
        ProjectControl myCtl = parent.getControl();
        if (id.toString().equals("default")) {
            return DashboardResource.projectDefault(myCtl);
        }
        ArrayList<String> parts = Lists.newArrayList(Splitter.on(':').limit(2).split(id.get()));
        if (parts.size() != 2) {
            throw new ResourceNotFoundException(id);
        }
        CurrentUser user = myCtl.getUser();
        String ref = (String)parts.get(0);
        String path = (String)parts.get(1);
        for (ProjectState ps : myCtl.getProjectState().tree()) {
            try {
                return this.parse(ps.controlFor(user), ref, path, myCtl);
            }
            catch (AmbiguousObjectException | ConfigInvalidException | IncorrectObjectTypeException e) {
                throw new ResourceNotFoundException(id);
            }
            catch (ResourceNotFoundException e) {
            }
        }
        throw new ResourceNotFoundException(id);
    }

    private DashboardResource parse(ProjectControl ctl, String ref, String path, ProjectControl myCtl) throws ResourceNotFoundException, IOException, AmbiguousObjectException, IncorrectObjectTypeException, ConfigInvalidException {
        String id = ref + ":" + path;
        if (!ref.startsWith("refs/meta/dashboards/")) {
            ref = "refs/meta/dashboards/" + ref;
        }
        if (!Repository.isValidRefName(ref) || !ctl.controlForRef(ref).isVisible()) {
            throw new ResourceNotFoundException(id);
        }
        Repository git = this.gitManager.openRepository(ctl.getProject().getNameKey());
        try {
            ObjectId objId = git.resolve(ref + ":" + path);
            if (objId == null) {
                throw new ResourceNotFoundException(id);
            }
            BlobBasedConfig cfg = new BlobBasedConfig(null, git, objId);
            DashboardResource dashboardResource = new DashboardResource(myCtl, ref, path, cfg, false);
            if (git != null) {
                git.close();
            }
            return dashboardResource;
        }
        catch (Throwable throwable) {
            try {
                if (git != null) {
                    try {
                        git.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (RepositoryNotFoundException e) {
                throw new ResourceNotFoundException(id);
            }
        }
    }

    @Override
    public DynamicMap<RestView<DashboardResource>> views() {
        return this.views;
    }

    static DashboardInfo parse(Project definingProject, String refName, String path, Config config, String project, boolean setDefault) {
        DashboardInfo info = new DashboardInfo(refName, path);
        info.project = project;
        info.definingProject = definingProject.getName();
        String query = config.getString("dashboard", null, "title");
        info.title = DashboardsCollection.replace(project, query == null ? info.path : query);
        info.description = DashboardsCollection.replace(project, config.getString("dashboard", null, "description"));
        info.foreach = config.getString("dashboard", null, "foreach");
        if (setDefault) {
            String id = refName + ":" + path;
            info.isDefault = id.equals(DashboardsCollection.defaultOf(definingProject)) ? Boolean.valueOf(true) : null;
        }
        UrlEncoded u = new UrlEncoded("/dashboard/");
        u.put("title", MoreObjects.firstNonNull(info.title, info.path));
        if (info.foreach != null) {
            u.put("foreach", DashboardsCollection.replace(project, info.foreach));
        }
        for (String name : config.getSubsections("section")) {
            Section s = new Section();
            s.name = name;
            s.query = config.getString("section", name, "query");
            u.put(s.name, DashboardsCollection.replace(project, s.query));
            info.sections.add(s);
        }
        info.url = u.toString().replace("%3A", ":");
        return info;
    }

    private static String replace(String project, String query) {
        return query.replace("${project}", project);
    }

    private static String defaultOf(Project proj) {
        String defaultId = MoreObjects.firstNonNull(proj.getLocalDefaultDashboard(), Strings.nullToEmpty(proj.getDefaultDashboard()));
        if (defaultId.startsWith("refs/meta/dashboards/")) {
            return defaultId.substring("refs/meta/dashboards/".length());
        }
        return defaultId;
    }

    static class Section {
        String name;
        String query;

        Section() {
        }
    }

    static class DashboardInfo {
        String id;
        String project;
        String definingProject;
        String ref;
        String path;
        String description;
        String foreach;
        String url;
        @SerializedName(value="default")
        Boolean isDefault;
        String title;
        List<Section> sections = new ArrayList<Section>();

        DashboardInfo(String ref, String name) {
            this.ref = ref;
            this.path = name;
            this.id = Joiner.on(':').join(Url.encode(ref), Url.encode(this.path), new Object[0]);
        }
    }
}

