/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.project;

import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.Iterables;
import com.google.gerrit.common.data.AccessSection;
import com.google.gerrit.common.data.Permission;
import com.google.gerrit.common.data.PermissionRule;
import com.google.gerrit.common.data.RefConfigSection;
import com.google.gerrit.common.errors.NoSuchGroupException;
import com.google.gerrit.extensions.api.access.AccessSectionInfo;
import com.google.gerrit.extensions.api.access.PermissionInfo;
import com.google.gerrit.extensions.api.access.PermissionRuleInfo;
import com.google.gerrit.extensions.api.access.ProjectAccessInfo;
import com.google.gerrit.extensions.restapi.ResourceConflictException;
import com.google.gerrit.extensions.restapi.ResourceNotFoundException;
import com.google.gerrit.extensions.restapi.RestReadView;
import com.google.gerrit.reviewdb.client.AccountGroup;
import com.google.gerrit.reviewdb.client.Project;
import com.google.gerrit.server.CurrentUser;
import com.google.gerrit.server.account.GroupBackend;
import com.google.gerrit.server.account.GroupControl;
import com.google.gerrit.server.config.AllProjectsName;
import com.google.gerrit.server.git.MetaDataUpdate;
import com.google.gerrit.server.git.ProjectConfig;
import com.google.gerrit.server.project.NoSuchProjectException;
import com.google.gerrit.server.project.ProjectCache;
import com.google.gerrit.server.project.ProjectControl;
import com.google.gerrit.server.project.ProjectJson;
import com.google.gerrit.server.project.ProjectResource;
import com.google.gerrit.server.project.ProjectState;
import com.google.gerrit.server.project.RefControl;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import org.eclipse.jgit.errors.ConfigInvalidException;
import org.eclipse.jgit.errors.RepositoryNotFoundException;

@Singleton
public class GetAccess
implements RestReadView<ProjectResource> {
    public static final ImmutableBiMap<PermissionRule.Action, PermissionRuleInfo.Action> ACTION_TYPE = ImmutableBiMap.of(PermissionRule.Action.ALLOW, PermissionRuleInfo.Action.ALLOW, PermissionRule.Action.BATCH, PermissionRuleInfo.Action.BATCH, PermissionRule.Action.BLOCK, PermissionRuleInfo.Action.BLOCK, PermissionRule.Action.DENY, PermissionRuleInfo.Action.DENY, PermissionRule.Action.INTERACTIVE, PermissionRuleInfo.Action.INTERACTIVE);
    private final Provider<CurrentUser> self;
    private final GroupControl.Factory groupControlFactory;
    private final AllProjectsName allProjectsName;
    private final ProjectJson projectJson;
    private final ProjectCache projectCache;
    private final MetaDataUpdate.Server metaDataUpdateFactory;
    private final ProjectControl.GenericFactory projectControlFactory;
    private final GroupBackend groupBackend;

    @Inject
    public GetAccess(Provider<CurrentUser> self, GroupControl.Factory groupControlFactory, AllProjectsName allProjectsName, ProjectCache projectCache, MetaDataUpdate.Server metaDataUpdateFactory, ProjectJson projectJson, ProjectControl.GenericFactory projectControlFactory, GroupBackend groupBackend) {
        this.self = self;
        this.groupControlFactory = groupControlFactory;
        this.allProjectsName = allProjectsName;
        this.projectJson = projectJson;
        this.projectCache = projectCache;
        this.projectControlFactory = projectControlFactory;
        this.metaDataUpdateFactory = metaDataUpdateFactory;
        this.groupBackend = groupBackend;
    }

    public ProjectAccessInfo apply(Project.NameKey nameKey) throws ResourceNotFoundException, ResourceConflictException, IOException {
        try {
            return this.apply(new ProjectResource(this.projectControlFactory.controlFor(nameKey, this.self.get())));
        }
        catch (NoSuchProjectException e) {
            throw new ResourceNotFoundException(nameKey.get());
        }
    }

    public ProjectAccessInfo apply(ProjectResource rsrc) throws ResourceNotFoundException, ResourceConflictException, IOException {
        ProjectState parent;
        ProjectConfig config;
        Project.NameKey projectName = rsrc.getNameKey();
        ProjectAccessInfo info = new ProjectAccessInfo();
        ProjectControl pc = this.open(projectName);
        RefControl metaConfigControl = pc.controlForRef("refs/meta/config");
        try (MetaDataUpdate md = this.metaDataUpdateFactory.create(projectName);){
            config = ProjectConfig.read(md);
            if (config.updateGroupNames(this.groupBackend)) {
                md.setMessage("Update group names\n");
                config.commit(md);
                this.projectCache.evict(config.getProject());
                pc = this.open(projectName);
            } else if (config.getRevision() != null && !config.getRevision().equals(pc.getProjectState().getConfig().getRevision())) {
                this.projectCache.evict(config.getProject());
                pc = this.open(projectName);
            }
        }
        catch (ConfigInvalidException e) {
            throw new ResourceConflictException(e.getMessage());
        }
        catch (RepositoryNotFoundException e) {
            throw new ResourceNotFoundException(rsrc.getName());
        }
        info.local = new HashMap<String, AccessSectionInfo>();
        info.ownerOf = new HashSet<String>();
        HashMap<AccountGroup.UUID, Boolean> visibleGroups = new HashMap<AccountGroup.UUID, Boolean>();
        for (AccessSection section : config.getAccessSections()) {
            String name = section.getName();
            if ("GLOBAL_CAPABILITIES".equals(name)) {
                if (pc.isOwner()) {
                    info.local.put(name, this.createAccessSection(section));
                    info.ownerOf.add(name);
                    continue;
                }
                if (!metaConfigControl.isVisible()) continue;
                info.local.put(section.getName(), this.createAccessSection(section));
                continue;
            }
            if (!RefConfigSection.isValid(name)) continue;
            RefControl rc = pc.controlForRef(name);
            if (rc.isOwner()) {
                info.local.put(name, this.createAccessSection(section));
                info.ownerOf.add(name);
                continue;
            }
            if (metaConfigControl.isVisible()) {
                info.local.put(name, this.createAccessSection(section));
                continue;
            }
            if (!rc.isVisible()) continue;
            AccessSection dst = null;
            for (Permission srcPerm : section.getPermissions()) {
                Permission dstPerm = null;
                for (PermissionRule srcRule : srcPerm.getRules()) {
                    AccountGroup.UUID group = srcRule.getGroup().getUUID();
                    if (group == null) continue;
                    Boolean canSeeGroup = (Boolean)visibleGroups.get(group);
                    if (canSeeGroup == null) {
                        try {
                            canSeeGroup = this.groupControlFactory.controlFor(group).isVisible();
                        }
                        catch (NoSuchGroupException e) {
                            canSeeGroup = Boolean.FALSE;
                        }
                        visibleGroups.put(group, canSeeGroup);
                    }
                    if (!canSeeGroup.booleanValue()) continue;
                    if (dstPerm == null) {
                        if (dst == null) {
                            dst = new AccessSection(name);
                            info.local.put(name, this.createAccessSection(dst));
                        }
                        dstPerm = dst.getPermission(srcPerm.getName(), true);
                    }
                    dstPerm.add(srcRule);
                }
            }
        }
        if (info.ownerOf.isEmpty() && pc.isOwnerAnyRef()) {
            info.ownerOf.add("refs/*");
        }
        if (config.getRevision() != null) {
            info.revision = config.getRevision().name();
        }
        if ((parent = (ProjectState)Iterables.getFirst(pc.getProjectState().parents(), null)) != null) {
            info.inheritsFrom = this.projectJson.format(parent.getProject());
        }
        if (pc.getProject().getNameKey().equals(this.allProjectsName) && pc.isOwner()) {
            info.ownerOf.add("GLOBAL_CAPABILITIES");
        }
        info.isOwner = GetAccess.toBoolean(pc.isOwner());
        info.canUpload = GetAccess.toBoolean(pc.isOwner() || metaConfigControl.isVisible() && metaConfigControl.canUpload());
        info.canAdd = GetAccess.toBoolean(pc.canAddRefs());
        info.canAddTags = GetAccess.toBoolean(pc.canAddTagRefs());
        info.configVisible = pc.isOwner() || metaConfigControl.isVisible();
        return info;
    }

    private AccessSectionInfo createAccessSection(AccessSection section) {
        AccessSectionInfo accessSectionInfo = new AccessSectionInfo();
        accessSectionInfo.permissions = new HashMap<String, PermissionInfo>();
        for (Permission p : section.getPermissions()) {
            PermissionInfo pInfo = new PermissionInfo(p.getLabel(), p.getExclusiveGroup() != false ? Boolean.valueOf(true) : null);
            pInfo.rules = new HashMap<String, PermissionRuleInfo>();
            for (PermissionRule r : p.getRules()) {
                AccountGroup.UUID group;
                PermissionRuleInfo info = new PermissionRuleInfo((PermissionRuleInfo.Action)((Object)ACTION_TYPE.get((Object)r.getAction())), r.getForce());
                if (r.hasRange()) {
                    info.max = r.getMax();
                    info.min = r.getMin();
                }
                if ((group = r.getGroup().getUUID()) == null) continue;
                pInfo.rules.put(group.get(), info);
            }
            accessSectionInfo.permissions.put(p.getName(), pInfo);
        }
        return accessSectionInfo;
    }

    private ProjectControl open(Project.NameKey projectName) throws ResourceNotFoundException, IOException {
        try {
            return this.projectControlFactory.validateFor(projectName, 3, this.self.get());
        }
        catch (NoSuchProjectException e) {
            throw new ResourceNotFoundException(projectName.get());
        }
    }

    private static Boolean toBoolean(boolean value) {
        return value ? Boolean.valueOf(true) : null;
    }
}

