/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.project;

import com.google.gerrit.extensions.restapi.AuthException;
import com.google.gerrit.extensions.restapi.ResourceNotFoundException;
import com.google.gerrit.extensions.restapi.RestReadView;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.git.GitRepositoryManager;
import com.google.gerrit.server.project.ProjectResource;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import java.io.IOException;
import org.eclipse.jgit.errors.IncorrectObjectTypeException;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.errors.RepositoryNotFoundException;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;

@Singleton
public class GetHead
implements RestReadView<ProjectResource> {
    private GitRepositoryManager repoManager;
    private Provider<ReviewDb> db;

    @Inject
    GetHead(GitRepositoryManager repoManager, Provider<ReviewDb> db) {
        this.repoManager = repoManager;
        this.db = db;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String apply(ProjectResource rsrc) throws AuthException, ResourceNotFoundException, IOException {
        try (Repository repo = this.repoManager.openRepository(rsrc.getNameKey());){
            Ref head = repo.getRefDatabase().exactRef("HEAD");
            if (head == null) {
                throw new ResourceNotFoundException("HEAD");
            }
            if (head.isSymbolic()) {
                String n = head.getTarget().getName();
                if (!rsrc.getControl().controlForRef(n).isVisible()) throw new AuthException("not allowed to see HEAD");
                String string = n;
                return string;
            }
            if (head.getObjectId() == null) throw new ResourceNotFoundException("HEAD");
            try {
                block21: {
                    RevWalk rw = new RevWalk(repo);
                    RevCommit commit = rw.parseCommit(head.getObjectId());
                    if (!rsrc.getControl().canReadCommit(this.db.get(), repo, commit)) break block21;
                    String string = head.getObjectId().name();
                    rw.close();
                    return string;
                    {
                        catch (Throwable throwable) {
                            try {
                                rw.close();
                                throw throwable;
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                    }
                }
                throw new AuthException("not allowed to see HEAD");
            }
            catch (IncorrectObjectTypeException | MissingObjectException e) {
                if (!rsrc.getControl().isOwner()) throw new AuthException("not allowed to see HEAD");
                String string = head.getObjectId().name();
                return string;
            }
        }
        catch (RepositoryNotFoundException e) {
            throw new ResourceNotFoundException(rsrc.getName());
        }
    }
}

