/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.project;

import com.google.gerrit.common.data.Permission;
import com.google.gerrit.common.data.PermissionRange;
import com.google.gerrit.common.data.PermissionRule;
import com.google.gerrit.extensions.client.ProjectState;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.CurrentUser;
import com.google.gerrit.server.group.SystemGroupBackend;
import com.google.gerrit.server.project.PermissionCollection;
import com.google.gerrit.server.project.ProjectControl;
import com.google.gerrit.server.project.ProjectRef;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevObject;
import org.eclipse.jgit.revwalk.RevTag;
import org.eclipse.jgit.revwalk.RevWalk;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RefControl {
    private static final Logger log = LoggerFactory.getLogger(RefControl.class);
    private final ProjectControl projectControl;
    private final String refName;
    private final PermissionCollection relevant;
    private final Map<String, List<PermissionRule>> effective;
    private Boolean owner;
    private Boolean canForgeAuthor;
    private Boolean canForgeCommitter;
    private Boolean isVisible;

    RefControl(ProjectControl projectControl, String ref, PermissionCollection relevant) {
        this.projectControl = projectControl;
        this.refName = ref;
        this.relevant = relevant;
        this.effective = new HashMap<String, List<PermissionRule>>();
    }

    public String getRefName() {
        return this.refName;
    }

    public ProjectControl getProjectControl() {
        return this.projectControl;
    }

    public CurrentUser getUser() {
        return this.projectControl.getUser();
    }

    public RefControl forUser(CurrentUser who) {
        ProjectControl newCtl = this.projectControl.forUser(who);
        if (this.relevant.isUserSpecific()) {
            return newCtl.controlForRef(this.getRefName());
        }
        return new RefControl(newCtl, this.getRefName(), this.relevant);
    }

    public boolean isOwner() {
        if (this.owner == null) {
            this.owner = this.canPerform("owner") ? Boolean.valueOf(true) : Boolean.valueOf(this.projectControl.isOwner());
        }
        return this.owner;
    }

    public boolean isVisible() {
        if (this.isVisible == null) {
            this.isVisible = (this.getUser().isInternalUser() || this.canPerform("read")) && this.canRead();
        }
        return this.isVisible;
    }

    public boolean isVisibleByRegisteredUsers() {
        List<PermissionRule> access = this.relevant.getPermission("read");
        List<PermissionRule> overridden = this.relevant.getOverridden("read");
        HashSet<ProjectRef> allows = new HashSet<ProjectRef>();
        HashSet<ProjectRef> blocks = new HashSet<ProjectRef>();
        for (PermissionRule rule : access) {
            if (rule.isBlock()) {
                blocks.add(this.relevant.getRuleProps(rule));
                continue;
            }
            if (!SystemGroupBackend.isAnonymousOrRegistered(rule.getGroup())) continue;
            allows.add(this.relevant.getRuleProps(rule));
        }
        for (PermissionRule rule : overridden) {
            if (!SystemGroupBackend.isAnonymousOrRegistered(rule.getGroup())) continue;
            blocks.remove(this.relevant.getRuleProps(rule));
        }
        blocks.removeAll(allows);
        return blocks.isEmpty() && !allows.isEmpty();
    }

    public boolean canUpload() {
        return this.projectControl.controlForRef("refs/for/" + this.getRefName()).canPerform("push") && this.canWrite();
    }

    public boolean canAddPatchSet() {
        return this.projectControl.controlForRef("refs/for/" + this.getRefName()).canPerform("addPatchSet") && this.canWrite();
    }

    public boolean canUploadMerges() {
        return this.projectControl.controlForRef("refs/for/" + this.getRefName()).canPerform("pushMerge") && this.canWrite();
    }

    public boolean canRebase() {
        return this.canPerform("rebase") && this.canWrite();
    }

    public boolean canSubmit(boolean isChangeOwner) {
        if ("refs/meta/config".equals(this.refName)) {
            return this.projectControl.isOwner();
        }
        return this.canPerform("submit", isChangeOwner) && this.canWrite();
    }

    public boolean canSubmitAs() {
        return this.canPerform("submitAs");
    }

    public boolean canUpdate() {
        if (!(!"refs/meta/config".equals(this.refName) || this.projectControl.isOwner() || this.projectControl.getProjectState().isAllProjects() && this.getUser().getCapabilities().canAdministrateServer())) {
            return false;
        }
        return this.canPerform("push") && this.canWrite();
    }

    public boolean canForceUpdate() {
        if (!this.canWrite()) {
            return false;
        }
        if (this.canPushWithForce()) {
            return true;
        }
        switch (this.getUser().getAccessPath()) {
            case GIT: {
                return false;
            }
        }
        return this.getUser().getCapabilities().canAdministrateServer() || this.isOwner() && !this.isForceBlocked("push");
    }

    public boolean canWrite() {
        return this.getProjectControl().getProject().getState().equals((Object)ProjectState.ACTIVE);
    }

    public boolean canRead() {
        return this.getProjectControl().getProject().getState().equals((Object)ProjectState.READ_ONLY) || this.canWrite();
    }

    private boolean canPushWithForce() {
        if (!this.canWrite() || "refs/meta/config".equals(this.refName) && !this.projectControl.isOwner()) {
            return false;
        }
        return this.canForcePerform("push");
    }

    public boolean canCreate(ReviewDb db, Repository repo, RevObject object) {
        if (!this.canWrite()) {
            return false;
        }
        if (object instanceof RevCommit) {
            if (!this.canPerform("create")) {
                return false;
            }
            return this.canCreateCommit(db, repo, (RevCommit)object);
        }
        if (object instanceof RevTag) {
            RevObject tagObject;
            RevTag tag = (RevTag)object;
            try (RevWalk rw = new RevWalk(repo);){
                rw.parseBody(tag);
            }
            catch (IOException e) {
                return false;
            }
            PersonIdent tagger = tag.getTaggerIdent();
            if (tagger != null) {
                boolean valid;
                if (this.getUser().isIdentifiedUser()) {
                    String addr = tagger.getEmailAddress();
                    valid = this.getUser().asIdentifiedUser().hasEmailAddress(addr);
                } else {
                    valid = false;
                }
                if (!valid && !this.canForgeCommitter()) {
                    return false;
                }
            }
            if ((tagObject = tag.getObject()) instanceof RevCommit ? !this.canCreateCommit(db, repo, (RevCommit)tagObject) : !this.canCreate(db, repo, tagObject)) {
                return false;
            }
            if (tag.getFullMessage().contains("-----BEGIN PGP SIGNATURE-----\n")) {
                return this.canPerform("createSignedTag");
            }
            return this.canPerform("createTag");
        }
        return false;
    }

    private boolean canCreateCommit(ReviewDb db, Repository repo, RevCommit commit) {
        if (this.canUpdate()) {
            return true;
        }
        return this.isMergedIntoBranchOrTag(db, repo, commit);
    }

    private boolean isMergedIntoBranchOrTag(ReviewDb db, Repository repo, RevCommit commit) {
        RevWalk rw = new RevWalk(repo);
        try {
            ArrayList<Ref> refs = new ArrayList<Ref>(repo.getRefDatabase().getRefs("refs/heads/").values());
            refs.addAll(repo.getRefDatabase().getRefs("refs/tags/").values());
            boolean bl = this.projectControl.isMergedIntoVisibleRef(repo, db, rw, commit, refs);
            rw.close();
            return bl;
        }
        catch (Throwable refs) {
            try {
                try {
                    rw.close();
                }
                catch (Throwable throwable) {
                    refs.addSuppressed(throwable);
                }
                throw refs;
            }
            catch (IOException e) {
                String msg = String.format("Cannot verify permissions to commit object %s in repository %s", commit.name(), this.projectControl.getProject().getNameKey());
                log.error(msg, e);
                return false;
            }
        }
    }

    public boolean canDelete() {
        if (!this.canWrite() || "refs/meta/config".equals(this.refName)) {
            return false;
        }
        switch (this.getUser().getAccessPath()) {
            case GIT: {
                return this.canPushWithForce() || this.canPerform("delete");
            }
        }
        return this.getUser().getCapabilities().canAdministrateServer() || this.isOwner() && !this.isForceBlocked("push") || this.canPushWithForce() || this.canPerform("delete");
    }

    public boolean canForgeAuthor() {
        if (this.canForgeAuthor == null) {
            this.canForgeAuthor = this.canPerform("forgeAuthor");
        }
        return this.canForgeAuthor;
    }

    public boolean canForgeCommitter() {
        if (this.canForgeCommitter == null) {
            this.canForgeCommitter = this.canPerform("forgeCommitter");
        }
        return this.canForgeCommitter;
    }

    public boolean canForgeGerritServerIdentity() {
        return this.canPerform("forgeServerAsCommitter");
    }

    public boolean canAbandon() {
        return this.canPerform("abandon");
    }

    boolean canRemoveReviewer() {
        return this.canPerform("removeReviewer");
    }

    public boolean canViewDrafts() {
        return this.canPerform("viewDrafts");
    }

    public boolean canPublishDrafts() {
        return this.canPerform("publishDrafts");
    }

    public boolean canDeleteDrafts() {
        return this.canPerform("deleteDrafts");
    }

    public boolean canDeleteChanges(boolean isChangeOwner) {
        return this.canPerform("deleteChanges") || isChangeOwner && this.canPerform("deleteOwnChanges", isChangeOwner);
    }

    public boolean canEditTopicName() {
        return this.canPerform("editTopicName");
    }

    public boolean canEditHashtags() {
        return this.canPerform("editHashtags");
    }

    public boolean canEditAssignee() {
        return this.canPerform("editAssignee");
    }

    public boolean canForceEditTopicName() {
        return this.canForcePerform("editTopicName");
    }

    public List<PermissionRange> getLabelRanges(boolean isChangeOwner) {
        ArrayList<PermissionRange> r = new ArrayList<PermissionRange>();
        for (Map.Entry<String, List<PermissionRule>> e : this.relevant.getDeclaredPermissions()) {
            if (!Permission.isLabel(e.getKey())) continue;
            int min = 0;
            int max = 0;
            for (PermissionRule rule : e.getValue()) {
                if (!this.projectControl.match(rule, isChangeOwner)) continue;
                min = Math.min(min, rule.getMin());
                max = Math.max(max, rule.getMax());
            }
            if (min == 0 && max == 0) continue;
            r.add(new PermissionRange(e.getKey(), min, max));
        }
        return r;
    }

    public PermissionRange getRange(String permission) {
        return this.getRange(permission, false);
    }

    public PermissionRange getRange(String permission, boolean isChangeOwner) {
        if (Permission.hasRange(permission)) {
            return this.toRange(permission, this.access(permission, isChangeOwner));
        }
        return null;
    }

    private PermissionRange toRange(String permissionName, List<PermissionRule> ruleList) {
        HashMap<ProjectRef, AllowedRange> ranges = new HashMap<ProjectRef, AllowedRange>();
        for (PermissionRule rule : ruleList) {
            ProjectRef p = this.relevant.getRuleProps(rule);
            AllowedRange r = (AllowedRange)ranges.get(p);
            if (r == null) {
                r = new AllowedRange();
                ranges.put(p, r);
            }
            r.update(rule);
        }
        int allowMin = 0;
        int allowMax = 0;
        int blockMin = Integer.MIN_VALUE;
        int blockMax = Integer.MAX_VALUE;
        for (AllowedRange r : ranges.values()) {
            allowMin = Math.min(allowMin, r.getAllowMin());
            allowMax = Math.max(allowMax, r.getAllowMax());
            blockMin = Math.max(blockMin, r.getBlockMin());
            blockMax = Math.min(blockMax, r.getBlockMax());
        }
        int min = Math.max(allowMin, blockMin + 1);
        int max = Math.min(allowMax, blockMax - 1);
        return new PermissionRange(permissionName, min, max);
    }

    boolean canPerform(String permissionName) {
        return this.canPerform(permissionName, false);
    }

    boolean canPerform(String permissionName, boolean isChangeOwner) {
        return this.doCanPerform(permissionName, isChangeOwner, false);
    }

    public boolean isBlocked(String permissionName) {
        return !this.doCanPerform(permissionName, false, true);
    }

    private boolean doCanPerform(String permissionName, boolean isChangeOwner, boolean blockOnly) {
        List<PermissionRule> access = this.access(permissionName, isChangeOwner);
        List<PermissionRule> overridden = this.relevant.getOverridden(permissionName);
        HashSet<ProjectRef> allows = new HashSet<ProjectRef>();
        HashSet<ProjectRef> blocks = new HashSet<ProjectRef>();
        for (PermissionRule rule : access) {
            if (rule.isBlock() && !rule.getForce().booleanValue()) {
                blocks.add(this.relevant.getRuleProps(rule));
                continue;
            }
            allows.add(this.relevant.getRuleProps(rule));
        }
        for (PermissionRule rule : overridden) {
            blocks.remove(this.relevant.getRuleProps(rule));
        }
        blocks.removeAll(allows);
        return blocks.isEmpty() && (!allows.isEmpty() || blockOnly);
    }

    private boolean canForcePerform(String permissionName) {
        List<PermissionRule> access = this.access(permissionName);
        List<PermissionRule> overridden = this.relevant.getOverridden(permissionName);
        HashSet<ProjectRef> allows = new HashSet<ProjectRef>();
        HashSet<ProjectRef> blocks = new HashSet<ProjectRef>();
        for (PermissionRule rule : access) {
            if (rule.isBlock()) {
                blocks.add(this.relevant.getRuleProps(rule));
                continue;
            }
            if (!rule.getForce().booleanValue()) continue;
            allows.add(this.relevant.getRuleProps(rule));
        }
        for (PermissionRule rule : overridden) {
            if (!rule.getForce().booleanValue()) continue;
            blocks.remove(this.relevant.getRuleProps(rule));
        }
        blocks.removeAll(allows);
        return blocks.isEmpty() && !allows.isEmpty();
    }

    private boolean isForceBlocked(String permissionName) {
        List<PermissionRule> access = this.access(permissionName);
        List<PermissionRule> overridden = this.relevant.getOverridden(permissionName);
        HashSet<ProjectRef> allows = new HashSet<ProjectRef>();
        HashSet<ProjectRef> blocks = new HashSet<ProjectRef>();
        for (PermissionRule rule : access) {
            if (rule.isBlock()) {
                blocks.add(this.relevant.getRuleProps(rule));
                continue;
            }
            if (!rule.getForce().booleanValue()) continue;
            allows.add(this.relevant.getRuleProps(rule));
        }
        for (PermissionRule rule : overridden) {
            if (!rule.getForce().booleanValue()) continue;
            blocks.remove(this.relevant.getRuleProps(rule));
        }
        blocks.removeAll(allows);
        return !blocks.isEmpty();
    }

    private List<PermissionRule> access(String permissionName) {
        return this.access(permissionName, false);
    }

    private List<PermissionRule> access(String permissionName, boolean isChangeOwner) {
        List<PermissionRule> rules = this.effective.get(permissionName);
        if (rules != null) {
            return rules;
        }
        rules = this.relevant.getPermission(permissionName);
        ArrayList<PermissionRule> mine = new ArrayList(rules.size());
        for (PermissionRule rule : rules) {
            if (!this.projectControl.match(rule, isChangeOwner)) continue;
            mine.add(rule);
        }
        if (mine.isEmpty()) {
            mine = Collections.emptyList();
        }
        this.effective.put(permissionName, mine);
        return mine;
    }

    private static class AllowedRange {
        private int allowMin;
        private int allowMax;
        private int blockMin = Integer.MIN_VALUE;
        private int blockMax = Integer.MAX_VALUE;

        private AllowedRange() {
        }

        void update(PermissionRule rule) {
            if (rule.isBlock()) {
                this.blockMin = Math.max(this.blockMin, rule.getMin());
                this.blockMax = Math.min(this.blockMax, rule.getMax());
            } else {
                this.allowMin = Math.min(this.allowMin, rule.getMin());
                this.allowMax = Math.max(this.allowMax, rule.getMax());
            }
        }

        int getAllowMin() {
            return this.allowMin;
        }

        int getAllowMax() {
            return this.allowMax;
        }

        int getBlockMin() {
            return Math.min(this.blockMin, this.allowMin - 1);
        }

        int getBlockMax() {
            return Math.max(this.blockMax, this.allowMax + 1);
        }
    }
}

