/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.project;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Iterables;
import com.google.gerrit.extensions.restapi.AuthException;
import com.google.gerrit.extensions.restapi.DefaultInput;
import com.google.gerrit.extensions.restapi.ResourceConflictException;
import com.google.gerrit.extensions.restapi.ResourceNotFoundException;
import com.google.gerrit.extensions.restapi.RestModifyView;
import com.google.gerrit.extensions.restapi.UnprocessableEntityException;
import com.google.gerrit.reviewdb.client.Project;
import com.google.gerrit.server.IdentifiedUser;
import com.google.gerrit.server.config.AllProjectsName;
import com.google.gerrit.server.git.MetaDataUpdate;
import com.google.gerrit.server.git.ProjectConfig;
import com.google.gerrit.server.project.ProjectCache;
import com.google.gerrit.server.project.ProjectControl;
import com.google.gerrit.server.project.ProjectResource;
import com.google.gerrit.server.project.ProjectState;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.io.IOException;
import org.eclipse.jgit.errors.ConfigInvalidException;
import org.eclipse.jgit.errors.RepositoryNotFoundException;

@Singleton
public class SetParent
implements RestModifyView<ProjectResource, Input> {
    private final ProjectCache cache;
    private final MetaDataUpdate.Server updateFactory;
    private final AllProjectsName allProjects;

    @Inject
    SetParent(ProjectCache cache, MetaDataUpdate.Server updateFactory, AllProjectsName allProjects) {
        this.cache = cache;
        this.updateFactory = updateFactory;
        this.allProjects = allProjects;
    }

    public String apply(ProjectResource rsrc, Input input) throws AuthException, ResourceConflictException, ResourceNotFoundException, UnprocessableEntityException, IOException {
        return this.apply(rsrc, input, true);
    }

    public String apply(ProjectResource rsrc, Input input, boolean checkIfAdmin) throws AuthException, ResourceConflictException, ResourceNotFoundException, UnprocessableEntityException, IOException {
        ProjectControl ctl = rsrc.getControl();
        String parentName = MoreObjects.firstNonNull(Strings.emptyToNull(input.parent), this.allProjects.get());
        this.validateParentUpdate(ctl, parentName, checkIfAdmin);
        MetaDataUpdate md = this.updateFactory.create(rsrc.getNameKey());
        try {
            ProjectConfig config = ProjectConfig.read(md);
            Project project = config.getProject();
            project.setParentName(parentName);
            String msg = Strings.emptyToNull(input.commitMessage);
            if (msg == null) {
                msg = String.format("Changed parent to %s.\n", parentName);
            } else if (!msg.endsWith("\n")) {
                msg = msg + "\n";
            }
            md.setAuthor(ctl.getUser().asIdentifiedUser());
            md.setMessage(msg);
            config.commit(md);
            this.cache.evict(ctl.getProject());
            Project.NameKey parent = project.getParent(this.allProjects);
            Preconditions.checkNotNull(parent);
            String string = parent.get();
            if (md != null) {
                md.close();
            }
            return string;
        }
        catch (Throwable throwable) {
            try {
                if (md != null) {
                    try {
                        md.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (RepositoryNotFoundException notFound) {
                throw new ResourceNotFoundException(rsrc.getName());
            }
            catch (ConfigInvalidException e) {
                throw new ResourceConflictException(String.format("invalid project.config: %s", e.getMessage()));
            }
        }
    }

    public void validateParentUpdate(ProjectControl ctl, String newParent, boolean checkIfAdmin) throws AuthException, ResourceConflictException, UnprocessableEntityException {
        IdentifiedUser user = ctl.getUser().asIdentifiedUser();
        if (checkIfAdmin && !user.getCapabilities().canAdministrateServer()) {
            throw new AuthException("not administrator");
        }
        if (ctl.getProject().getNameKey().equals(this.allProjects)) {
            throw new ResourceConflictException("cannot set parent of " + this.allProjects.get());
        }
        if ((newParent = Strings.emptyToNull(newParent)) != null) {
            ProjectState parent = this.cache.get(new Project.NameKey(newParent));
            if (parent == null) {
                throw new UnprocessableEntityException("parent project " + newParent + " not found");
            }
            if (Iterables.tryFind(parent.tree(), p -> p.getProject().getNameKey().equals(ctl.getProject().getNameKey())).isPresent()) {
                throw new ResourceConflictException("cycle exists between " + ctl.getProject().getName() + " and " + parent.getProject().getName());
            }
        }
    }

    public static class Input {
        @DefaultInput
        public String parent;
        public String commitMessage;
    }
}

