/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.query.change;

import com.google.common.collect.Lists;
import com.google.gerrit.common.data.SubmitTypeRecord;
import com.google.gerrit.reviewdb.client.Change;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.git.CodeReviewCommit;
import com.google.gerrit.server.git.IntegrationException;
import com.google.gerrit.server.git.strategy.SubmitDryRun;
import com.google.gerrit.server.project.NoSuchProjectException;
import com.google.gerrit.server.project.ProjectCache;
import com.google.gerrit.server.project.ProjectState;
import com.google.gerrit.server.query.OrPredicate;
import com.google.gerrit.server.query.Predicate;
import com.google.gerrit.server.query.QueryParseException;
import com.google.gerrit.server.query.change.ChangeData;
import com.google.gerrit.server.query.change.ChangeOperatorPredicate;
import com.google.gerrit.server.query.change.ChangeQueryBuilder;
import com.google.gerrit.server.query.change.ConflictKey;
import com.google.gerrit.server.query.change.EqualsPathPredicate;
import com.google.gerrit.server.query.change.IsMergePredicate;
import com.google.gerrit.server.query.change.LegacyChangeIdPredicate;
import com.google.gerrit.server.query.change.ProjectPredicate;
import com.google.gerrit.server.query.change.RefPredicate;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Provider;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.revwalk.filter.RevFilter;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.eclipse.jgit.treewalk.filter.TreeFilter;

class ConflictsPredicate
extends OrPredicate<ChangeData> {
    private static final String TOO_MANY_FILES = "too many files to find conflicts";
    private final String value;

    ConflictsPredicate(ChangeQueryBuilder.Arguments args, String value, List<Change> changes) throws QueryParseException, OrmException {
        super(ConflictsPredicate.predicates(args, value, changes));
        this.value = value;
    }

    private static List<Predicate<ChangeData>> predicates(final ChangeQueryBuilder.Arguments args, String value, List<Change> changes) throws QueryParseException, OrmException {
        int indexTerms = 0;
        ArrayList<Predicate<ChangeData>> changePredicates = Lists.newArrayListWithCapacity(changes.size());
        Provider<ReviewDb> db = args.db;
        for (final Change c : changes) {
            ChangeDataCache changeDataCache;
            List<String> files = ConflictsPredicate.listFiles(c, args, changeDataCache = new ChangeDataCache(c, db, args.changeDataFactory, args.projectCache));
            if ((indexTerms += 3 + files.size()) > args.indexConfig.maxTerms()) {
                throw new QueryParseException(TOO_MANY_FILES);
            }
            ArrayList<EqualsPathPredicate> filePredicates = Lists.newArrayListWithCapacity(files.size());
            for (String file : files) {
                filePredicates.add(new EqualsPathPredicate("path", file));
            }
            ArrayList predicatesForOneChange = Lists.newArrayListWithCapacity(5);
            predicatesForOneChange.add(ConflictsPredicate.not(new LegacyChangeIdPredicate(c.getId())));
            predicatesForOneChange.add(new ProjectPredicate(c.getProject().get()));
            predicatesForOneChange.add(new RefPredicate(c.getDest().get()));
            predicatesForOneChange.add(ConflictsPredicate.or(ConflictsPredicate.or(filePredicates), new IsMergePredicate(args, value)));
            predicatesForOneChange.add(new ChangeOperatorPredicate("conflicts", value){

                /*
                 * Enabled aggressive exception aggregation
                 */
                @Override
                public boolean match(ChangeData object) throws OrmException {
                    Change otherChange = object.change();
                    if (otherChange == null) {
                        return false;
                    }
                    if (!otherChange.getDest().equals(c.getDest())) {
                        return false;
                    }
                    SubmitTypeRecord str = object.submitTypeRecord();
                    if (!str.isOk()) {
                        return false;
                    }
                    ObjectId other = ObjectId.fromString(object.currentPatchSet().getRevision().get());
                    ConflictKey conflictsKey = new ConflictKey(changeDataCache.getTestAgainst(), other, str.type, changeDataCache.getProjectState().isUseContentMerge());
                    Boolean conflicts = args.conflictsCache.getIfPresent(conflictsKey);
                    if (conflicts != null) {
                        return conflicts;
                    }
                    try (Repository repo = args.repoManager.openRepository(otherChange.getProject());){
                        boolean bl;
                        block18: {
                            CodeReviewCommit.CodeReviewRevWalk rw = CodeReviewCommit.newRevWalk(repo);
                            try {
                                conflicts = !args.submitDryRun.run(str.type, repo, rw, otherChange.getDest(), changeDataCache.getTestAgainst(), other, this.getAlreadyAccepted(repo, rw));
                                args.conflictsCache.put(conflictsKey, conflicts);
                                bl = conflicts;
                                if (rw == null) break block18;
                            }
                            catch (Throwable throwable) {
                                if (rw != null) {
                                    try {
                                        rw.close();
                                    }
                                    catch (Throwable throwable2) {
                                        throwable.addSuppressed(throwable2);
                                    }
                                }
                                throw throwable;
                            }
                            rw.close();
                        }
                        return bl;
                    }
                    catch (IntegrationException | NoSuchProjectException | IOException e) {
                        throw new OrmException(e);
                    }
                }

                @Override
                public int getCost() {
                    return 5;
                }

                private Set<RevCommit> getAlreadyAccepted(Repository repo, RevWalk rw) throws IntegrationException {
                    try {
                        HashSet<RevCommit> accepted = new HashSet<RevCommit>();
                        SubmitDryRun.addCommits(changeDataCache.getAlreadyAccepted(repo), rw, accepted);
                        ObjectId tip = changeDataCache.getTestAgainst();
                        if (tip != null) {
                            accepted.add(rw.parseCommit(tip));
                        }
                        return accepted;
                    }
                    catch (OrmException | IOException e) {
                        throw new IntegrationException("Failed to determine already accepted commits.", e);
                    }
                }
            });
            changePredicates.add(ConflictsPredicate.and(predicatesForOneChange));
        }
        return changePredicates;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private static List<String> listFiles(Change c, ChangeQueryBuilder.Arguments args, ChangeDataCache changeDataCache) throws OrmException {
        try (Repository repo = args.repoManager.openRepository(c.getProject());){
            RevWalk rw;
            block22: {
                rw = new RevWalk(repo);
                try {
                    RevCommit ps = rw.parseCommit(changeDataCache.getTestAgainst());
                    if (ps.getParentCount() <= 1) break block22;
                    String dest = c.getDest().get();
                    Ref destBranch = repo.getRefDatabase().getRef(dest);
                    destBranch.getObjectId();
                    rw.setRevFilter(RevFilter.MERGE_BASE);
                    rw.markStart(rw.parseCommit(destBranch.getObjectId()));
                    rw.markStart(ps);
                    RevCommit base = rw.next();
                    ArrayList<String> files = new ArrayList<String>();
                    try (TreeWalk tw = new TreeWalk(repo);){
                        if (base != null) {
                            tw.setFilter(TreeFilter.ANY_DIFF);
                            tw.addTree(base.getTree());
                        }
                        tw.addTree(ps.getTree());
                        tw.setRecursive(true);
                        while (tw.next()) {
                            files.add(tw.getPathString());
                        }
                    }
                    ArrayList<String> arrayList = files;
                    rw.close();
                    return arrayList;
                }
                catch (Throwable throwable) {
                    try {
                        rw.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            List<String> list = args.changeDataFactory.create(args.db.get(), c).currentFilePaths();
            rw.close();
            return list;
        }
        catch (IOException e) {
            throw new OrmException(e);
        }
    }

    @Override
    public String toString() {
        return "conflicts:" + this.value;
    }

    private static class ChangeDataCache {
        private final Change change;
        private final Provider<ReviewDb> db;
        private final ChangeData.Factory changeDataFactory;
        private final ProjectCache projectCache;
        private ObjectId testAgainst;
        private ProjectState projectState;
        private Iterable<ObjectId> alreadyAccepted;

        ChangeDataCache(Change change, Provider<ReviewDb> db, ChangeData.Factory changeDataFactory, ProjectCache projectCache) {
            this.change = change;
            this.db = db;
            this.changeDataFactory = changeDataFactory;
            this.projectCache = projectCache;
        }

        ObjectId getTestAgainst() throws OrmException {
            if (this.testAgainst == null) {
                this.testAgainst = ObjectId.fromString(this.changeDataFactory.create(this.db.get(), this.change).currentPatchSet().getRevision().get());
            }
            return this.testAgainst;
        }

        ProjectState getProjectState() {
            if (this.projectState == null) {
                this.projectState = this.projectCache.get(this.change.getProject());
                if (this.projectState == null) {
                    throw new IllegalStateException(new NoSuchProjectException(this.change.getProject()));
                }
            }
            return this.projectState;
        }

        Iterable<ObjectId> getAlreadyAccepted(Repository repo) throws IOException {
            if (this.alreadyAccepted == null) {
                this.alreadyAccepted = SubmitDryRun.getAlreadyAccepted(repo);
            }
            return this.alreadyAccepted;
        }
    }
}

