/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.query.change;

import com.google.gerrit.common.data.LabelType;
import com.google.gerrit.common.data.LabelTypes;
import com.google.gerrit.common.data.Permission;
import com.google.gerrit.reviewdb.client.Account;
import com.google.gerrit.reviewdb.client.AccountGroup;
import com.google.gerrit.reviewdb.client.Change;
import com.google.gerrit.reviewdb.client.PatchSetApproval;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.IdentifiedUser;
import com.google.gerrit.server.index.change.ChangeField;
import com.google.gerrit.server.project.ChangeControl;
import com.google.gerrit.server.project.NoSuchChangeException;
import com.google.gerrit.server.project.ProjectCache;
import com.google.gerrit.server.project.ProjectState;
import com.google.gerrit.server.query.change.ChangeData;
import com.google.gerrit.server.query.change.ChangeIndexPredicate;
import com.google.gerrit.server.query.change.LabelPredicate;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Provider;

class EqualsLabelPredicate
extends ChangeIndexPredicate {
    private final ProjectCache projectCache;
    private final ChangeControl.GenericFactory ccFactory;
    private final IdentifiedUser.GenericFactory userFactory;
    private final Provider<ReviewDb> dbProvider;
    private final String label;
    private final int expVal;
    private final Account.Id account;
    private final AccountGroup.UUID group;

    EqualsLabelPredicate(LabelPredicate.Args args, String label, int expVal, Account.Id account) {
        super(args.field, ChangeField.formatLabel(label, expVal, account));
        this.ccFactory = args.ccFactory;
        this.projectCache = args.projectCache;
        this.userFactory = args.userFactory;
        this.dbProvider = args.dbProvider;
        this.group = args.group;
        this.label = label;
        this.expVal = expVal;
        this.account = account;
    }

    @Override
    public boolean match(ChangeData object) throws OrmException {
        Change c = object.change();
        if (c == null) {
            return false;
        }
        ProjectState project = this.projectCache.get(c.getDest().getParentKey());
        if (project == null) {
            return false;
        }
        LabelType labelType = EqualsLabelPredicate.type(project.getLabelTypes(), this.label);
        if (labelType == null) {
            return false;
        }
        boolean hasVote = false;
        for (PatchSetApproval p : object.currentApprovals()) {
            if (!labelType.matches(p)) continue;
            hasVote = true;
            if (!this.match(c, p.getValue(), p.getAccountId(), labelType)) continue;
            return true;
        }
        return !hasVote && this.expVal == 0;
    }

    private static LabelType type(LabelTypes types, String toFind) {
        if (types.byLabel(toFind) != null) {
            return types.byLabel(toFind);
        }
        for (LabelType lt : types.getLabelTypes()) {
            if (!toFind.equalsIgnoreCase(lt.getName())) continue;
            return lt;
        }
        return null;
    }

    private boolean match(Change change, int value, Account.Id approver, LabelType type) throws OrmException {
        int psVal = value;
        if (psVal == this.expVal) {
            IdentifiedUser reviewer = this.userFactory.create(approver);
            try {
                ChangeControl cc = this.ccFactory.controlFor(this.dbProvider.get(), change, reviewer);
                if (!cc.isVisible(this.dbProvider.get())) {
                    return false;
                }
                psVal = cc.getRange(Permission.forLabel(type.getName())).squash(psVal);
            }
            catch (NoSuchChangeException e) {
                return false;
            }
            if (this.account != null && !this.account.equals(approver)) {
                return false;
            }
            if (this.group != null && !reviewer.getEffectiveGroups().contains(this.group)) {
                return false;
            }
            if (psVal == this.expVal) {
                return true;
            }
        }
        return false;
    }

    @Override
    public int getCost() {
        return 1 + (this.group == null ? 0 : 1);
    }
}

