/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.query.change;

import com.google.gerrit.server.git.CodeReviewCommit;
import com.google.gerrit.server.query.change.ChangeData;
import com.google.gerrit.server.query.change.ChangeOperatorPredicate;
import com.google.gerrit.server.query.change.ChangeQueryBuilder;
import com.google.gwtorm.server.OrmException;
import java.io.IOException;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;

public class IsMergePredicate
extends ChangeOperatorPredicate {
    private final ChangeQueryBuilder.Arguments args;

    public IsMergePredicate(ChangeQueryBuilder.Arguments args, String value) {
        super("merge", value);
        this.args = args;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean match(ChangeData cd) throws OrmException {
        ObjectId id = ObjectId.fromString(cd.currentPatchSet().getRevision().get());
        try (Repository repo = this.args.repoManager.openRepository(cd.change().getProject());){
            CodeReviewCommit.CodeReviewRevWalk rw = CodeReviewCommit.newRevWalk(repo);
            try {
                boolean bl;
                RevCommit commit = ((RevWalk)rw).parseCommit(id);
                boolean bl2 = bl = commit.getParentCount() > 1;
                if (rw != null) {
                    rw.close();
                }
                return bl;
            }
            catch (Throwable throwable) {
                if (rw != null) {
                    try {
                        rw.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new OrmException(e);
        }
    }

    @Override
    public int getCost() {
        return 2;
    }
}

