/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.query.group;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.primitives.Ints;
import com.google.gerrit.common.data.GroupReference;
import com.google.gerrit.reviewdb.client.AccountGroup;
import com.google.gerrit.server.account.GroupBackend;
import com.google.gerrit.server.account.GroupBackends;
import com.google.gerrit.server.account.GroupCache;
import com.google.gerrit.server.query.LimitPredicate;
import com.google.gerrit.server.query.Predicate;
import com.google.gerrit.server.query.QueryBuilder;
import com.google.gerrit.server.query.QueryParseException;
import com.google.gerrit.server.query.group.GroupPredicates;
import com.google.inject.Inject;
import java.util.ArrayList;

public class GroupQueryBuilder
extends QueryBuilder<AccountGroup> {
    public static final String FIELD_UUID = "uuid";
    public static final String FIELD_DESCRIPTION = "description";
    public static final String FIELD_INNAME = "inname";
    public static final String FIELD_NAME = "name";
    public static final String FIELD_OWNER = "owner";
    public static final String FIELD_LIMIT = "limit";
    private static final QueryBuilder.Definition<AccountGroup, GroupQueryBuilder> mydef = new QueryBuilder.Definition(GroupQueryBuilder.class);
    private final Arguments args;

    @Inject
    GroupQueryBuilder(Arguments args) {
        super(mydef);
        this.args = args;
    }

    @QueryBuilder.Operator
    public Predicate<AccountGroup> uuid(String uuid) {
        return GroupPredicates.uuid(new AccountGroup.UUID(uuid));
    }

    @QueryBuilder.Operator
    public Predicate<AccountGroup> description(String description) throws QueryParseException {
        if (Strings.isNullOrEmpty(description)) {
            throw GroupQueryBuilder.error("description operator requires a value");
        }
        return GroupPredicates.description(description);
    }

    @QueryBuilder.Operator
    public Predicate<AccountGroup> inname(String namePart) {
        if (namePart.isEmpty()) {
            return this.name(namePart);
        }
        return GroupPredicates.inname(namePart);
    }

    @QueryBuilder.Operator
    public Predicate<AccountGroup> name(String name) {
        return GroupPredicates.name(name);
    }

    @QueryBuilder.Operator
    public Predicate<AccountGroup> owner(String owner) throws QueryParseException {
        AccountGroup group = this.args.groupCache.get(new AccountGroup.UUID(owner));
        if (group != null) {
            return GroupPredicates.owner(group.getGroupUUID());
        }
        GroupReference g = GroupBackends.findBestSuggestion(this.args.groupBackend, owner);
        if (g == null) {
            throw GroupQueryBuilder.error("Group " + owner + " not found");
        }
        return GroupPredicates.owner(g.getUUID());
    }

    @QueryBuilder.Operator
    public Predicate<AccountGroup> is(String value) throws QueryParseException {
        if ("visibletoall".equalsIgnoreCase(value)) {
            return GroupPredicates.isVisibleToAll();
        }
        throw GroupQueryBuilder.error("Invalid query");
    }

    @Override
    protected Predicate<AccountGroup> defaultField(String query) throws QueryParseException {
        ArrayList<Predicate<AccountGroup>> preds = Lists.newArrayListWithCapacity(5);
        preds.add(this.uuid(query));
        preds.add(this.name(query));
        preds.add(this.inname(query));
        if (!Strings.isNullOrEmpty(query)) {
            preds.add(this.description(query));
        }
        try {
            preds.add(this.owner(query));
        }
        catch (QueryParseException queryParseException) {
            // empty catch block
        }
        return Predicate.or(preds);
    }

    @QueryBuilder.Operator
    public Predicate<AccountGroup> limit(String query) throws QueryParseException {
        Integer limit = Ints.tryParse(query);
        if (limit == null) {
            throw GroupQueryBuilder.error("Invalid limit: " + query);
        }
        return new LimitPredicate<AccountGroup>(FIELD_LIMIT, limit);
    }

    public static class Arguments {
        final GroupCache groupCache;
        final GroupBackend groupBackend;

        @Inject
        Arguments(GroupCache groupCache, GroupBackend groupBackend) {
            this.groupCache = groupCache;
            this.groupBackend = groupBackend;
        }
    }
}

