/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.schema;

import com.google.gerrit.common.data.AccessSection;
import com.google.gerrit.common.data.GroupReference;
import com.google.gerrit.common.data.LabelType;
import com.google.gerrit.common.data.Permission;
import com.google.gerrit.common.data.PermissionRule;
import com.google.gerrit.server.git.ProjectConfig;

public class AclUtil {
    public static void grant(ProjectConfig config, AccessSection section, String permission, GroupReference ... groupList) {
        AclUtil.grant(config, section, permission, false, groupList);
    }

    public static void grant(ProjectConfig config, AccessSection section, String permission, boolean force, GroupReference ... groupList) {
        AclUtil.grant(config, section, permission, force, null, groupList);
    }

    public static void grant(ProjectConfig config, AccessSection section, String permission, boolean force, Boolean exclusive, GroupReference ... groupList) {
        Permission p = section.getPermission(permission, true);
        if (exclusive != null) {
            p.setExclusiveGroup(exclusive);
        }
        for (GroupReference group : groupList) {
            if (group == null) continue;
            PermissionRule r = AclUtil.rule(config, group);
            r.setForce(force);
            p.add(r);
        }
    }

    public static void block(ProjectConfig config, AccessSection section, String permission, GroupReference ... groupList) {
        Permission p = section.getPermission(permission, true);
        for (GroupReference group : groupList) {
            if (group == null) continue;
            PermissionRule r = AclUtil.rule(config, group);
            r.setBlock();
            p.add(r);
        }
    }

    public static void grant(ProjectConfig config, AccessSection section, LabelType type, int min, int max, GroupReference ... groupList) {
        String name = "label-" + type.getName();
        Permission p = section.getPermission(name, true);
        for (GroupReference group : groupList) {
            if (group == null) continue;
            PermissionRule r = AclUtil.rule(config, group);
            r.setRange(min, max);
            p.add(r);
        }
    }

    public static PermissionRule rule(ProjectConfig config, GroupReference group) {
        return new PermissionRule(config.resolve(group));
    }
}

