/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.schema;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.gerrit.common.Version;
import com.google.gerrit.common.data.AccessSection;
import com.google.gerrit.common.data.GroupReference;
import com.google.gerrit.common.data.LabelType;
import com.google.gerrit.common.data.LabelValue;
import com.google.gerrit.common.data.Permission;
import com.google.gerrit.common.data.PermissionRule;
import com.google.gerrit.extensions.client.InheritableBoolean;
import com.google.gerrit.reviewdb.client.Project;
import com.google.gerrit.server.GerritPersonIdent;
import com.google.gerrit.server.config.AllProjectsName;
import com.google.gerrit.server.extensions.events.GitReferenceUpdated;
import com.google.gerrit.server.git.GitRepositoryManager;
import com.google.gerrit.server.git.MetaDataUpdate;
import com.google.gerrit.server.git.ProjectConfig;
import com.google.gerrit.server.group.SystemGroupBackend;
import com.google.gerrit.server.notedb.NotesMigration;
import com.google.gerrit.server.notedb.RepoSequence;
import com.google.gerrit.server.schema.AclUtil;
import com.google.inject.Inject;
import java.io.IOException;
import org.eclipse.jgit.errors.ConfigInvalidException;
import org.eclipse.jgit.errors.RepositoryNotFoundException;
import org.eclipse.jgit.lib.BatchRefUpdate;
import org.eclipse.jgit.lib.NullProgressMonitor;
import org.eclipse.jgit.lib.ObjectInserter;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.lib.RefUpdate;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.transport.ReceiveCommand;

public class AllProjectsCreator {
    private final GitRepositoryManager mgr;
    private final AllProjectsName allProjectsName;
    private final PersonIdent serverUser;
    private final NotesMigration notesMigration;
    private String message;
    private int firstChangeId = 1;
    private GroupReference admin;
    private GroupReference batch;
    private GroupReference anonymous;
    private GroupReference registered;
    private GroupReference owners;

    @Inject
    AllProjectsCreator(GitRepositoryManager mgr, AllProjectsName allProjectsName, SystemGroupBackend systemGroupBackend, @GerritPersonIdent PersonIdent serverUser, NotesMigration notesMigration) {
        this.mgr = mgr;
        this.allProjectsName = allProjectsName;
        this.serverUser = serverUser;
        this.notesMigration = notesMigration;
        this.anonymous = systemGroupBackend.getGroup(SystemGroupBackend.ANONYMOUS_USERS);
        this.registered = systemGroupBackend.getGroup(SystemGroupBackend.REGISTERED_USERS);
        this.owners = systemGroupBackend.getGroup(SystemGroupBackend.PROJECT_OWNERS);
    }

    public AllProjectsCreator setAdministrators(GroupReference admin) {
        this.admin = admin;
        return this;
    }

    public AllProjectsCreator setBatchUsers(GroupReference batch) {
        this.batch = batch;
        return this;
    }

    public AllProjectsCreator setCommitMessage(String message) {
        this.message = message;
        return this;
    }

    public AllProjectsCreator setFirstChangeIdForNoteDb(int id) {
        Preconditions.checkArgument(id > 0, "id must be positive: %s", id);
        this.firstChangeId = id;
        return this;
    }

    public void create() throws IOException, ConfigInvalidException {
        try (Repository git = this.mgr.openRepository(this.allProjectsName);){
            this.initAllProjects(git);
        }
        catch (RepositoryNotFoundException notFound) {
            try (Repository git2 = this.mgr.createRepository(this.allProjectsName);){
                this.initAllProjects(git2);
                RefUpdate u = git2.updateRef("HEAD");
                u.link("refs/meta/config");
            }
            catch (RepositoryNotFoundException err) {
                String name = this.allProjectsName.get();
                throw new IOException("Cannot create repository " + name, err);
            }
        }
    }

    private void initAllProjects(Repository git) throws IOException, ConfigInvalidException {
        BatchRefUpdate bru = git.getRefDatabase().newBatchUpdate();
        try (MetaDataUpdate md = new MetaDataUpdate(GitReferenceUpdated.DISABLED, this.allProjectsName, git, bru);){
            md.getCommitBuilder().setAuthor(this.serverUser);
            md.getCommitBuilder().setCommitter(this.serverUser);
            md.setMessage(MoreObjects.firstNonNull(Strings.emptyToNull(this.message), "Initialized Gerrit Code Review " + Version.getVersion()));
            ProjectConfig config = ProjectConfig.read(md);
            Project p = config.getProject();
            p.setDescription("Access inherited by all other projects.");
            p.setRequireChangeID(InheritableBoolean.TRUE);
            p.setUseContentMerge(InheritableBoolean.TRUE);
            p.setUseContributorAgreements(InheritableBoolean.FALSE);
            p.setUseSignedOffBy(InheritableBoolean.FALSE);
            p.setEnableSignedPush(InheritableBoolean.FALSE);
            AccessSection cap = config.getAccessSection("GLOBAL_CAPABILITIES", true);
            AccessSection all = config.getAccessSection("refs/*", true);
            AccessSection heads = config.getAccessSection("refs/heads/*", true);
            AccessSection tags = config.getAccessSection("refs/tags/*", true);
            AccessSection meta = config.getAccessSection("refs/meta/config", true);
            AccessSection refsFor = config.getAccessSection("refs/for/*", true);
            AccessSection magic = config.getAccessSection("refs/for/refs/*", true);
            AclUtil.grant(config, cap, "administrateServer", this.admin);
            AclUtil.grant(config, all, "read", this.admin, this.anonymous);
            AclUtil.grant(config, refsFor, "addPatchSet", this.registered);
            if (this.batch != null) {
                Permission priority = cap.getPermission("priority", true);
                PermissionRule r = AclUtil.rule(config, this.batch);
                r.setAction(PermissionRule.Action.BATCH);
                priority.add(r);
                Permission stream = cap.getPermission("streamEvents", true);
                stream.add(AclUtil.rule(config, this.batch));
            }
            LabelType cr = AllProjectsCreator.initCodeReviewLabel(config);
            AclUtil.grant(config, heads, cr, -1, 1, this.registered);
            AclUtil.grant(config, heads, cr, -2, 2, this.admin, this.owners);
            AclUtil.grant(config, heads, "create", this.admin, this.owners);
            AclUtil.grant(config, heads, "push", this.admin, this.owners);
            AclUtil.grant(config, heads, "submit", this.admin, this.owners);
            AclUtil.grant(config, heads, "forgeAuthor", this.registered);
            AclUtil.grant(config, heads, "forgeCommitter", this.admin, this.owners);
            AclUtil.grant(config, heads, "editTopicName", true, this.admin, this.owners);
            AclUtil.grant(config, tags, "create", this.admin, this.owners);
            AclUtil.grant(config, tags, "createTag", this.admin, this.owners);
            AclUtil.grant(config, tags, "createSignedTag", this.admin, this.owners);
            AclUtil.grant(config, magic, "push", this.registered);
            AclUtil.grant(config, magic, "pushMerge", this.registered);
            meta.getPermission("read", true).setExclusiveGroup(true);
            AclUtil.grant(config, meta, "read", this.admin, this.owners);
            AclUtil.grant(config, meta, cr, -2, 2, this.admin, this.owners);
            AclUtil.grant(config, meta, "create", this.admin, this.owners);
            AclUtil.grant(config, meta, "push", this.admin, this.owners);
            AclUtil.grant(config, meta, "submit", this.admin, this.owners);
            config.commitToNewRef(md, "refs/meta/config");
            this.initSequences(git, bru);
            this.execute(git, bru);
        }
    }

    public static LabelType initCodeReviewLabel(ProjectConfig c) {
        LabelType type = new LabelType("Code-Review", ImmutableList.of(new LabelValue(2, "Looks good to me, approved"), new LabelValue(1, "Looks good to me, but someone else must approve"), new LabelValue(0, "No score"), new LabelValue(-1, "I would prefer this is not merged as is"), new LabelValue(-2, "This shall not be merged")));
        type.setCopyMinScore(true);
        type.setCopyAllScoresOnTrivialRebase(true);
        c.getLabelSections().put(type.getName(), type);
        return type;
    }

    private void initSequences(Repository git, BatchRefUpdate bru) throws IOException {
        if (this.notesMigration.readChangeSequence() && git.exactRef("refs/sequences/changes") == null) {
            try (ObjectInserter ins = git.newObjectInserter();){
                bru.addCommand(RepoSequence.storeNew(ins, "changes", this.firstChangeId));
                ins.flush();
            }
        }
    }

    private void execute(Repository git, BatchRefUpdate bru) throws IOException {
        try (RevWalk rw = new RevWalk(git);){
            bru.execute(rw, NullProgressMonitor.INSTANCE);
        }
        for (ReceiveCommand cmd : bru.getCommands()) {
            if (cmd.getResult() == ReceiveCommand.Result.OK) continue;
            throw new IOException("Failed to initialize " + this.allProjectsName + " refs:\n" + bru);
        }
    }
}

