/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.schema;

import com.google.gerrit.server.config.ConfigSection;
import com.google.gerrit.server.config.GerritServerConfig;
import com.google.gerrit.server.schema.BaseDataSourceType;
import com.google.gerrit.server.schema.JdbcUtil;
import com.google.gerrit.server.schema.ScriptRunner;
import com.google.inject.Inject;
import java.io.IOException;
import org.eclipse.jgit.lib.Config;

class HANA
extends BaseDataSourceType {
    private Config cfg;

    @Inject
    HANA(@GerritServerConfig Config cfg) {
        super("com.sap.db.jdbc.Driver");
        this.cfg = cfg;
    }

    @Override
    public String getUrl() {
        StringBuilder b = new StringBuilder();
        ConfigSection dbs = new ConfigSection(this.cfg, "database");
        b.append("jdbc:sap://");
        b.append(JdbcUtil.hostname(dbs.required("hostname")));
        int instance = Integer.parseInt(dbs.required("instance"));
        String port = "3" + String.format("%02d", instance) + "15";
        b.append(JdbcUtil.port(port));
        return b.toString();
    }

    @Override
    public ScriptRunner getIndexScript() throws IOException {
        return ScriptRunner.NOOP;
    }
}

