/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.schema;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.schema.SchemaVersion;
import com.google.gerrit.server.schema.Schema_104;
import com.google.gerrit.server.schema.UpdateUI;
import com.google.gwtorm.jdbc.JdbcExecutor;
import com.google.gwtorm.jdbc.JdbcSchema;
import com.google.gwtorm.schema.sql.SqlDialect;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Set;

public class Schema_105
extends SchemaVersion {
    private static final String TABLE = "changes";

    @Inject
    Schema_105(Provider<Schema_104> prior) {
        super(prior);
    }

    @Override
    protected void migrateData(ReviewDb db, UpdateUI ui) throws SQLException, OrmException {
        JdbcSchema schema = (JdbcSchema)((Object)db);
        SqlDialect dialect = schema.getDialect();
        HashMap<String, OrmException> errors = new HashMap<String, OrmException>();
        try (JdbcExecutor e = Schema_105.newExecutor(db);){
            for (String index : this.listChangesIndexes(schema)) {
                ui.message("Dropping index " + index + " on table " + TABLE);
                try {
                    dialect.dropIndex(e, TABLE, index);
                }
                catch (OrmException err) {
                    errors.put(index, err);
                }
            }
        }
        for (String index : this.listChangesIndexes(schema)) {
            String msg = "Failed to drop index " + index;
            OrmException err = (OrmException)errors.get(index);
            if (err != null) {
                msg = msg + ": " + err.getMessage();
            }
            ui.message(msg);
        }
    }

    private Set<String> listChangesIndexes(JdbcSchema schema) throws SQLException {
        ImmutableSet<String> allChanges = ImmutableSet.of("changes_allclosed", "changes_allopen", "changes_bybranchclosed", "changes_byownerclosed", "changes_byowneropen", "changes_byproject", new String[]{"changes_byprojectopen", "changes_key", "changes_submitted"});
        return Sets.intersection(schema.getDialect().listIndexes(schema.getConnection(), TABLE), allChanges);
    }
}

