/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.sshd.commands;

import com.google.common.base.Strings;
import com.google.common.io.CharStreams;
import com.google.gerrit.common.data.LabelType;
import com.google.gerrit.common.data.LabelValue;
import com.google.gerrit.extensions.api.GerritApi;
import com.google.gerrit.extensions.api.changes.AbandonInput;
import com.google.gerrit.extensions.api.changes.ChangeApi;
import com.google.gerrit.extensions.api.changes.MoveInput;
import com.google.gerrit.extensions.api.changes.NotifyHandling;
import com.google.gerrit.extensions.api.changes.RestoreInput;
import com.google.gerrit.extensions.api.changes.ReviewInput;
import com.google.gerrit.extensions.api.changes.RevisionApi;
import com.google.gerrit.extensions.restapi.RestApiException;
import com.google.gerrit.reviewdb.client.PatchSet;
import com.google.gerrit.server.OutputFormat;
import com.google.gerrit.server.config.AllProjectsName;
import com.google.gerrit.server.project.NoSuchChangeException;
import com.google.gerrit.server.project.NoSuchProjectException;
import com.google.gerrit.server.project.ProjectControl;
import com.google.gerrit.server.util.LabelVote;
import com.google.gerrit.sshd.BaseCommand;
import com.google.gerrit.sshd.CommandMetaData;
import com.google.gerrit.sshd.SshCommand;
import com.google.gerrit.sshd.commands.ApproveOption;
import com.google.gerrit.sshd.commands.PatchSetParser;
import com.google.gerrit.util.cli.CmdLineParser;
import com.google.gson.JsonSyntaxException;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.kohsuke.args4j.Argument;
import org.kohsuke.args4j.Option;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@CommandMetaData(name="review", description="Apply reviews to one or more patch sets")
public class ReviewCommand
extends SshCommand {
    private static final Logger log = LoggerFactory.getLogger(ReviewCommand.class);
    private final Set<PatchSet> patchSets = new HashSet<PatchSet>();
    @Option(name="--project", aliases={"-p"}, usage="project containing the specified patch set(s)")
    private ProjectControl projectControl;
    @Option(name="--branch", aliases={"-b"}, usage="branch containing the specified patch set(s)")
    private String branch;
    @Option(name="--message", aliases={"-m"}, usage="cover message to publish on change(s)", metaVar="MESSAGE")
    private String changeComment;
    @Option(name="--notify", aliases={"-n"}, usage="Who to send email notifications to after the review is stored.", metaVar="NOTIFYHANDLING")
    private NotifyHandling notify;
    @Option(name="--abandon", usage="abandon the specified change(s)")
    private boolean abandonChange;
    @Option(name="--restore", usage="restore the specified abandoned change(s)")
    private boolean restoreChange;
    @Option(name="--rebase", usage="rebase the specified change(s)")
    private boolean rebaseChange;
    @Option(name="--move", usage="move the specified change(s)", metaVar="BRANCH")
    private String moveToBranch;
    @Option(name="--submit", aliases={"-s"}, usage="submit the specified patch set(s)")
    private boolean submitChange;
    @Option(name="--publish", usage="publish the specified draft patch set(s)")
    private boolean publishPatchSet;
    @Option(name="--delete", usage="delete the specified draft patch set(s)")
    private boolean deleteDraftPatchSet;
    @Option(name="--json", aliases={"-j"}, usage="read review input json from stdin")
    private boolean json;
    @Option(name="--strict-labels", usage="Strictly check if the labels specified can be applied to the given patch set(s)")
    private boolean strictLabels;
    @Option(name="--tag", aliases={"-t"}, usage="applies a tag to the given review", metaVar="TAG")
    private String changeTag;
    @Inject
    private ProjectControl.Factory projectControlFactory;
    @Inject
    private AllProjectsName allProjects;
    @Inject
    private GerritApi gApi;
    @Inject
    private PatchSetParser psParser;
    private List<ApproveOption> optionList;
    private Map<String, Short> customLabels;

    @Override
    protected final CmdLineParser newCmdLineParser(Object options) {
        CmdLineParser parser = super.newCmdLineParser(options);
        for (ApproveOption c : this.optionList) {
            parser.addOption(c, c);
        }
        return parser;
    }

    @Argument(index=0, required=true, multiValued=true, metaVar="{COMMIT | CHANGE,PATCHSET}", usage="list of commits or patch sets to review")
    void addPatchSetId(String token) {
        try {
            PatchSet ps = this.psParser.parsePatchSet(token, this.projectControl, this.branch);
            this.patchSets.add(ps);
        }
        catch (BaseCommand.UnloggedFailure e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
        catch (OrmException e) {
            throw new IllegalArgumentException("database error", e);
        }
    }

    @Option(name="--label", aliases={"-l"}, usage="custom label(s) to assign", metaVar="LABEL=VALUE")
    void addLabel(String token) {
        LabelVote v = LabelVote.parseWithEquals(token);
        LabelType.checkName(v.label());
        this.customLabels.put(v.label(), v.value());
    }

    @Override
    protected void run() throws BaseCommand.UnloggedFailure {
        if (this.abandonChange) {
            if (this.restoreChange) {
                throw this.die("abandon and restore actions are mutually exclusive");
            }
            if (this.submitChange) {
                throw this.die("abandon and submit actions are mutually exclusive");
            }
            if (this.publishPatchSet) {
                throw this.die("abandon and publish actions are mutually exclusive");
            }
            if (this.deleteDraftPatchSet) {
                throw this.die("abandon and delete actions are mutually exclusive");
            }
            if (this.rebaseChange) {
                throw this.die("abandon and rebase actions are mutually exclusive");
            }
            if (this.moveToBranch != null) {
                throw this.die("abandon and move actions are mutually exclusive");
            }
        }
        if (this.publishPatchSet) {
            if (this.restoreChange) {
                throw this.die("publish and restore actions are mutually exclusive");
            }
            if (this.submitChange) {
                throw this.die("publish and submit actions are mutually exclusive");
            }
            if (this.deleteDraftPatchSet) {
                throw this.die("publish and delete actions are mutually exclusive");
            }
        }
        if (this.json) {
            if (this.restoreChange) {
                throw this.die("json and restore actions are mutually exclusive");
            }
            if (this.submitChange) {
                throw this.die("json and submit actions are mutually exclusive");
            }
            if (this.deleteDraftPatchSet) {
                throw this.die("json and delete actions are mutually exclusive");
            }
            if (this.publishPatchSet) {
                throw this.die("json and publish actions are mutually exclusive");
            }
            if (this.abandonChange) {
                throw this.die("json and abandon actions are mutually exclusive");
            }
            if (this.changeComment != null) {
                throw this.die("json and message are mutually exclusive");
            }
            if (this.rebaseChange) {
                throw this.die("json and rebase actions are mutually exclusive");
            }
            if (this.moveToBranch != null) {
                throw this.die("json and move actions are mutually exclusive");
            }
            if (this.changeTag != null) {
                throw this.die("json and tag actions are mutually exclusive");
            }
        }
        if (this.rebaseChange) {
            if (this.deleteDraftPatchSet) {
                throw this.die("rebase and delete actions are mutually exclusive");
            }
            if (this.submitChange) {
                throw this.die("rebase and submit actions are mutually exclusive");
            }
        }
        if (this.deleteDraftPatchSet && this.submitChange) {
            throw this.die("delete and submit actions are mutually exclusive");
        }
        boolean ok = true;
        ReviewInput input = null;
        if (this.json) {
            input = this.reviewFromJson();
        }
        for (PatchSet patchSet : this.patchSets) {
            try {
                if (input != null) {
                    this.applyReview(patchSet, input);
                    continue;
                }
                this.reviewPatchSet(patchSet);
            }
            catch (RestApiException | BaseCommand.UnloggedFailure e) {
                ok = false;
                this.writeError("error", e.getMessage() + "\n");
            }
            catch (NoSuchChangeException e) {
                ok = false;
                this.writeError("error", "no such change " + patchSet.getId().getParentKey().get());
            }
            catch (Exception e) {
                ok = false;
                this.writeError("fatal", "internal server error while reviewing " + patchSet.getId() + "\n");
                log.error("internal error while reviewing " + patchSet.getId(), e);
            }
        }
        if (!ok) {
            throw this.die("one or more reviews failed; review output above");
        }
    }

    private void applyReview(PatchSet patchSet, ReviewInput review) throws RestApiException {
        this.gApi.changes().id(patchSet.getId().getParentKey().get()).revision(patchSet.getRevision().get()).review(review);
    }

    private ReviewInput reviewFromJson() throws BaseCommand.UnloggedFailure {
        ReviewInput reviewInput;
        InputStreamReader r = new InputStreamReader(this.in, StandardCharsets.UTF_8);
        try {
            reviewInput = OutputFormat.JSON.newGson().fromJson(CharStreams.toString(r), ReviewInput.class);
        }
        catch (Throwable throwable) {
            try {
                try {
                    r.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (JsonSyntaxException | IOException e) {
                this.writeError("error", e.getMessage() + '\n');
                throw this.die("internal error while reading review input");
            }
        }
        r.close();
        return reviewInput;
    }

    private void reviewPatchSet(PatchSet patchSet) throws Exception {
        if (this.notify == null) {
            this.notify = NotifyHandling.ALL;
        }
        ReviewInput review = new ReviewInput();
        review.message = Strings.emptyToNull(this.changeComment);
        review.tag = Strings.emptyToNull(this.changeTag);
        review.notify = this.notify;
        review.labels = new TreeMap<String, Short>();
        review.drafts = ReviewInput.DraftHandling.PUBLISH;
        review.strictLabels = this.strictLabels;
        for (ApproveOption ao : this.optionList) {
            Short v = ao.value();
            if (v == null) continue;
            review.labels.put(ao.getLabelName(), v);
        }
        review.labels.putAll(this.customLabels);
        if (this.abandonChange || this.restoreChange || this.moveToBranch != null) {
            review.message = null;
        }
        try {
            Object input;
            if (this.abandonChange) {
                input = new AbandonInput();
                ((AbandonInput)input).message = Strings.emptyToNull(this.changeComment);
                this.applyReview(patchSet, review);
                this.changeApi(patchSet).abandon((AbandonInput)input);
            } else if (this.restoreChange) {
                input = new RestoreInput();
                ((RestoreInput)input).message = Strings.emptyToNull(this.changeComment);
                this.changeApi(patchSet).restore((RestoreInput)input);
                this.applyReview(patchSet, review);
            } else {
                this.applyReview(patchSet, review);
            }
            if (this.moveToBranch != null) {
                MoveInput moveInput = new MoveInput();
                moveInput.destinationBranch = this.moveToBranch;
                moveInput.message = Strings.emptyToNull(this.changeComment);
                this.changeApi(patchSet).move(moveInput);
            }
            if (this.rebaseChange) {
                this.revisionApi(patchSet).rebase();
            }
            if (this.submitChange) {
                this.revisionApi(patchSet).submit();
            }
            if (this.publishPatchSet) {
                this.revisionApi(patchSet).publish();
            } else if (this.deleteDraftPatchSet) {
                this.revisionApi(patchSet).delete();
            }
        }
        catch (RestApiException | IllegalStateException e) {
            throw this.die(e);
        }
    }

    private ChangeApi changeApi(PatchSet patchSet) throws RestApiException {
        return this.gApi.changes().id(patchSet.getId().getParentKey().get());
    }

    private RevisionApi revisionApi(PatchSet patchSet) throws RestApiException {
        return this.changeApi(patchSet).revision(patchSet.getRevision().get());
    }

    @Override
    protected void parseCommandLine() throws BaseCommand.UnloggedFailure {
        ProjectControl allProjectsControl;
        this.optionList = new ArrayList<ApproveOption>();
        this.customLabels = new HashMap<String, Short>();
        try {
            allProjectsControl = this.projectControlFactory.controlFor(this.allProjects);
        }
        catch (NoSuchProjectException e) {
            throw this.die("missing " + this.allProjects.get());
        }
        for (LabelType type : allProjectsControl.getLabelTypes().getLabelTypes()) {
            StringBuilder usage = new StringBuilder("score for ").append(type.getName()).append("\n");
            for (LabelValue v : type.getValues()) {
                usage.append(v.format()).append("\n");
            }
            String name = "--" + type.getName().toLowerCase();
            this.optionList.add(new ApproveOption(name, usage.toString(), type));
        }
        super.parseCommandLine();
    }
}

