/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.sshd.commands;

import com.google.common.base.Strings;
import com.google.gerrit.common.RawInputUtil;
import com.google.gerrit.common.errors.EmailException;
import com.google.gerrit.extensions.annotations.RequiresCapability;
import com.google.gerrit.extensions.api.accounts.EmailInput;
import com.google.gerrit.extensions.common.EmailInfo;
import com.google.gerrit.extensions.common.SshKeyInfo;
import com.google.gerrit.extensions.restapi.AuthException;
import com.google.gerrit.extensions.restapi.ResourceNotFoundException;
import com.google.gerrit.extensions.restapi.RestApiException;
import com.google.gerrit.reviewdb.client.Account;
import com.google.gerrit.reviewdb.client.AccountSshKey;
import com.google.gerrit.server.IdentifiedUser;
import com.google.gerrit.server.account.AccountResource;
import com.google.gerrit.server.account.AddSshKey;
import com.google.gerrit.server.account.CreateEmail;
import com.google.gerrit.server.account.DeleteActive;
import com.google.gerrit.server.account.DeleteEmail;
import com.google.gerrit.server.account.DeleteSshKey;
import com.google.gerrit.server.account.GetEmails;
import com.google.gerrit.server.account.GetSshKeys;
import com.google.gerrit.server.account.PutActive;
import com.google.gerrit.server.account.PutHttpPassword;
import com.google.gerrit.server.account.PutName;
import com.google.gerrit.server.account.PutPreferred;
import com.google.gerrit.sshd.BaseCommand;
import com.google.gerrit.sshd.CommandMetaData;
import com.google.gerrit.sshd.SshCommand;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.jgit.errors.ConfigInvalidException;
import org.eclipse.jgit.errors.RepositoryNotFoundException;
import org.kohsuke.args4j.Argument;
import org.kohsuke.args4j.Option;

@CommandMetaData(name="set-account", description="Change an account's settings")
@RequiresCapability(value="modifyAccount")
final class SetAccountCommand
extends SshCommand {
    @Argument(index=0, required=true, metaVar="USER", usage="full name, email-address, ssh username or account id")
    private Account.Id id;
    @Option(name="--full-name", metaVar="NAME", usage="display name of the account")
    private String fullName;
    @Option(name="--active", usage="set account's state to active")
    private boolean active;
    @Option(name="--inactive", usage="set account's state to inactive")
    private boolean inactive;
    @Option(name="--add-email", metaVar="EMAIL", usage="email addresses to add to the account")
    private List<String> addEmails = new ArrayList<String>();
    @Option(name="--delete-email", metaVar="EMAIL", usage="email addresses to delete from the account")
    private List<String> deleteEmails = new ArrayList<String>();
    @Option(name="--preferred-email", metaVar="EMAIL", usage="a registered email address from the account")
    private String preferredEmail;
    @Option(name="--add-ssh-key", metaVar="-|KEY", usage="public keys to add to the account")
    private List<String> addSshKeys = new ArrayList<String>();
    @Option(name="--delete-ssh-key", metaVar="-|KEY", usage="public keys to delete from the account")
    private List<String> deleteSshKeys = new ArrayList<String>();
    @Option(name="--http-password", metaVar="PASSWORD", usage="password for HTTP authentication for the account")
    private String httpPassword;
    @Option(name="--clear-http-password", usage="clear HTTP password for the account")
    private boolean clearHttpPassword;
    @Inject
    private IdentifiedUser.GenericFactory genericUserFactory;
    @Inject
    private CreateEmail.Factory createEmailFactory;
    @Inject
    private GetEmails getEmails;
    @Inject
    private DeleteEmail deleteEmail;
    @Inject
    private PutPreferred putPreferred;
    @Inject
    private PutName putName;
    @Inject
    private PutHttpPassword putHttpPassword;
    @Inject
    private PutActive putActive;
    @Inject
    private DeleteActive deleteActive;
    @Inject
    private AddSshKey addSshKey;
    @Inject
    private GetSshKeys getSshKeys;
    @Inject
    private DeleteSshKey deleteSshKey;
    private IdentifiedUser user;
    private AccountResource rsrc;

    SetAccountCommand() {
    }

    @Override
    public void run() throws Exception {
        this.validate();
        this.setAccount();
    }

    private void validate() throws BaseCommand.UnloggedFailure {
        if (this.active && this.inactive) {
            throw this.die("--active and --inactive options are mutually exclusive.");
        }
        if (this.clearHttpPassword && !Strings.isNullOrEmpty(this.httpPassword)) {
            throw this.die("--http-password and --clear-http-password options are mutually exclusive.");
        }
        if (this.addSshKeys.contains("-") && this.deleteSshKeys.contains("-")) {
            throw this.die("Only one option may use the stdin");
        }
        if (this.deleteSshKeys.contains("ALL")) {
            this.deleteSshKeys = Collections.singletonList("ALL");
        }
        if (this.deleteEmails.contains("ALL")) {
            this.deleteEmails = Collections.singletonList("ALL");
        }
        if (this.deleteEmails.contains(this.preferredEmail)) {
            throw this.die("--preferred-email and --delete-email options are mutually exclusive for the same email address.");
        }
    }

    private void setAccount() throws OrmException, IOException, BaseCommand.UnloggedFailure, ConfigInvalidException {
        this.user = this.genericUserFactory.create(this.id);
        this.rsrc = new AccountResource(this.user);
        try {
            Object in;
            for (String email : this.addEmails) {
                this.addEmail(email);
            }
            for (String email : this.deleteEmails) {
                this.deleteEmail(email);
            }
            if (this.preferredEmail != null) {
                this.putPreferred(this.preferredEmail);
            }
            if (this.fullName != null) {
                in = new PutName.Input();
                ((PutName.Input)in).name = this.fullName;
                this.putName.apply(this.rsrc, (PutName.Input)in);
            }
            if (this.httpPassword != null || this.clearHttpPassword) {
                in = new PutHttpPassword.Input();
                ((PutHttpPassword.Input)in).httpPassword = this.httpPassword;
                this.putHttpPassword.apply(this.rsrc, (PutHttpPassword.Input)in);
            }
            if (this.active) {
                this.putActive.apply(this.rsrc, null);
            } else if (this.inactive) {
                try {
                    this.deleteActive.apply(this.rsrc, null);
                }
                catch (ResourceNotFoundException in2) {
                    // empty catch block
                }
            }
            this.addSshKeys = this.readSshKey(this.addSshKeys);
            if (!this.addSshKeys.isEmpty()) {
                this.addSshKeys(this.addSshKeys);
            }
            this.deleteSshKeys = this.readSshKey(this.deleteSshKeys);
            if (!this.deleteSshKeys.isEmpty()) {
                this.deleteSshKeys(this.deleteSshKeys);
            }
        }
        catch (RestApiException e) {
            throw this.die(e.getMessage());
        }
    }

    private void addSshKeys(List<String> sshKeys) throws RestApiException, OrmException, IOException, ConfigInvalidException {
        for (String sshKey : sshKeys) {
            AddSshKey.Input in = new AddSshKey.Input();
            in.raw = RawInputUtil.create(sshKey.getBytes(StandardCharsets.UTF_8), "plain/text");
            this.addSshKey.apply(this.rsrc, in);
        }
    }

    private void deleteSshKeys(List<String> sshKeys) throws RestApiException, OrmException, RepositoryNotFoundException, IOException, ConfigInvalidException {
        List<SshKeyInfo> infos = this.getSshKeys.apply(this.rsrc);
        if (sshKeys.contains("ALL")) {
            for (SshKeyInfo i : infos) {
                this.deleteSshKey(i);
            }
        } else {
            for (String sshKey : sshKeys) {
                for (SshKeyInfo i : infos) {
                    if (!sshKey.trim().equals(i.sshPublicKey) && !sshKey.trim().equals(i.comment)) continue;
                    this.deleteSshKey(i);
                }
            }
        }
    }

    private void deleteSshKey(SshKeyInfo i) throws AuthException, OrmException, RepositoryNotFoundException, IOException, ConfigInvalidException {
        AccountSshKey sshKey = new AccountSshKey(new AccountSshKey.Id(this.user.getAccountId(), i.seq), i.sshPublicKey);
        this.deleteSshKey.apply(new AccountResource.SshKey(this.user, sshKey), null);
    }

    private void addEmail(String email) throws BaseCommand.UnloggedFailure, RestApiException, OrmException, IOException, ConfigInvalidException {
        EmailInput in = new EmailInput();
        in.email = email;
        in.noConfirmation = true;
        try {
            this.createEmailFactory.create(email).apply(this.rsrc, in);
        }
        catch (EmailException e) {
            throw this.die(e.getMessage());
        }
    }

    private void deleteEmail(String email) throws RestApiException, OrmException, IOException, ConfigInvalidException {
        if (email.equals("ALL")) {
            List<EmailInfo> emails = this.getEmails.apply(this.rsrc);
            for (EmailInfo e : emails) {
                this.deleteEmail.apply(new AccountResource.Email(this.user, e.email), new DeleteEmail.Input());
            }
        } else {
            this.deleteEmail.apply(new AccountResource.Email(this.user, email), new DeleteEmail.Input());
        }
    }

    private void putPreferred(String email) throws RestApiException, OrmException, IOException {
        for (EmailInfo e : this.getEmails.apply(this.rsrc)) {
            if (!e.email.equals(email)) continue;
            this.putPreferred.apply(new AccountResource.Email(this.user, email), null);
            return;
        }
        this.stderr.println("preferred email not found: " + email);
    }

    private List<String> readSshKey(List<String> sshKeys) throws UnsupportedEncodingException, IOException {
        int idx;
        if (!sshKeys.isEmpty() && (idx = sshKeys.indexOf("-")) >= 0) {
            String line;
            StringBuilder sshKey = new StringBuilder();
            BufferedReader br = new BufferedReader(new InputStreamReader(this.in, StandardCharsets.UTF_8));
            while ((line = br.readLine()) != null) {
                sshKey.append(line).append("\n");
            }
            sshKeys.set(idx, sshKey.toString());
        }
        return sshKeys;
    }
}

