/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.basicfunctions;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.template.soy.data.SanitizedContent;
import com.google.template.soy.data.SoyValue;
import com.google.template.soy.data.restricted.IntegerData;
import com.google.template.soy.data.restricted.StringData;
import com.google.template.soy.jssrc.restricted.JsExpr;
import com.google.template.soy.jssrc.restricted.JsExprUtils;
import com.google.template.soy.jssrc.restricted.SoyJsSrcFunction;
import com.google.template.soy.pysrc.restricted.PyExpr;
import com.google.template.soy.pysrc.restricted.PyStringExpr;
import com.google.template.soy.pysrc.restricted.SoyPySrcFunction;
import com.google.template.soy.shared.restricted.SoyJavaFunction;
import com.google.template.soy.shared.restricted.SoyPureFunction;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
@SoyPureFunction
final class StrSubFunction
implements SoyJavaFunction,
SoyJsSrcFunction,
SoyPySrcFunction {
    @Inject
    StrSubFunction() {
    }

    @Override
    public String getName() {
        return "strSub";
    }

    @Override
    public Set<Integer> getValidArgsSizes() {
        return ImmutableSet.of(Integer.valueOf(2), Integer.valueOf(3));
    }

    @Override
    public SoyValue computeForJava(List<SoyValue> args) {
        SoyValue arg0 = args.get(0);
        SoyValue arg1 = args.get(1);
        SoyValue arg2 = args.size() == 3 ? args.get(2) : null;
        Preconditions.checkArgument(arg0 instanceof StringData || arg0 instanceof SanitizedContent, "First argument to strSub() function is not StringData or SanitizedContent: %s", (Object)arg0);
        Preconditions.checkArgument(arg1 instanceof IntegerData, "Second argument to strSub() function is not IntegerData: %s", (Object)arg1);
        if (arg2 != null) {
            Preconditions.checkArgument(arg2 instanceof IntegerData, "Third argument to strSub() function is not IntegerData: %s", (Object)arg2);
        }
        String strArg0 = arg0.coerceToString();
        int intArg1 = arg1.integerValue();
        if (arg2 != null) {
            return StringData.forValue(strArg0.substring(intArg1, arg2.integerValue()));
        }
        return StringData.forValue(strArg0.substring(intArg1));
    }

    @Override
    public JsExpr computeForJsSrc(List<JsExpr> args) {
        String arg0 = JsExprUtils.toString(args.get(0)).getText();
        JsExpr arg1 = args.get(1);
        JsExpr arg2 = args.size() == 3 ? args.get(2) : null;
        return new JsExpr("(" + arg0 + ").substring(" + arg1.getText() + (arg2 != null ? "," + arg2.getText() : "") + ")", Integer.MAX_VALUE);
    }

    @Override
    public PyExpr computeForPySrc(List<PyExpr> args) {
        String base = args.get(0).toPyString().getText();
        PyExpr start = args.get(1);
        PyExpr end = args.size() == 3 ? args.get(2) : null;
        return new PyStringExpr("(" + base + ")[" + start.getText() + ":" + (end != null ? end.getText() : "") + "]");
    }
}

