/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jbcsrc;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Utf8;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableList;
import com.google.protobuf.Message;
import com.google.template.soy.data.SanitizedContent;
import com.google.template.soy.data.SoyList;
import com.google.template.soy.data.SoyMap;
import com.google.template.soy.data.SoyProtoValue;
import com.google.template.soy.data.SoyRecord;
import com.google.template.soy.data.SoyValue;
import com.google.template.soy.data.SoyValueProvider;
import com.google.template.soy.data.restricted.IntegerData;
import com.google.template.soy.jbcsrc.CodeBuilder;
import com.google.template.soy.jbcsrc.ConstructorRef;
import com.google.template.soy.jbcsrc.Expression;
import com.google.template.soy.jbcsrc.FieldRef;
import com.google.template.soy.jbcsrc.LocalVariable;
import com.google.template.soy.jbcsrc.MethodRef;
import com.google.template.soy.jbcsrc.SoyExpression;
import com.google.template.soy.jbcsrc.SoyRuntimeType;
import com.google.template.soy.jbcsrc.TemplateVariableManager;
import com.google.template.soy.jbcsrc.TypeInfo;
import com.google.template.soy.jbcsrc.api.AdvisingAppendable;
import com.google.template.soy.jbcsrc.api.AdvisingStringBuilder;
import com.google.template.soy.jbcsrc.api.RenderResult;
import com.google.template.soy.jbcsrc.shared.CompiledTemplate;
import com.google.template.soy.jbcsrc.shared.RenderContext;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import javax.annotation.Nullable;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.Label;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.Method;
import org.objectweb.asm.util.Printer;

final class BytecodeUtils {
    private static final int MAX_CONSTANT_STRING_LENGTH = 65535;
    static final TypeInfo OBJECT = TypeInfo.create(Object.class);
    static final Type ADVISING_APPENDABLE_TYPE = Type.getType(AdvisingAppendable.class);
    static final Type ADVISING_BUILDER_TYPE = Type.getType(AdvisingStringBuilder.class);
    static final Type ARRAY_LIST_TYPE = Type.getType(ArrayList.class);
    static final Type COMPILED_TEMPLATE_TYPE = Type.getType(CompiledTemplate.class);
    static final Type CONTENT_KIND_TYPE = Type.getType(SanitizedContent.ContentKind.class);
    static final Type INTEGER_DATA_TYPE = Type.getType(IntegerData.class);
    static final Type LINKED_HASH_MAP_TYPE = Type.getType(LinkedHashMap.class);
    static final Type LIST_TYPE = Type.getType(List.class);
    static final Type MESSAGE_TYPE = Type.getType(Message.class);
    static final Type NULL_POINTER_EXCEPTION_TYPE = Type.getType(NullPointerException.class);
    static final Type RENDER_CONTEXT_TYPE = Type.getType(RenderContext.class);
    static final Type RENDER_RESULT_TYPE = Type.getType(RenderResult.class);
    static final Type SANITIZED_CONTENT_TYPE = Type.getType(SanitizedContent.class);
    static final Type SOY_LIST_TYPE = Type.getType(SoyList.class);
    static final Type SOY_MAP_TYPE = Type.getType(SoyMap.class);
    static final Type SOY_PROTO_VALUE_TYPE = Type.getType(SoyProtoValue.class);
    static final Type SOY_RECORD_TYPE = Type.getType(SoyRecord.class);
    static final Type SOY_VALUE_TYPE = Type.getType(SoyValue.class);
    static final Type SOY_VALUE_PROVIDER_TYPE = Type.getType(SoyValueProvider.class);
    static final Type STRING_TYPE = Type.getType(String.class);
    static final Type THROWABLE_TYPE = Type.getType(Throwable.class);
    static final Method CLASS_INIT = Method.getMethod("void <clinit>()");
    static final Method NULLARY_INIT = Method.getMethod("void <init>()");
    private static final LoadingCache<Type, Optional<Class<?>>> objectTypeToClassCache = CacheBuilder.newBuilder().build(new CacheLoader<Type, Optional<Class<?>>>(){

        @Override
        public Optional<Class<?>> load(Type key) throws Exception {
            switch (key.getSort()) {
                case 9: {
                    Optional elementType = (Optional)objectTypeToClassCache.getUnchecked(key.getElementType());
                    if (elementType.isPresent()) {
                        return Optional.of(Array.newInstance((Class)elementType.get(), 0).getClass());
                    }
                    return Optional.absent();
                }
                case 0: {
                    return Optional.of(Void.TYPE);
                }
                case 1: {
                    return Optional.of(Boolean.TYPE);
                }
                case 3: {
                    return Optional.of(Byte.TYPE);
                }
                case 2: {
                    return Optional.of(Character.TYPE);
                }
                case 8: {
                    return Optional.of(Double.TYPE);
                }
                case 5: {
                    return Optional.of(Integer.TYPE);
                }
                case 4: {
                    return Optional.of(Short.TYPE);
                }
                case 7: {
                    return Optional.of(Long.TYPE);
                }
                case 6: {
                    return Optional.of(Float.TYPE);
                }
                case 10: {
                    try {
                        return Optional.of(Class.forName(key.getClassName(), false, BytecodeUtils.class.getClassLoader()));
                    }
                    catch (ClassNotFoundException e) {
                        return Optional.absent();
                    }
                }
            }
            throw new IllegalArgumentException("unsupported type: " + key);
        }
    });
    private static final Expression FALSE = new Expression(Type.BOOLEAN_TYPE, Expression.Feature.CHEAP, new Expression.Feature[0]){

        @Override
        void doGen(CodeBuilder mv) {
            mv.pushBoolean(false);
        }
    };
    private static final Expression TRUE = new Expression(Type.BOOLEAN_TYPE, Expression.Feature.CHEAP, new Expression.Feature[0]){

        @Override
        void doGen(CodeBuilder mv) {
            mv.pushBoolean(true);
        }
    };

    private BytecodeUtils() {
    }

    static boolean isPossiblyAssignableFrom(Type left, Type right) {
        return BytecodeUtils.doIsAssignableFrom(left, right, true);
    }

    static boolean isDefinitelyAssignableFrom(Type left, Type right) {
        return BytecodeUtils.doIsAssignableFrom(left, right, false);
    }

    private static boolean doIsAssignableFrom(Type left, Type right, boolean failOpen) {
        if (left.equals(right)) {
            return true;
        }
        if (left.getSort() != right.getSort()) {
            return false;
        }
        if (left.getSort() != 10) {
            return false;
        }
        Optional<Class<?>> leftClass = objectTypeToClassCache.getUnchecked(left);
        Optional<Class<?>> rightClass = objectTypeToClassCache.getUnchecked(right);
        if (!leftClass.isPresent() || !rightClass.isPresent()) {
            return failOpen;
        }
        return leftClass.get().isAssignableFrom(rightClass.get());
    }

    static Class<?> classFromAsmType(Type type) {
        Optional<Class<?>> maybeClass = objectTypeToClassCache.getUnchecked(type);
        if (!maybeClass.isPresent()) {
            throw new IllegalArgumentException("Could not load: " + type);
        }
        return maybeClass.get();
    }

    static Expression constant(boolean value) {
        return value ? TRUE : FALSE;
    }

    static Expression constant(final int value) {
        return new Expression(Type.INT_TYPE, Expression.Feature.CHEAP, new Expression.Feature[0]){

            @Override
            void doGen(CodeBuilder mv) {
                mv.pushInt(value);
            }
        };
    }

    static Expression constant(final char value) {
        return new Expression(Type.CHAR_TYPE, Expression.Feature.CHEAP, new Expression.Feature[0]){

            @Override
            void doGen(CodeBuilder mv) {
                mv.pushInt(value);
            }
        };
    }

    static Expression constant(final long value) {
        return new Expression(Type.LONG_TYPE, Expression.Feature.CHEAP, new Expression.Feature[0]){

            @Override
            void doGen(CodeBuilder mv) {
                mv.pushLong(value);
            }
        };
    }

    static Expression constant(final double value) {
        return new Expression(Type.DOUBLE_TYPE, Expression.Feature.CHEAP, new Expression.Feature[0]){

            @Override
            void doGen(CodeBuilder mv) {
                mv.pushDouble(value);
            }
        };
    }

    static Expression constant(String value) {
        Preconditions.checkNotNull(value);
        Preconditions.checkArgument(Utf8.encodedLength(value) <= 65535, "String is too long when encoded in utf8");
        return BytecodeUtils.stringConstant(value);
    }

    static Expression constant(String value, TemplateVariableManager manager) {
        int encodedLength = Utf8.encodedLength(value);
        if (encodedLength <= 65535) {
            return BytecodeUtils.stringConstant(value);
        }
        int startIndex = 0;
        Expression stringExpression = null;
        int length = value.length();
        do {
            int endIndex = BytecodeUtils.offsetOf65KUtf8Bytes(value, startIndex, length);
            Expression substringConstant = BytecodeUtils.stringConstant(value.substring(startIndex, endIndex));
            startIndex = endIndex;
            stringExpression = stringExpression == null ? substringConstant : stringExpression.invoke(MethodRef.STRING_CONCAT, substringConstant);
        } while (startIndex < length);
        FieldRef fieldRef = manager.addStaticField("$const_string", stringExpression);
        return fieldRef.accessor();
    }

    private static int offsetOf65KUtf8Bytes(String str, int startIndex, int endIndex) {
        int utf8Length = 0;
        for (int i = startIndex; i < endIndex; ++i) {
            char c = str.charAt(i);
            ++utf8Length;
            utf8Length = c < '\u0800' ? (utf8Length += 127 - c >>> 31) : (utf8Length += Character.isSurrogate(c) ? 1 : 2);
            if (utf8Length == 65535) {
                return i + 1;
            }
            if (utf8Length <= 65535) continue;
            return i;
        }
        return endIndex;
    }

    private static Expression stringConstant(final String value) {
        return new Expression(STRING_TYPE, Expression.Feature.CHEAP, new Expression.Feature[]{Expression.Feature.NON_NULLABLE}){

            @Override
            void doGen(CodeBuilder mv) {
                mv.pushString(value);
            }
        };
    }

    static Expression constant(@Nullable SanitizedContent.ContentKind kind) {
        return kind == null ? BytecodeUtils.constantNull(CONTENT_KIND_TYPE) : FieldRef.enumReference(kind).accessor();
    }

    static Expression constantNull(Type type) {
        Preconditions.checkArgument(type.getSort() == 10 || type.getSort() == 9, "%s is not a reference type", (Object)type);
        return new Expression(type, Expression.Feature.CHEAP, new Expression.Feature[0]){

            @Override
            void doGen(CodeBuilder mv) {
                mv.visitInsn(1);
            }
        };
    }

    static Expression numericConversion(final Expression expr, final Type to) {
        if (to.equals(expr.resultType())) {
            return expr;
        }
        if (!BytecodeUtils.isNumericPrimitive(to) || !BytecodeUtils.isNumericPrimitive(expr.resultType())) {
            throw new IllegalArgumentException("Cannot convert from " + expr.resultType() + " to " + to);
        }
        return new Expression(to, expr.features()){

            @Override
            void doGen(CodeBuilder adapter) {
                expr.gen(adapter);
                adapter.cast(expr.resultType(), to);
            }
        };
    }

    private static boolean isNumericPrimitive(Type type) {
        int sort = type.getSort();
        switch (sort) {
            case 0: 
            case 1: 
            case 9: 
            case 10: 
            case 11: {
                return false;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                return true;
            }
        }
        throw new AssertionError((Object)("unexpected type " + type));
    }

    static boolean isPrimitive(Type type) {
        switch (type.getSort()) {
            case 9: 
            case 10: {
                return false;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                return true;
            }
            case 0: 
            case 11: {
                throw new IllegalArgumentException("Invalid type: " + type);
            }
        }
        throw new AssertionError((Object)("unexpected type " + type));
    }

    static void defineDefaultConstructor(ClassVisitor cv, TypeInfo ownerType) {
        CodeBuilder mg = new CodeBuilder(1, NULLARY_INIT, null, cv);
        mg.visitCode();
        Label start = mg.mark();
        Label end = mg.newLabel();
        LocalVariable thisVar = LocalVariable.createThisVar(ownerType, start, end);
        thisVar.gen(mg);
        mg.invokeConstructor(OBJECT.type(), NULLARY_INIT);
        mg.returnValue();
        mg.mark(end);
        thisVar.tableEntry(mg);
        mg.endMethod();
    }

    static Expression compare(final int comparisonOpcode, final Expression left, final Expression right) {
        Preconditions.checkArgument(left.resultType().equals(right.resultType()), "left and right must have matching types, found %s and %s", (Object)left.resultType(), (Object)right.resultType());
        BytecodeUtils.checkIntComparisonOpcode(left.resultType(), comparisonOpcode);
        Expression.Features features = Expression.areAllCheap(left, right) ? Expression.Features.of(Expression.Feature.CHEAP, new Expression.Feature[0]) : Expression.Features.of();
        return new Expression(Type.BOOLEAN_TYPE, features){

            @Override
            void doGen(CodeBuilder mv) {
                left.gen(mv);
                right.gen(mv);
                Label ifTrue = mv.newLabel();
                Label end = mv.newLabel();
                mv.ifCmp(left.resultType(), comparisonOpcode, ifTrue);
                mv.pushBoolean(false);
                mv.goTo(end);
                mv.mark(ifTrue);
                mv.pushBoolean(true);
                mv.mark(end);
            }
        };
    }

    private static void checkIntComparisonOpcode(Type comparisonType, int opcode) {
        switch (opcode) {
            case 153: 
            case 154: {
                return;
            }
            case 155: 
            case 156: 
            case 157: 
            case 158: {
                if (comparisonType.getSort() == 9 || comparisonType.getSort() == 10) {
                    throw new IllegalArgumentException("Type: " + comparisonType + " cannot be compared via " + Printer.OPCODES[opcode]);
                }
                return;
            }
        }
        throw new IllegalArgumentException("Unsupported opcode for comparison operation: " + opcode);
    }

    static Expression logicalNot(final Expression baseExpr) {
        baseExpr.checkAssignableTo(Type.BOOLEAN_TYPE);
        Preconditions.checkArgument(baseExpr.resultType().equals(Type.BOOLEAN_TYPE), "not a boolean expression");
        return new Expression(Type.BOOLEAN_TYPE, baseExpr.features()){

            @Override
            void doGen(CodeBuilder mv) {
                baseExpr.gen(mv);
                Label ifTrue = mv.newLabel();
                Label end = mv.newLabel();
                mv.ifZCmp(154, ifTrue);
                mv.pushBoolean(true);
                mv.goTo(end);
                mv.mark(ifTrue);
                mv.pushBoolean(false);
                mv.mark(end);
            }
        };
    }

    static Expression compareSoyEquals(SoyExpression left, SoyExpression right) {
        SoyRuntimeType leftRuntimeType = left.soyRuntimeType();
        SoyRuntimeType rightRuntimeType = right.soyRuntimeType();
        if (leftRuntimeType.isKnownString()) {
            return BytecodeUtils.doEqualsString(left.unboxAs(String.class), right);
        }
        if (rightRuntimeType.isKnownString()) {
            return BytecodeUtils.doEqualsString(right.unboxAs(String.class), left);
        }
        if (leftRuntimeType.isKnownInt() && rightRuntimeType.isKnownInt()) {
            return BytecodeUtils.compare(153, left.unboxAs(Long.TYPE), right.unboxAs(Long.TYPE));
        }
        if (leftRuntimeType.isKnownNumber() && rightRuntimeType.isKnownNumber() && (leftRuntimeType.isKnownFloat() || rightRuntimeType.isKnownFloat())) {
            return BytecodeUtils.compare(153, left.coerceToDouble(), right.coerceToDouble());
        }
        return MethodRef.RUNTIME_EQUAL.invoke(left.box(), right.box());
    }

    private static Expression doEqualsString(SoyExpression stringExpr, SoyExpression other) {
        SoyRuntimeType otherRuntimeType = other.soyRuntimeType();
        if (otherRuntimeType.isKnownStringOrSanitizedContent()) {
            return stringExpr.invoke(MethodRef.EQUALS, other.unboxAs(String.class));
        }
        if (otherRuntimeType.isKnownNumber()) {
            return MethodRef.RUNTIME_STRING_EQUALS_AS_NUMBER.invoke(stringExpr, other.coerceToDouble());
        }
        return MethodRef.RUNTIME_COMPARE_STRING.invoke(stringExpr, other.box());
    }

    static Expression firstNonNull(final Expression left, final Expression right) {
        Preconditions.checkArgument(left.resultType().getSort() == 10);
        Preconditions.checkArgument(right.resultType().getSort() == 10);
        Expression.Features features = Expression.Features.of();
        if (Expression.areAllCheap(left, right)) {
            features = features.plus(Expression.Feature.CHEAP);
        }
        if (right.isNonNullable()) {
            features = features.plus(Expression.Feature.NON_NULLABLE);
        }
        return new Expression(left.resultType(), features){

            @Override
            void doGen(CodeBuilder cb) {
                Label leftIsNonNull = new Label();
                left.gen(cb);
                cb.dup();
                cb.ifNonNull(leftIsNonNull);
                cb.pop();
                right.gen(cb);
                cb.mark(leftIsNonNull);
            }
        };
    }

    static Expression ternary(final Expression condition, final Expression trueBranch, final Expression falseBranch) {
        Preconditions.checkArgument(condition.resultType().equals(Type.BOOLEAN_TYPE));
        Preconditions.checkArgument(trueBranch.resultType().getSort() == falseBranch.resultType().getSort());
        Expression.Features features = Expression.Features.of();
        if (Expression.areAllCheap(condition, trueBranch, falseBranch)) {
            features = features.plus(Expression.Feature.CHEAP);
        }
        if (trueBranch.isNonNullable() && falseBranch.isNonNullable()) {
            features = features.plus(Expression.Feature.NON_NULLABLE);
        }
        return new Expression(trueBranch.resultType(), features){

            @Override
            void doGen(CodeBuilder mv) {
                condition.gen(mv);
                Label ifFalse = new Label();
                Label end = new Label();
                mv.visitJumpInsn(153, ifFalse);
                trueBranch.gen(mv);
                mv.visitJumpInsn(167, end);
                mv.visitLabel(ifFalse);
                falseBranch.gen(mv);
                mv.visitLabel(end);
            }
        };
    }

    static Expression logicalOr(Expression ... expressions) {
        return BytecodeUtils.logicalOr(ImmutableList.copyOf(expressions));
    }

    static Expression logicalOr(List<? extends Expression> expressions) {
        return BytecodeUtils.doShortCircuitingLogicalOperator(ImmutableList.copyOf(expressions), true);
    }

    static Expression logicalAnd(Expression ... expressions) {
        return BytecodeUtils.logicalAnd(ImmutableList.copyOf(expressions));
    }

    static Expression logicalAnd(List<? extends Expression> expressions) {
        return BytecodeUtils.doShortCircuitingLogicalOperator(ImmutableList.copyOf(expressions), false);
    }

    private static Expression doShortCircuitingLogicalOperator(final ImmutableList<? extends Expression> expressions, final boolean isOrOperator) {
        Preconditions.checkArgument(!expressions.isEmpty());
        for (Expression expression : expressions) {
            expression.checkAssignableTo(Type.BOOLEAN_TYPE);
        }
        if (expressions.size() == 1) {
            return (Expression)expressions.get(0);
        }
        return new Expression(Type.BOOLEAN_TYPE, Expression.areAllCheap(expressions) ? Expression.Features.of(Expression.Feature.CHEAP, new Expression.Feature[0]) : Expression.Features.of()){

            @Override
            void doGen(CodeBuilder adapter) {
                Label end = new Label();
                Label shortCircuit = new Label();
                for (int i = 0; i < expressions.size(); ++i) {
                    Expression expr = (Expression)expressions.get(i);
                    expr.gen(adapter);
                    if (i == expressions.size() - 1) {
                        adapter.goTo(end);
                        continue;
                    }
                    adapter.ifZCmp(isOrOperator ? 154 : 153, shortCircuit);
                }
                adapter.mark(shortCircuit);
                adapter.pushBoolean(isOrOperator);
                adapter.mark(end);
            }
        };
    }

    static Expression asList(Iterable<? extends Expression> items) {
        final ImmutableList<? extends Expression> copy = ImmutableList.copyOf(items);
        if (copy.isEmpty()) {
            return MethodRef.IMMUTABLE_LIST_OF.invoke(new Expression[0]);
        }
        final Expression construct = ConstructorRef.ARRAY_LIST_SIZE.construct(BytecodeUtils.constant(copy.size()));
        return new Expression(ARRAY_LIST_TYPE, Expression.Feature.NON_NULLABLE, new Expression.Feature[0]){

            @Override
            void doGen(CodeBuilder mv) {
                construct.gen(mv);
                for (Expression child : copy) {
                    mv.dup();
                    child.gen(mv);
                    MethodRef.ARRAY_LIST_ADD.invokeUnchecked(mv);
                    mv.pop();
                }
            }
        };
    }

    static void nullCoalesce(CodeBuilder builder, Label nullExit) {
        builder.dup();
        Label nonNull = new Label();
        builder.ifNonNull(nonNull);
        builder.pop();
        builder.pushNull();
        builder.goTo(nullExit);
        builder.mark(nonNull);
    }

    static Type unboxUnchecked(CodeBuilder cb, Type fromType, Class<?> asType) {
        Preconditions.checkArgument(!SoyValue.class.isAssignableFrom(asType), "Can't use unboxUnchecked() to convert from %s to a SoyValue: %s.", (Object)fromType, asType);
        if (BytecodeUtils.isDefinitelyAssignableFrom(Type.getType(asType), fromType)) {
            return fromType;
        }
        if (asType.equals(Boolean.TYPE)) {
            MethodRef.SOY_VALUE_BOOLEAN_VALUE.invokeUnchecked(cb);
            return Type.BOOLEAN_TYPE;
        }
        if (asType.equals(Long.TYPE)) {
            MethodRef.SOY_VALUE_LONG_VALUE.invokeUnchecked(cb);
            return Type.LONG_TYPE;
        }
        if (asType.equals(Double.TYPE)) {
            MethodRef.SOY_VALUE_FLOAT_VALUE.invokeUnchecked(cb);
            return Type.DOUBLE_TYPE;
        }
        if (asType.equals(String.class)) {
            MethodRef.SOY_VALUE_STRING_VALUE.invokeUnchecked(cb);
            return STRING_TYPE;
        }
        if (asType.equals(List.class)) {
            cb.checkCast(SOY_LIST_TYPE);
            MethodRef.SOY_LIST_AS_JAVA_LIST.invokeUnchecked(cb);
            return LIST_TYPE;
        }
        if (asType.equals(Message.class)) {
            if (!BytecodeUtils.isDefinitelyAssignableFrom(SOY_PROTO_VALUE_TYPE, fromType)) {
                cb.checkCast(SOY_PROTO_VALUE_TYPE);
            }
            MethodRef.SOY_PROTO_VALUE_GET_PROTO.invokeUnchecked(cb);
            return MESSAGE_TYPE;
        }
        throw new UnsupportedOperationException("Can't unbox top of stack from " + fromType + " to " + asType);
    }

    static Expression newLinkedHashMap(Iterable<? extends Expression> keys, Iterable<? extends Expression> values) {
        final ImmutableList<? extends Expression> keysCopy = ImmutableList.copyOf(keys);
        final ImmutableList<? extends Expression> valuesCopy = ImmutableList.copyOf(values);
        Preconditions.checkArgument(keysCopy.size() == valuesCopy.size());
        for (int i = 0; i < keysCopy.size(); ++i) {
            Preconditions.checkArgument(((Expression)keysCopy.get(i)).resultType().getSort() == 10);
            Preconditions.checkArgument(((Expression)valuesCopy.get(i)).resultType().getSort() == 10);
        }
        final Expression construct = ConstructorRef.LINKED_HASH_MAP_SIZE.construct(BytecodeUtils.constant(BytecodeUtils.hashMapCapacity(keysCopy.size())));
        return new Expression(LINKED_HASH_MAP_TYPE, Expression.Feature.NON_NULLABLE, new Expression.Feature[0]){

            @Override
            void doGen(CodeBuilder mv) {
                construct.gen(mv);
                for (int i = 0; i < keysCopy.size(); ++i) {
                    Expression key = (Expression)keysCopy.get(i);
                    Expression value = (Expression)valuesCopy.get(i);
                    mv.dup();
                    key.gen(mv);
                    value.gen(mv);
                    MethodRef.LINKED_HASH_MAP_PUT.invokeUnchecked(mv);
                    mv.pop();
                }
            }
        };
    }

    private static int hashMapCapacity(int expectedSize) {
        if (expectedSize < 3) {
            return expectedSize + 1;
        }
        if (expectedSize < 0x40000000) {
            return (int)((float)expectedSize / 0.75f + 1.0f);
        }
        return Integer.MAX_VALUE;
    }
}

