/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jbcsrc;

import com.google.common.base.Preconditions;
import com.google.template.soy.jbcsrc.TypeInfo;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.security.AccessController;
import java.security.PrivilegedExceptionAction;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.util.CheckClassAdapter;
import org.objectweb.asm.util.Textifier;
import org.objectweb.asm.util.TraceClassVisitor;

final class ClassData {
    private final TypeInfo type;
    private final byte[] data;
    private final int numberOfFields;
    private final int numDetachStates;

    static ClassData create(TypeInfo type, byte[] b, int numFields, int numDetachStates) {
        return new ClassData(type, b, numFields, numDetachStates);
    }

    private ClassData(TypeInfo type, byte[] data, int numberOfFields, int numDetachStates) {
        this.type = Preconditions.checkNotNull(type);
        this.data = Preconditions.checkNotNull(data);
        this.numberOfFields = numberOfFields;
        this.numDetachStates = numDetachStates;
    }

    TypeInfo type() {
        return this.type;
    }

    byte[] data() {
        return this.data;
    }

    int numberOfFields() {
        return this.numberOfFields;
    }

    int numberOfDetachStates() {
        return this.numDetachStates;
    }

    void checkClass() {
        ClassNode cv = new ClassNode();
        new ClassReader(this.data).accept(new CheckClassAdapter(cv, true), 0);
        Preconditions.checkState(this.type.internalName().equals(cv.name));
        Preconditions.checkState(this.numberOfFields == cv.fields.size());
    }

    URL asUrl() {
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<URL>(){

                @Override
                public URL run() throws MalformedURLException {
                    return new URL("mem", "", -1, ClassData.this.type.internalName() + ".class", new URLStreamHandler(){

                        @Override
                        protected URLConnection openConnection(URL u) {
                            return new URLConnection(u){

                                @Override
                                public void connect() {
                                }

                                @Override
                                public InputStream getInputStream() {
                                    return new ByteArrayInputStream(ClassData.this.data);
                                }
                            };
                        }
                    });
                }
            });
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to create stream handler for resource url", e);
        }
    }

    public String toString() {
        StringWriter sw = new StringWriter();
        new ClassReader(this.data).accept(new TraceClassVisitor(null, new Textifier(), new PrintWriter(sw)), 0);
        return sw.toString();
    }
}

