/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.shared;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.io.Files;
import com.google.common.io.Resources;
import com.google.template.soy.SoyUtils;
import com.google.template.soy.basetree.SyntaxVersion;
import com.google.template.soy.data.internalutils.InternalValueUtils;
import com.google.template.soy.data.restricted.PrimitiveData;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class SoyGeneralOptions
implements Cloneable {
    @Nullable
    private SyntaxVersion declaredSyntaxVersion;
    private Boolean allowExternalCalls;
    private boolean strictAutoescapingRequired;
    private ImmutableMap<String, PrimitiveData> compileTimeGlobals;
    private ImmutableList<String> experimentalFeatures = ImmutableList.of();

    public SoyGeneralOptions() {
    }

    private SoyGeneralOptions(SoyGeneralOptions orig) {
        this.declaredSyntaxVersion = orig.declaredSyntaxVersion;
        this.allowExternalCalls = orig.allowExternalCalls;
        this.strictAutoescapingRequired = orig.strictAutoescapingRequired;
        this.compileTimeGlobals = orig.compileTimeGlobals;
        this.experimentalFeatures = ImmutableList.copyOf(orig.experimentalFeatures);
    }

    public SoyGeneralOptions setExperimentalFeatures(List<String> experimentalFeatures) {
        this.experimentalFeatures = ImmutableList.copyOf(experimentalFeatures);
        return this;
    }

    public ImmutableList<String> getExperimentalFeatures() {
        return this.experimentalFeatures;
    }

    public SoyGeneralOptions setDeclaredSyntaxVersionName(@Nonnull String versionName) {
        this.declaredSyntaxVersion = SyntaxVersion.forName(versionName);
        return this;
    }

    public SyntaxVersion getDeclaredSyntaxVersion(SyntaxVersion defaultSyntaxVersion) {
        return this.declaredSyntaxVersion != null ? this.declaredSyntaxVersion : defaultSyntaxVersion;
    }

    public SoyGeneralOptions setAllowExternalCalls(boolean allowExternalCalls) {
        this.allowExternalCalls = allowExternalCalls;
        return this;
    }

    public Boolean allowExternalCalls() {
        return this.allowExternalCalls;
    }

    public SoyGeneralOptions setStrictAutoescapingRequired(boolean strictAutoescapingRequired) {
        this.strictAutoescapingRequired = strictAutoescapingRequired;
        return this;
    }

    public boolean isStrictAutoescapingRequired() {
        return this.strictAutoescapingRequired;
    }

    public SoyGeneralOptions setCompileTimeGlobals(Map<String, ?> compileTimeGlobalsMap) {
        this.setCompileTimeGlobalsInternal(InternalValueUtils.convertCompileTimeGlobalsMap(compileTimeGlobalsMap));
        return this;
    }

    private void setCompileTimeGlobalsInternal(ImmutableMap<String, PrimitiveData> compileTimeGlobalsMap) {
        Preconditions.checkState(this.compileTimeGlobals == null, "Compile-time globals already set.");
        this.compileTimeGlobals = compileTimeGlobalsMap;
    }

    public SoyGeneralOptions setCompileTimeGlobals(File compileTimeGlobalsFile) throws IOException {
        this.setCompileTimeGlobalsInternal(SoyUtils.parseCompileTimeGlobals(Files.asCharSource(compileTimeGlobalsFile, StandardCharsets.UTF_8)));
        return this;
    }

    public SoyGeneralOptions setCompileTimeGlobals(URL compileTimeGlobalsResource) throws IOException {
        this.setCompileTimeGlobalsInternal(SoyUtils.parseCompileTimeGlobals(Resources.asCharSource(compileTimeGlobalsResource, StandardCharsets.UTF_8)));
        return this;
    }

    public ImmutableMap<String, PrimitiveData> getCompileTimeGlobals() {
        return this.compileTimeGlobals == null ? ImmutableMap.of() : this.compileTimeGlobals;
    }

    public final SoyGeneralOptions clone() {
        return new SoyGeneralOptions(this);
    }
}

