/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.shared.internal;

import com.google.common.base.Preconditions;
import com.google.inject.Key;
import com.google.template.soy.internal.i18n.BidiGlobalDir;
import com.google.template.soy.msgs.SoyMsgBundle;
import com.google.template.soy.shared.internal.GuiceSimpleScope;
import com.google.template.soy.shared.restricted.ApiCallScopeBindingAnnotations;
import javax.annotation.Nullable;

public class ApiCallScopeUtils {
    private static final Key<String> LOCALE_STRING_KEY = Key.get(String.class, ApiCallScopeBindingAnnotations.LocaleString.class);
    private static final Key<BidiGlobalDir> GLOBAL_DIR_KEY = Key.get(BidiGlobalDir.class);

    private ApiCallScopeUtils() {
    }

    public static void seedSharedParams(GuiceSimpleScope apiCallScope, @Nullable SoyMsgBundle msgBundle) {
        ApiCallScopeUtils.seedSharedParams(apiCallScope, msgBundle, null);
    }

    public static void seedSharedParams(GuiceSimpleScope apiCallScope, @Nullable SoyMsgBundle msgBundle, @Nullable BidiGlobalDir bidiGlobalDir) {
        String localeString;
        String string = localeString = msgBundle != null ? msgBundle.getLocaleString() : null;
        if (bidiGlobalDir == null) {
            bidiGlobalDir = BidiGlobalDir.forStaticLocale(localeString);
        }
        ApiCallScopeUtils.seedSharedParams(apiCallScope, bidiGlobalDir, localeString);
    }

    public static void seedSharedParams(GuiceSimpleScope apiCallScope, BidiGlobalDir bidiGlobalDir, @Nullable String localeString) {
        apiCallScope.seed(LOCALE_STRING_KEY, localeString);
        apiCallScope.seed(GLOBAL_DIR_KEY, Preconditions.checkNotNull(bidiGlobalDir));
    }
}

