/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.soytree;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.base.internal.IdGenerator;
import com.google.template.soy.basetree.CopyState;
import com.google.template.soy.exprparse.SoyParsingContext;
import com.google.template.soy.exprtree.VarDefn;
import com.google.template.soy.exprtree.VarRefNode;
import com.google.template.soy.soytree.AbstractParentSoyNode;
import com.google.template.soy.soytree.ExprUnion;
import com.google.template.soy.soytree.HtmlContext;
import com.google.template.soy.soytree.MsgNode;
import com.google.template.soy.soytree.PrintDirectiveNode;
import com.google.template.soy.soytree.PrintNode;
import com.google.template.soy.soytree.SoyNode;
import javax.annotation.Nullable;

public final class MsgFallbackGroupNode
extends AbstractParentSoyNode<MsgNode>
implements SoyNode.StandaloneNode,
SoyNode.SplitLevelTopNode<MsgNode>,
SoyNode.StatementNode {
    private ImmutableList<String> escapingDirectiveNames = ImmutableList.of();
    @Nullable
    private HtmlContext htmlContext;

    public MsgFallbackGroupNode(int id, SourceLocation sourceLocation) {
        super(id, sourceLocation);
    }

    private MsgFallbackGroupNode(MsgFallbackGroupNode orig, CopyState copyState) {
        super(orig, copyState);
        this.escapingDirectiveNames = orig.escapingDirectiveNames;
        this.htmlContext = orig.htmlContext;
    }

    public HtmlContext getHtmlContext() {
        return Preconditions.checkNotNull(this.htmlContext, "Cannot access HtmlContext before HtmlTransformVisitor");
    }

    public void setHtmlContext(HtmlContext value) {
        this.htmlContext = value;
    }

    public PrintNode makePrintNode(IdGenerator nodeIdGen, VarDefn var) {
        PrintNode printNode = new PrintNode.Builder(nodeIdGen.genId(), true, this.getSourceLocation()).exprUnion(new ExprUnion(new VarRefNode(var.name(), this.getSourceLocation(), false, var))).build(SoyParsingContext.exploding());
        printNode.setHtmlContext(this.htmlContext);
        for (String escapingDirective : this.getEscapingDirectiveNames()) {
            printNode.addChild(new PrintDirectiveNode.Builder(nodeIdGen.genId(), escapingDirective, "", this.getSourceLocation()).build(SoyParsingContext.exploding()));
        }
        return printNode;
    }

    @Override
    public SoyNode.Kind getKind() {
        return SoyNode.Kind.MSG_FALLBACK_GROUP_NODE;
    }

    @Override
    public String toSourceString() {
        StringBuilder sb = new StringBuilder();
        this.appendSourceStringForChildren(sb);
        sb.append("{/msg}");
        return sb.toString();
    }

    @Override
    public SoyNode.BlockNode getParent() {
        return (SoyNode.BlockNode)super.getParent();
    }

    public boolean hasFallbackMsg() {
        return this.numChildren() > 1;
    }

    public MsgNode getMsg() {
        return (MsgNode)this.getChild(0);
    }

    public MsgNode getFallbackMsg() {
        Preconditions.checkState(this.hasFallbackMsg(), "This node doesn't have a {fallbackmsg}");
        return (MsgNode)this.getChild(1);
    }

    @Override
    public MsgFallbackGroupNode copy(CopyState copyState) {
        return new MsgFallbackGroupNode(this, copyState);
    }

    public void setEscapingDirectiveNames(ImmutableList<String> escapingDirectiveNames) {
        this.escapingDirectiveNames = escapingDirectiveNames;
    }

    public ImmutableList<String> getEscapingDirectiveNames() {
        return this.escapingDirectiveNames;
    }
}

