/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.prolog_cafe.lang;

import com.googlecode.prolog_cafe.exceptions.EvaluationException;
import com.googlecode.prolog_cafe.exceptions.IllegalTypeException;
import com.googlecode.prolog_cafe.lang.DoubleTerm;
import com.googlecode.prolog_cafe.lang.NumberTerm;
import com.googlecode.prolog_cafe.lang.Term;
import com.googlecode.prolog_cafe.lang.Trail;
import com.googlecode.prolog_cafe.lang.VariableTerm;

public class IntegerTerm
extends NumberTerm {
    protected int val;

    public IntegerTerm(int n) {
        this.val = n;
    }

    public int value() {
        return this.val;
    }

    @Override
    public int type() {
        return 1;
    }

    @Override
    public boolean unify(Term term, Trail trail) {
        if (term instanceof VariableTerm) {
            return ((VariableTerm)term).unify(this, trail);
        }
        if (!(term instanceof IntegerTerm)) {
            return false;
        }
        return this.val == ((IntegerTerm)term).value();
    }

    @Override
    public boolean convertible(Class<?> clazz) {
        return IntegerTerm.convertible(Integer.class, clazz);
    }

    @Override
    public String name() {
        return "";
    }

    @Override
    public Object toJava() {
        return this.val;
    }

    public String toString() {
        return Integer.toString(this.val);
    }

    public boolean equals(Object object) {
        if (!(object instanceof IntegerTerm)) {
            return false;
        }
        return this.val == ((IntegerTerm)object).value();
    }

    public int hashCode() {
        return this.val;
    }

    @Override
    public int compareTo(Term term) {
        if (term instanceof VariableTerm || term instanceof DoubleTerm) {
            return 1;
        }
        if (!(term instanceof IntegerTerm)) {
            return -1;
        }
        int n = ((IntegerTerm)term).value();
        if (this.val == n) {
            return 0;
        }
        if (this.val > n) {
            return 1;
        }
        return -1;
    }

    @Override
    public int intValue() {
        return this.val;
    }

    @Override
    public long longValue() {
        return this.val;
    }

    @Override
    public double doubleValue() {
        return this.val;
    }

    @Override
    public int arithCompareTo(NumberTerm numberTerm) {
        if (numberTerm instanceof DoubleTerm) {
            return -numberTerm.arithCompareTo(this);
        }
        int n = numberTerm.intValue();
        if (this.val == n) {
            return 0;
        }
        if (this.val > n) {
            return 1;
        }
        return -1;
    }

    @Override
    public NumberTerm abs() {
        return new IntegerTerm(Math.abs(this.val));
    }

    @Override
    public NumberTerm acos() {
        return new DoubleTerm(Math.acos(this.doubleValue()));
    }

    @Override
    public NumberTerm add(NumberTerm numberTerm) {
        if (numberTerm instanceof DoubleTerm) {
            return numberTerm.add(this);
        }
        return new IntegerTerm(this.val + numberTerm.intValue());
    }

    @Override
    public NumberTerm and(NumberTerm numberTerm) {
        if (numberTerm instanceof DoubleTerm) {
            throw new IllegalTypeException("integer", numberTerm);
        }
        return new IntegerTerm(this.val & numberTerm.intValue());
    }

    @Override
    public NumberTerm asin() {
        return new DoubleTerm(Math.asin(this.doubleValue()));
    }

    @Override
    public NumberTerm atan() {
        return new DoubleTerm(Math.atan(this.doubleValue()));
    }

    @Override
    public NumberTerm ceil() {
        return this;
    }

    @Override
    public NumberTerm cos() {
        return new DoubleTerm(Math.cos(this.doubleValue()));
    }

    @Override
    public NumberTerm divide(NumberTerm numberTerm) {
        if (numberTerm.doubleValue() == 0.0) {
            throw new EvaluationException("zero_divisor");
        }
        return new DoubleTerm(this.doubleValue() / numberTerm.doubleValue());
    }

    @Override
    public NumberTerm exp() {
        return new DoubleTerm(Math.exp(this.doubleValue()));
    }

    @Override
    public NumberTerm floatIntPart() {
        throw new IllegalTypeException("float", this);
    }

    @Override
    public NumberTerm floatFractPart() {
        throw new IllegalTypeException("float", this);
    }

    @Override
    public NumberTerm floor() {
        return this;
    }

    @Override
    public NumberTerm intDivide(NumberTerm numberTerm) {
        if (numberTerm instanceof DoubleTerm) {
            throw new IllegalTypeException("integer", numberTerm);
        }
        if (numberTerm.intValue() == 0) {
            throw new EvaluationException("zero_divisor");
        }
        return new IntegerTerm(this.val / numberTerm.intValue());
    }

    @Override
    public NumberTerm log() {
        if (this.val == 0) {
            throw new EvaluationException("undefined");
        }
        return new DoubleTerm(Math.log(this.doubleValue()));
    }

    @Override
    public NumberTerm max(NumberTerm numberTerm) {
        if (numberTerm instanceof DoubleTerm) {
            return numberTerm.max(this);
        }
        return new IntegerTerm(Math.max(this.val, numberTerm.intValue()));
    }

    @Override
    public NumberTerm min(NumberTerm numberTerm) {
        if (numberTerm instanceof DoubleTerm) {
            return numberTerm.min(this);
        }
        return new IntegerTerm(Math.min(this.val, numberTerm.intValue()));
    }

    @Override
    public NumberTerm mod(NumberTerm numberTerm) {
        if (numberTerm instanceof DoubleTerm) {
            throw new IllegalTypeException("integer", numberTerm);
        }
        if (numberTerm.intValue() == 0) {
            throw new EvaluationException("zero_divisor");
        }
        return new IntegerTerm(this.val % numberTerm.intValue());
    }

    @Override
    public NumberTerm multiply(NumberTerm numberTerm) {
        if (numberTerm instanceof DoubleTerm) {
            return numberTerm.multiply(this);
        }
        return new IntegerTerm(this.val * numberTerm.intValue());
    }

    @Override
    public NumberTerm negate() {
        return new IntegerTerm(-this.val);
    }

    @Override
    public NumberTerm not() {
        return new IntegerTerm(~this.val);
    }

    @Override
    public NumberTerm or(NumberTerm numberTerm) {
        if (numberTerm instanceof DoubleTerm) {
            throw new IllegalTypeException("integer", numberTerm);
        }
        return new IntegerTerm(this.val | numberTerm.intValue());
    }

    @Override
    public NumberTerm pow(NumberTerm numberTerm) {
        return new DoubleTerm(Math.pow(this.doubleValue(), numberTerm.doubleValue()));
    }

    @Override
    public NumberTerm rint() {
        return new DoubleTerm(this.doubleValue());
    }

    @Override
    public NumberTerm round() {
        return this;
    }

    @Override
    public NumberTerm shiftLeft(NumberTerm numberTerm) {
        if (numberTerm instanceof DoubleTerm) {
            throw new IllegalTypeException("integer", numberTerm);
        }
        return new IntegerTerm(this.val << numberTerm.intValue());
    }

    @Override
    public NumberTerm shiftRight(NumberTerm numberTerm) {
        if (numberTerm instanceof DoubleTerm) {
            throw new IllegalTypeException("integer", numberTerm);
        }
        return new IntegerTerm(this.val >> numberTerm.intValue());
    }

    @Override
    public NumberTerm signum() {
        return new IntegerTerm((int)Math.signum((double)this.val));
    }

    @Override
    public NumberTerm sin() {
        return new DoubleTerm(Math.sin(this.doubleValue()));
    }

    @Override
    public NumberTerm sqrt() {
        if (this.val < 0) {
            throw new EvaluationException("undefined");
        }
        return new DoubleTerm(Math.sqrt(this.doubleValue()));
    }

    @Override
    public NumberTerm subtract(NumberTerm numberTerm) {
        if (numberTerm instanceof DoubleTerm) {
            return new DoubleTerm(this.doubleValue() - numberTerm.doubleValue());
        }
        return new IntegerTerm(this.val - numberTerm.intValue());
    }

    @Override
    public NumberTerm tan() {
        return new DoubleTerm(Math.tan(this.doubleValue()));
    }

    @Override
    public NumberTerm toDegrees() {
        return new DoubleTerm(Math.toDegrees(this.doubleValue()));
    }

    @Override
    public NumberTerm toFloat() {
        return new DoubleTerm(this.val);
    }

    @Override
    public NumberTerm toRadians() {
        return new DoubleTerm(Math.toRadians(this.doubleValue()));
    }

    @Override
    public NumberTerm truncate() {
        return this;
    }

    @Override
    public NumberTerm xor(NumberTerm numberTerm) {
        if (numberTerm instanceof DoubleTerm) {
            throw new IllegalTypeException("integer", numberTerm);
        }
        return new IntegerTerm(this.val ^ numberTerm.intValue());
    }
}

