/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.common.data;

import com.google.gerrit.extensions.client.SubmitType;

public class SubmitTypeRecord {
    public final Status status;
    public final SubmitType type;
    public final String errorMessage;

    public static SubmitTypeRecord OK(SubmitType type) {
        return new SubmitTypeRecord(Status.OK, type, null);
    }

    public static SubmitTypeRecord error(String err) {
        return new SubmitTypeRecord(Status.RULE_ERROR, null, err);
    }

    private SubmitTypeRecord(Status status, SubmitType type, String errorMessage) {
        this.status = status;
        this.type = type;
        this.errorMessage = errorMessage;
    }

    public boolean isOk() {
        return this.status == Status.OK;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append((Object)this.status);
        if (this.status == Status.RULE_ERROR && this.errorMessage != null) {
            sb.append('(').append(this.errorMessage).append(")");
        }
        if (this.type != null) {
            sb.append('[');
            sb.append(this.type.name());
            sb.append(']');
        }
        return sb.toString();
    }

    public static enum Status {
        OK,
        RULE_ERROR;

    }
}

