/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.extensions.client;

import java.util.EnumSet;
import java.util.Set;

public enum ListChangesOption {
    LABELS(0),
    DETAILED_LABELS(8),
    CURRENT_REVISION(1),
    ALL_REVISIONS(2),
    CURRENT_COMMIT(3),
    ALL_COMMITS(4),
    CURRENT_FILES(5),
    ALL_FILES(6),
    DETAILED_ACCOUNTS(7),
    MESSAGES(9),
    CURRENT_ACTIONS(10),
    REVIEWED(11),
    DRAFT_COMMENTS(12),
    DOWNLOAD_COMMANDS(13),
    WEB_LINKS(14),
    CHECK(15),
    CHANGE_ACTIONS(16),
    COMMIT_FOOTERS(17),
    PUSH_CERTIFICATES(18),
    REVIEWER_UPDATES(19),
    SUBMITTABLE(20),
    TRACKING_IDS(21);

    private final int value;

    private ListChangesOption(int v) {
        this.value = v;
    }

    public int getValue() {
        return this.value;
    }

    public static EnumSet<ListChangesOption> fromBits(int v) {
        EnumSet<ListChangesOption> r = EnumSet.noneOf(ListChangesOption.class);
        for (ListChangesOption o : ListChangesOption.values()) {
            if ((v & 1 << o.value) != 0) {
                r.add(o);
                v &= ~(1 << o.value);
            }
            if (v != 0) continue;
            return r;
        }
        if (v != 0) {
            throw new IllegalArgumentException("unknown " + Integer.toHexString(v));
        }
        return r;
    }

    public static int toBits(Set<ListChangesOption> set) {
        int r = 0;
        for (ListChangesOption o : set) {
            r |= 1 << o.value;
        }
        return r;
    }
}

