/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.index;

import com.google.common.base.Function;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicates;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.gerrit.index.FieldDef;
import com.google.gwtorm.server.OrmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Schema<T> {
    private static final Logger log = LoggerFactory.getLogger(Schema.class);
    private final ImmutableMap<String, FieldDef<T, ?>> fields;
    private final ImmutableMap<String, FieldDef<T, ?>> storedFields;
    private int version;

    private static <T> FieldDef<T, ?> checkSame(FieldDef<T, ?> f1, FieldDef<T, ?> f2) {
        Preconditions.checkState(f1 == f2, "Mismatched %s fields: %s != %s", (Object)f1.getName(), f1, f2);
        return f1;
    }

    public Schema(Iterable<FieldDef<T, ?>> fields) {
        this(0, fields);
    }

    public Schema(int version, Iterable<FieldDef<T, ?>> fields) {
        this.version = version;
        ImmutableMap.Builder<String, FieldDef<T, ?>> b = ImmutableMap.builder();
        ImmutableMap.Builder<String, FieldDef<T, ?>> sb = ImmutableMap.builder();
        for (FieldDef<T, ?> f : fields) {
            b.put(f.getName(), f);
            if (!f.isStored()) continue;
            sb.put(f.getName(), f);
        }
        this.fields = b.build();
        this.storedFields = sb.build();
    }

    public final int getVersion() {
        return this.version;
    }

    public final ImmutableMap<String, FieldDef<T, ?>> getFields() {
        return this.fields;
    }

    public final ImmutableMap<String, FieldDef<T, ?>> getStoredFields() {
        return this.storedFields;
    }

    @SafeVarargs
    public final Optional<FieldDef<T, ?>> getField(FieldDef<T, ?> first, FieldDef<T, ?> ... rest) {
        FieldDef<Object, ?> field = this.fields.get(first.getName());
        if (field != null) {
            return Optional.of(Schema.checkSame(field, first));
        }
        for (FieldDef<?, ?> fieldDef : rest) {
            field = this.fields.get(fieldDef.getName());
            if (field == null) continue;
            return Optional.of(Schema.checkSame(field, fieldDef));
        }
        return Optional.empty();
    }

    public final boolean hasField(FieldDef<T, ?> field) {
        FieldDef<T, ?> f = this.fields.get(field.getName());
        if (f == null) {
            return false;
        }
        Schema.checkSame(f, field);
        return true;
    }

    public final Iterable<Values<T>> buildFields(final T obj) {
        return FluentIterable.from(this.fields.values()).transform(new Function<FieldDef<T, ?>, Values<T>>(){

            @Override
            public Values<T> apply(FieldDef<T, ?> f) {
                Object v;
                try {
                    v = f.get(obj);
                }
                catch (OrmException e) {
                    log.error("error getting field {} of {}", f.getName(), obj, e);
                    return null;
                }
                if (v == null) {
                    return null;
                }
                if (f.isRepeatable()) {
                    return new Values(f, (Iterable)v);
                }
                return new Values(f, Collections.singleton(v));
            }
        }).filter(Predicates.notNull());
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).addValue(this.fields.keySet()).toString();
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public static class Values<T> {
        private final FieldDef<T, ?> field;
        private final Iterable<?> values;

        private Values(FieldDef<T, ?> field, Iterable<?> values) {
            this.field = field;
            this.values = values;
        }

        public FieldDef<T, ?> getField() {
            return this.field;
        }

        public Iterable<?> getValues() {
            return this.values;
        }
    }

    public static class Builder<T> {
        private final List<FieldDef<T, ?>> fields = new ArrayList();

        public Builder<T> add(Schema<T> schema) {
            this.fields.addAll(schema.getFields().values());
            return this;
        }

        @SafeVarargs
        public final Builder<T> add(FieldDef<T, ?> ... fields) {
            this.fields.addAll(Arrays.asList(fields));
            return this;
        }

        @SafeVarargs
        public final Builder<T> remove(FieldDef<T, ?> ... fields) {
            this.fields.removeAll(Arrays.asList(fields));
            return this;
        }

        public Schema<T> build() {
            return new Schema<T>(ImmutableList.copyOf(this.fields));
        }
    }
}

