/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.index;

import com.google.common.base.CharMatcher;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSortedMap;
import com.google.common.collect.Iterables;
import com.google.gerrit.index.FieldDef;
import com.google.gerrit.index.Schema;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import org.eclipse.jgit.lib.PersonIdent;

public class SchemaUtil {
    public static <V> ImmutableSortedMap<Integer, Schema<V>> schemasFromClass(Class<?> schemasClass, Class<V> valueClass) {
        HashMap<Integer, Schema> schemas = new HashMap<Integer, Schema>();
        for (Field f : schemasClass.getDeclaredFields()) {
            if (!Modifier.isStatic(f.getModifiers()) || !Modifier.isFinal(f.getModifiers()) || !Schema.class.isAssignableFrom(f.getType())) continue;
            ParameterizedType t = (ParameterizedType)f.getGenericType();
            if (t.getActualTypeArguments()[0] == valueClass) {
                try {
                    f.setAccessible(true);
                    Schema schema = (Schema)f.get(null);
                    Preconditions.checkArgument(f.getName().startsWith("V"));
                    schema.setVersion(Integer.parseInt(f.getName().substring(1)));
                    schemas.put(schema.getVersion(), schema);
                    continue;
                }
                catch (IllegalAccessException e) {
                    throw new IllegalArgumentException(e);
                }
            }
            throw new IllegalArgumentException("non-" + schemasClass.getSimpleName() + " schema: " + f);
        }
        if (schemas.isEmpty()) {
            throw new ExceptionInInitializerError("no ChangeSchemas found");
        }
        return ImmutableSortedMap.copyOf(schemas);
    }

    public static <V> Schema<V> schema(Collection<FieldDef<V, ?>> fields) {
        return new Schema(ImmutableList.copyOf(fields));
    }

    @SafeVarargs
    public static <V> Schema<V> schema(Schema<V> schema, FieldDef<V, ?> ... moreFields) {
        return new Schema(((ImmutableList.Builder)((ImmutableList.Builder)new ImmutableList.Builder().addAll((Iterable)schema.getFields().values())).addAll(ImmutableList.copyOf(moreFields))).build());
    }

    @SafeVarargs
    public static <V> Schema<V> schema(FieldDef<V, ?> ... fields) {
        return SchemaUtil.schema(ImmutableList.copyOf(fields));
    }

    public static Set<String> getPersonParts(PersonIdent person) {
        if (person == null) {
            return ImmutableSet.of();
        }
        return SchemaUtil.getNameParts(person.getName(), Collections.singleton(person.getEmailAddress()));
    }

    public static Set<String> getNameParts(String name) {
        return SchemaUtil.getNameParts(name, Collections.emptySet());
    }

    public static Set<String> getNameParts(String name, Iterable<String> emails) {
        Splitter at = Splitter.on('@');
        Splitter s = Splitter.on(CharMatcher.anyOf("@.- /_")).omitEmptyStrings();
        HashSet<String> parts = new HashSet<String>();
        for (String email : emails) {
            if (email == null) continue;
            String lowerEmail = email.toLowerCase(Locale.US);
            parts.add(lowerEmail);
            Iterables.addAll(parts, at.split(lowerEmail));
            Iterables.addAll(parts, s.split(lowerEmail));
        }
        if (name != null) {
            Iterables.addAll(parts, s.split(name.toLowerCase(Locale.US)));
        }
        return parts;
    }

    private SchemaUtil() {
    }
}

