/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.lucene;

import com.google.common.collect.ImmutableMap;
import com.google.gerrit.lucene.CustomMappingAnalyzer;
import com.google.gerrit.server.config.ConfigUtil;
import java.util.concurrent.TimeUnit;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.analysis.util.CharArraySet;
import org.apache.lucene.index.IndexWriterConfig;
import org.eclipse.jgit.lib.Config;

class GerritIndexWriterConfig {
    private static final ImmutableMap<String, String> CUSTOM_CHAR_MAPPING = ImmutableMap.of("_", " ", ".", " ");
    private final IndexWriterConfig luceneConfig;
    private long commitWithinMs;
    private final CustomMappingAnalyzer analyzer = new CustomMappingAnalyzer(new StandardAnalyzer(CharArraySet.EMPTY_SET), CUSTOM_CHAR_MAPPING);

    GerritIndexWriterConfig(Config cfg, String name) {
        this.luceneConfig = new IndexWriterConfig(this.analyzer).setOpenMode(IndexWriterConfig.OpenMode.CREATE_OR_APPEND).setCommitOnClose(true);
        double m = 1048576.0;
        this.luceneConfig.setRAMBufferSizeMB((double)cfg.getLong("index", name, "ramBufferSize", (long)(16.0 * m)) / m);
        this.luceneConfig.setMaxBufferedDocs(cfg.getInt("index", name, "maxBufferedDocs", -1));
        try {
            this.commitWithinMs = ConfigUtil.getTimeUnit(cfg, "index", name, "commitWithin", TimeUnit.MILLISECONDS.convert(5L, TimeUnit.MINUTES), TimeUnit.MILLISECONDS);
        }
        catch (IllegalArgumentException e) {
            this.commitWithinMs = cfg.getLong("index", name, "commitWithin", 0L);
        }
    }

    CustomMappingAnalyzer getAnalyzer() {
        return this.analyzer;
    }

    IndexWriterConfig getLuceneConfig() {
        return this.luceneConfig;
    }

    long getCommitWithinMs() {
        return this.commitWithinMs;
    }
}

