/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.metrics.dropwizard;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Histogram;
import com.codahale.metrics.Meter;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import com.google.common.base.Preconditions;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.gerrit.extensions.registration.DynamicMap;
import com.google.gerrit.extensions.registration.RegistrationHandle;
import com.google.gerrit.extensions.restapi.RestApiModule;
import com.google.gerrit.metrics.CallbackMetric;
import com.google.gerrit.metrics.CallbackMetric0;
import com.google.gerrit.metrics.CallbackMetric1;
import com.google.gerrit.metrics.Counter0;
import com.google.gerrit.metrics.Counter1;
import com.google.gerrit.metrics.Counter2;
import com.google.gerrit.metrics.Counter3;
import com.google.gerrit.metrics.Description;
import com.google.gerrit.metrics.Field;
import com.google.gerrit.metrics.Histogram0;
import com.google.gerrit.metrics.Histogram1;
import com.google.gerrit.metrics.Histogram2;
import com.google.gerrit.metrics.Histogram3;
import com.google.gerrit.metrics.MetricMaker;
import com.google.gerrit.metrics.Timer0;
import com.google.gerrit.metrics.Timer1;
import com.google.gerrit.metrics.Timer2;
import com.google.gerrit.metrics.Timer3;
import com.google.gerrit.metrics.dropwizard.BucketedMetric;
import com.google.gerrit.metrics.dropwizard.CallbackGroup;
import com.google.gerrit.metrics.dropwizard.CallbackMetricGlue;
import com.google.gerrit.metrics.dropwizard.CallbackMetricImpl0;
import com.google.gerrit.metrics.dropwizard.CallbackMetricImpl1;
import com.google.gerrit.metrics.dropwizard.CounterImpl1;
import com.google.gerrit.metrics.dropwizard.CounterImplN;
import com.google.gerrit.metrics.dropwizard.GetMetric;
import com.google.gerrit.metrics.dropwizard.HistogramImpl1;
import com.google.gerrit.metrics.dropwizard.HistogramImplN;
import com.google.gerrit.metrics.dropwizard.MetricResource;
import com.google.gerrit.metrics.dropwizard.MetricsCollection;
import com.google.gerrit.metrics.dropwizard.TimerImpl1;
import com.google.gerrit.metrics.dropwizard.TimerImplN;
import com.google.gerrit.metrics.proc.JGitMetricModule;
import com.google.gerrit.metrics.proc.ProcMetricModule;
import com.google.gerrit.server.cache.CacheMetrics;
import com.google.gerrit.server.config.ConfigResource;
import com.google.inject.Inject;
import com.google.inject.Scopes;
import com.google.inject.Singleton;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;

@Singleton
public class DropWizardMetricMaker
extends MetricMaker {
    private final MetricRegistry registry;
    private final Map<String, BucketedMetric> bucketed;
    private final Map<String, ImmutableMap<String, String>> descriptions;
    private static final Pattern METRIC_NAME_PATTERN = Pattern.compile("[a-zA-Z0-9_-]+(/[a-zA-Z0-9_-]+)*");

    @Inject
    DropWizardMetricMaker(MetricRegistry registry) {
        this.registry = registry;
        this.bucketed = new ConcurrentHashMap<String, BucketedMetric>();
        this.descriptions = new ConcurrentHashMap<String, ImmutableMap<String, String>>();
    }

    Iterable<String> getMetricNames() {
        return this.descriptions.keySet();
    }

    public Metric getMetric(String name) {
        Metric m = this.bucketed.get(name);
        return m != null ? m : this.registry.getMetrics().get(name);
    }

    public ImmutableMap<String, String> getAnnotations(String name) {
        return this.descriptions.get(name);
    }

    @Override
    public synchronized Counter0 newCounter(String name, Description desc) {
        DropWizardMetricMaker.checkCounterDescription(name, desc);
        this.define(name, desc);
        return this.newCounterImpl(name, desc.isRate());
    }

    @Override
    public synchronized <F1> Counter1<F1> newCounter(String name, Description desc, Field<F1> field1) {
        DropWizardMetricMaker.checkCounterDescription(name, desc);
        CounterImpl1<F1> m = new CounterImpl1<F1>(this, name, desc, field1);
        this.define(name, desc);
        this.bucketed.put(name, m);
        return m.counter();
    }

    @Override
    public synchronized <F1, F2> Counter2<F1, F2> newCounter(String name, Description desc, Field<F1> field1, Field<F2> field2) {
        DropWizardMetricMaker.checkCounterDescription(name, desc);
        CounterImplN m = new CounterImplN(this, name, desc, field1, field2);
        this.define(name, desc);
        this.bucketed.put(name, m);
        return m.counter2();
    }

    @Override
    public synchronized <F1, F2, F3> Counter3<F1, F2, F3> newCounter(String name, Description desc, Field<F1> field1, Field<F2> field2, Field<F3> field3) {
        DropWizardMetricMaker.checkCounterDescription(name, desc);
        CounterImplN m = new CounterImplN(this, name, desc, field1, field2, field3);
        this.define(name, desc);
        this.bucketed.put(name, m);
        return m.counter3();
    }

    private static void checkCounterDescription(String name, Description desc) {
        DropWizardMetricMaker.checkMetricName(name);
        Preconditions.checkArgument(!desc.isConstant(), "counter must not be constant");
        Preconditions.checkArgument(!desc.isGauge(), "counter must not be gauge");
    }

    CounterImpl newCounterImpl(String name, boolean isRate) {
        if (isRate) {
            final Meter m = this.registry.meter(name);
            return new CounterImpl(name, m){

                @Override
                public void incrementBy(long delta) {
                    Preconditions.checkArgument(delta >= 0L, "counter delta must be >= 0");
                    m.mark(delta);
                }
            };
        }
        final Counter m = this.registry.counter(name);
        return new CounterImpl(name, m){

            @Override
            public void incrementBy(long delta) {
                Preconditions.checkArgument(delta >= 0L, "counter delta must be >= 0");
                m.inc(delta);
            }
        };
    }

    @Override
    public synchronized Timer0 newTimer(String name, Description desc) {
        DropWizardMetricMaker.checkTimerDescription(name, desc);
        this.define(name, desc);
        return this.newTimerImpl(name);
    }

    @Override
    public synchronized <F1> Timer1<F1> newTimer(String name, Description desc, Field<F1> field1) {
        DropWizardMetricMaker.checkTimerDescription(name, desc);
        TimerImpl1<F1> m = new TimerImpl1<F1>(this, name, desc, field1);
        this.define(name, desc);
        this.bucketed.put(name, m);
        return m.timer();
    }

    @Override
    public synchronized <F1, F2> Timer2<F1, F2> newTimer(String name, Description desc, Field<F1> field1, Field<F2> field2) {
        DropWizardMetricMaker.checkTimerDescription(name, desc);
        TimerImplN m = new TimerImplN(this, name, desc, field1, field2);
        this.define(name, desc);
        this.bucketed.put(name, m);
        return m.timer2();
    }

    @Override
    public synchronized <F1, F2, F3> Timer3<F1, F2, F3> newTimer(String name, Description desc, Field<F1> field1, Field<F2> field2, Field<F3> field3) {
        DropWizardMetricMaker.checkTimerDescription(name, desc);
        TimerImplN m = new TimerImplN(this, name, desc, field1, field2, field3);
        this.define(name, desc);
        this.bucketed.put(name, m);
        return m.timer3();
    }

    private static void checkTimerDescription(String name, Description desc) {
        DropWizardMetricMaker.checkMetricName(name);
        Preconditions.checkArgument(!desc.isConstant(), "timer must not be constant");
        Preconditions.checkArgument(!desc.isGauge(), "timer must not be a gauge");
        Preconditions.checkArgument(!desc.isRate(), "timer must not be a rate");
        Preconditions.checkArgument(desc.isCumulative(), "timer must be cumulative");
        Preconditions.checkArgument(desc.getTimeUnit() != null, "timer must have a unit");
    }

    TimerImpl newTimerImpl(String name) {
        return new TimerImpl(name, this.registry.timer(name));
    }

    @Override
    public synchronized Histogram0 newHistogram(String name, Description desc) {
        DropWizardMetricMaker.checkHistogramDescription(name, desc);
        this.define(name, desc);
        return this.newHistogramImpl(name);
    }

    @Override
    public synchronized <F1> Histogram1<F1> newHistogram(String name, Description desc, Field<F1> field1) {
        DropWizardMetricMaker.checkHistogramDescription(name, desc);
        HistogramImpl1<F1> m = new HistogramImpl1<F1>(this, name, desc, field1);
        this.define(name, desc);
        this.bucketed.put(name, m);
        return m.histogram1();
    }

    @Override
    public synchronized <F1, F2> Histogram2<F1, F2> newHistogram(String name, Description desc, Field<F1> field1, Field<F2> field2) {
        DropWizardMetricMaker.checkHistogramDescription(name, desc);
        HistogramImplN m = new HistogramImplN(this, name, desc, field1, field2);
        this.define(name, desc);
        this.bucketed.put(name, m);
        return m.histogram2();
    }

    @Override
    public synchronized <F1, F2, F3> Histogram3<F1, F2, F3> newHistogram(String name, Description desc, Field<F1> field1, Field<F2> field2, Field<F3> field3) {
        DropWizardMetricMaker.checkHistogramDescription(name, desc);
        HistogramImplN m = new HistogramImplN(this, name, desc, field1, field2, field3);
        this.define(name, desc);
        this.bucketed.put(name, m);
        return m.histogram3();
    }

    private static void checkHistogramDescription(String name, Description desc) {
        DropWizardMetricMaker.checkMetricName(name);
        Preconditions.checkArgument(!desc.isConstant(), "histogram must not be constant");
        Preconditions.checkArgument(!desc.isGauge(), "histogram must not be a gauge");
        Preconditions.checkArgument(!desc.isRate(), "histogram must not be a rate");
        Preconditions.checkArgument(desc.isCumulative(), "histogram must be cumulative");
    }

    HistogramImpl newHistogramImpl(String name) {
        return new HistogramImpl(name, this.registry.histogram(name));
    }

    @Override
    public <V> CallbackMetric0<V> newCallbackMetric(String name, Class<V> valueClass, Description desc) {
        DropWizardMetricMaker.checkMetricName(name);
        this.define(name, desc);
        return new CallbackMetricImpl0<V>(this, this.registry, name, valueClass);
    }

    @Override
    public <F1, V> CallbackMetric1<F1, V> newCallbackMetric(String name, Class<V> valueClass, Description desc, Field<F1> field1) {
        DropWizardMetricMaker.checkMetricName(name);
        CallbackMetricImpl1<F1, V> m = new CallbackMetricImpl1<F1, V>(this, this.registry, name, valueClass, desc, field1);
        this.define(name, desc);
        this.bucketed.put(name, m);
        return m.create();
    }

    @Override
    public synchronized RegistrationHandle newTrigger(Set<CallbackMetric<?>> metrics, Runnable trigger) {
        final ImmutableSet<CallbackMetricGlue> all = FluentIterable.from(metrics).transform(m -> (CallbackMetricGlue)((Object)m)).toSet();
        trigger = new CallbackGroup(trigger, all);
        for (CallbackMetricGlue m2 : all) {
            m2.register(trigger);
        }
        trigger.run();
        return new RegistrationHandle(){

            @Override
            public void remove() {
                for (CallbackMetricGlue m : all) {
                    m.remove();
                }
            }
        };
    }

    synchronized void remove(String name) {
        this.bucketed.remove(name);
        this.descriptions.remove(name);
    }

    private synchronized void define(String name, Description desc) {
        if (this.descriptions.containsKey(name)) {
            ImmutableMap<String, String> annotations = this.descriptions.get(name);
            if (!desc.getAnnotations().get("DESCRIPTION").equals(annotations.get("DESCRIPTION"))) {
                throw new IllegalStateException(String.format("metric '%s' already defined", name));
            }
        } else {
            this.descriptions.put(name, desc.getAnnotations());
        }
    }

    private static void checkMetricName(String name) {
        Preconditions.checkArgument(METRIC_NAME_PATTERN.matcher(name).matches(), "invalid metric name '%s': must match pattern '%s'", (Object)name, (Object)METRIC_NAME_PATTERN.pattern());
    }

    @Override
    public String sanitizeMetricName(String name) {
        if (METRIC_NAME_PATTERN.matcher(name).matches()) {
            return name;
        }
        String first = name.substring(0, 1).replaceFirst("[^\\w-]", "_");
        if (name.length() == 1) {
            return first;
        }
        String result = first + name.substring(1).replaceAll("/[/]+", "/").replaceAll("[^\\w-/]", "_");
        if (result.endsWith("/")) {
            result = result.substring(0, result.length() - 1);
        }
        return result;
    }

    static String name(Description.FieldOrdering ordering, String codeName, String fieldValues) {
        int s;
        if (ordering == Description.FieldOrdering.PREFIX_FIELDS_BASENAME && (s = codeName.lastIndexOf(47)) > 0) {
            String prefix = codeName.substring(0, s);
            String metric = codeName.substring(s + 1);
            return prefix + '/' + fieldValues + '/' + metric;
        }
        return codeName + '/' + fieldValues;
    }

    class HistogramImpl
    extends Histogram0 {
        private final String name;
        final Histogram metric;

        private HistogramImpl(String name, Histogram metric) {
            this.name = name;
            this.metric = metric;
        }

        @Override
        public void record(long value) {
            this.metric.update(value);
        }

        @Override
        public void remove() {
            DropWizardMetricMaker.this.descriptions.remove(this.name);
            DropWizardMetricMaker.this.registry.remove(this.name);
        }
    }

    class TimerImpl
    extends Timer0 {
        private final String name;
        final Timer metric;

        private TimerImpl(String name, Timer metric) {
            this.name = name;
            this.metric = metric;
        }

        @Override
        public void record(long value, TimeUnit unit) {
            Preconditions.checkArgument(value >= 0L, "timer delta must be >= 0");
            this.metric.update(value, unit);
        }

        @Override
        public void remove() {
            DropWizardMetricMaker.this.descriptions.remove(this.name);
            DropWizardMetricMaker.this.registry.remove(this.name);
        }
    }

    abstract class CounterImpl
    extends Counter0 {
        private final String name;
        final Metric metric;

        CounterImpl(String name, Metric metric) {
            this.name = name;
            this.metric = metric;
        }

        @Override
        public void remove() {
            DropWizardMetricMaker.this.descriptions.remove(this.name);
            DropWizardMetricMaker.this.registry.remove(this.name);
        }
    }

    public static class RestModule
    extends RestApiModule {
        @Override
        protected void configure() {
            DynamicMap.mapOf(this.binder(), MetricResource.METRIC_KIND);
            this.child(ConfigResource.CONFIG_KIND, "metrics").to(MetricsCollection.class);
            this.get(MetricResource.METRIC_KIND).to(GetMetric.class);
            this.bind(CacheMetrics.class);
        }
    }

    public static class ApiModule
    extends RestApiModule {
        @Override
        protected void configure() {
            this.bind(MetricRegistry.class).in(Scopes.SINGLETON);
            this.bind(DropWizardMetricMaker.class).in(Scopes.SINGLETON);
            this.bind(MetricMaker.class).to(DropWizardMetricMaker.class);
            this.install(new ProcMetricModule());
            this.install(new JGitMetricModule());
        }
    }
}

