/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.account;

import com.google.gerrit.extensions.events.LifecycleListener;
import com.google.gerrit.extensions.restapi.ResourceConflictException;
import com.google.gerrit.lifecycle.LifecycleModule;
import com.google.gerrit.server.account.AccountState;
import com.google.gerrit.server.account.Realm;
import com.google.gerrit.server.account.SetInactiveFlag;
import com.google.gerrit.server.config.GerritServerConfig;
import com.google.gerrit.server.config.ScheduleConfig;
import com.google.gerrit.server.git.WorkQueue;
import com.google.gerrit.server.query.account.AccountPredicates;
import com.google.gerrit.server.query.account.InternalAccountQuery;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.util.concurrent.TimeUnit;
import org.eclipse.jgit.lib.Config;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AccountDeactivator
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(AccountDeactivator.class);
    private final Provider<InternalAccountQuery> accountQueryProvider;
    private final Realm realm;
    private final SetInactiveFlag sif;

    @Inject
    AccountDeactivator(Provider<InternalAccountQuery> accountQueryProvider, SetInactiveFlag sif, Realm realm) {
        this.accountQueryProvider = accountQueryProvider;
        this.sif = sif;
        this.realm = realm;
    }

    @Override
    public void run() {
        log.info("Running account deactivations");
        try {
            int numberOfAccountsDeactivated = 0;
            for (AccountState acc : this.accountQueryProvider.get().query(AccountPredicates.isActive())) {
                if (!this.processAccount(acc)) continue;
                ++numberOfAccountsDeactivated;
            }
            log.info("Deactivations complete, {} account(s) were deactivated", (Object)numberOfAccountsDeactivated);
        }
        catch (Exception e) {
            log.error("Failed to complete deactivation of accounts: " + e.getMessage(), e);
        }
    }

    private boolean processAccount(AccountState account) {
        log.debug("processing account " + account.getUserName());
        try {
            if (account.getUserName() != null && this.realm.accountBelongsToRealm(account.getExternalIds()) && !this.realm.isActive(account.getUserName())) {
                this.sif.deactivate(account.getAccount().getId());
                log.info("deactivated account " + account.getUserName());
                return true;
            }
        }
        catch (ResourceConflictException e) {
            log.info("Account {} already deactivated, continuing...", (Object)account.getUserName());
        }
        catch (Exception e) {
            log.error("Error deactivating account: {} ({}) {}", account.getUserName(), account.getAccount().getId(), e.getMessage(), e);
        }
        return false;
    }

    public String toString() {
        return "account deactivator";
    }

    static class Lifecycle
    implements LifecycleListener {
        private final WorkQueue queue;
        private final AccountDeactivator deactivator;
        private final boolean supportAutomaticAccountActivityUpdate;
        private final ScheduleConfig scheduleConfig;

        @Inject
        Lifecycle(WorkQueue queue, AccountDeactivator deactivator, @GerritServerConfig Config cfg) {
            this.queue = queue;
            this.deactivator = deactivator;
            this.scheduleConfig = new ScheduleConfig(cfg, "accountDeactivation");
            this.supportAutomaticAccountActivityUpdate = cfg.getBoolean("auth", "autoUpdateAccountActiveStatus", false);
        }

        @Override
        public void start() {
            if (!this.supportAutomaticAccountActivityUpdate) {
                return;
            }
            long interval = this.scheduleConfig.getInterval();
            long delay = this.scheduleConfig.getInitialDelay();
            if (delay == -1L && interval == -1L) {
                log.info("Ignoring missing accountDeactivator schedule configuration");
            } else if (delay < 0L || interval <= 0L) {
                log.warn("Ignoring invalid accountDeactivator schedule configuration: {}", (Object)this.scheduleConfig);
            } else {
                this.queue.getDefaultQueue().scheduleAtFixedRate(this.deactivator, delay, interval, TimeUnit.MILLISECONDS);
            }
        }

        @Override
        public void stop() {
        }
    }

    public static class Module
    extends LifecycleModule {
        @Override
        protected void configure() {
            this.listener().to(Lifecycle.class);
        }
    }
}

