/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.account;

import com.google.common.collect.Iterables;
import com.google.gerrit.common.data.GlobalCapability;
import com.google.gerrit.common.data.PermissionRange;
import com.google.gerrit.extensions.api.access.GlobalOrPluginPermission;
import com.google.gerrit.extensions.api.access.PluginPermission;
import com.google.gerrit.extensions.config.CapabilityDefinition;
import com.google.gerrit.extensions.registration.DynamicMap;
import com.google.gerrit.extensions.restapi.AuthException;
import com.google.gerrit.extensions.restapi.BinaryResult;
import com.google.gerrit.extensions.restapi.RestReadView;
import com.google.gerrit.server.CurrentUser;
import com.google.gerrit.server.OptionUtil;
import com.google.gerrit.server.OutputFormat;
import com.google.gerrit.server.account.AccountLimits;
import com.google.gerrit.server.account.AccountResource;
import com.google.gerrit.server.git.QueueProvider;
import com.google.gerrit.server.permissions.GlobalPermission;
import com.google.gerrit.server.permissions.PermissionBackend;
import com.google.gerrit.server.permissions.PermissionBackendException;
import com.google.gson.reflect.TypeToken;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.kohsuke.args4j.Option;

class GetCapabilities
implements RestReadView<AccountResource> {
    private Set<String> query;
    private final PermissionBackend permissionBackend;
    private final AccountLimits.Factory limitsFactory;
    private final Provider<CurrentUser> self;
    private final DynamicMap<CapabilityDefinition> pluginCapabilities;

    @Option(name="-q", metaVar="CAP", usage="Capability to inspect")
    void addQuery(String name) {
        if (this.query == null) {
            this.query = new HashSet<String>();
        }
        Iterables.addAll(this.query, OptionUtil.splitOptionValue(name));
    }

    @Inject
    GetCapabilities(PermissionBackend permissionBackend, AccountLimits.Factory limitsFactory, Provider<CurrentUser> self, DynamicMap<CapabilityDefinition> pluginCapabilities) {
        this.permissionBackend = permissionBackend;
        this.limitsFactory = limitsFactory;
        this.self = self;
        this.pluginCapabilities = pluginCapabilities;
    }

    @Override
    public Object apply(AccountResource resource) throws AuthException, PermissionBackendException {
        PermissionBackend.WithUser perm = this.permissionBackend.user(this.self);
        if (!this.self.get().hasSameAccountId(resource.getUser())) {
            perm.check(GlobalPermission.ADMINISTRATE_SERVER);
            perm = this.permissionBackend.user(resource.getUser());
        }
        LinkedHashMap<String, Object> have = new LinkedHashMap<String, Object>();
        for (GlobalOrPluginPermission p : perm.test(this.permissionsToTest())) {
            have.put(p.permissionName(), true);
        }
        AccountLimits limits = this.limitsFactory.create(resource.getUser());
        this.addRanges(have, limits);
        this.addPriority(have, limits);
        return OutputFormat.JSON.newGson().toJsonTree(have, new TypeToken<Map<String, Object>>(){}.getType());
    }

    private Set<GlobalOrPluginPermission> permissionsToTest() {
        HashSet<GlobalOrPluginPermission> toTest = new HashSet<GlobalOrPluginPermission>();
        for (GlobalPermission p : GlobalPermission.values()) {
            if (!this.want(p.permissionName())) continue;
            toTest.add(p);
        }
        for (String pluginName : this.pluginCapabilities.plugins()) {
            for (String capability : this.pluginCapabilities.byPlugin(pluginName).keySet()) {
                PluginPermission p = new PluginPermission(pluginName, capability);
                if (!this.want(p.permissionName())) continue;
                toTest.add(p);
            }
        }
        return toTest;
    }

    private boolean want(String name) {
        return this.query == null || this.query.contains(name.toLowerCase());
    }

    private void addRanges(Map<String, Object> have, AccountLimits limits) {
        for (String name : GlobalCapability.getRangeNames()) {
            if (!this.want(name) || !limits.hasExplicitRange(name)) continue;
            have.put(name, new Range(limits.getRange(name)));
        }
    }

    private void addPriority(Map<String, Object> have, AccountLimits limits) {
        QueueProvider.QueueType queue = limits.getQueueType();
        if (queue != QueueProvider.QueueType.INTERACTIVE || this.query != null && this.query.contains("priority")) {
            have.put("priority", (Object)queue);
        }
    }

    @Singleton
    static class CheckOne
    implements RestReadView<AccountResource.Capability> {
        CheckOne() {
        }

        public BinaryResult apply(AccountResource.Capability resource) {
            return BinaryResult.create("ok\n");
        }
    }

    private static class Range {
        private transient PermissionRange range;
        private int min;
        private int max;

        Range(PermissionRange r) {
            this.range = r;
            this.min = r.getMin();
            this.max = r.getMax();
        }

        public String toString() {
            return this.range.toString();
        }
    }
}

