/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.account;

import com.google.gerrit.extensions.client.EditPreferencesInfo;
import com.google.gerrit.extensions.restapi.AuthException;
import com.google.gerrit.extensions.restapi.RestReadView;
import com.google.gerrit.reviewdb.client.Account;
import com.google.gerrit.server.CurrentUser;
import com.google.gerrit.server.account.AccountResource;
import com.google.gerrit.server.account.VersionedAccountPreferences;
import com.google.gerrit.server.config.AllUsersName;
import com.google.gerrit.server.config.ConfigUtil;
import com.google.gerrit.server.git.GitRepositoryManager;
import com.google.gerrit.server.permissions.GlobalPermission;
import com.google.gerrit.server.permissions.PermissionBackend;
import com.google.gerrit.server.permissions.PermissionBackendException;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import java.io.IOException;
import org.eclipse.jgit.errors.ConfigInvalidException;
import org.eclipse.jgit.errors.RepositoryNotFoundException;
import org.eclipse.jgit.lib.Repository;

@Singleton
public class GetEditPreferences
implements RestReadView<AccountResource> {
    private final Provider<CurrentUser> self;
    private final PermissionBackend permissionBackend;
    private final AllUsersName allUsersName;
    private final GitRepositoryManager gitMgr;

    @Inject
    GetEditPreferences(Provider<CurrentUser> self, PermissionBackend permissionBackend, AllUsersName allUsersName, GitRepositoryManager gitMgr) {
        this.self = self;
        this.permissionBackend = permissionBackend;
        this.allUsersName = allUsersName;
        this.gitMgr = gitMgr;
    }

    public EditPreferencesInfo apply(AccountResource rsrc) throws AuthException, IOException, ConfigInvalidException, PermissionBackendException {
        if (!this.self.get().hasSameAccountId(rsrc.getUser())) {
            this.permissionBackend.user(this.self).check(GlobalPermission.MODIFY_ACCOUNT);
        }
        return GetEditPreferences.readFromGit(rsrc.getUser().getAccountId(), this.gitMgr, this.allUsersName, null);
    }

    static EditPreferencesInfo readFromGit(Account.Id id, GitRepositoryManager gitMgr, AllUsersName allUsersName, EditPreferencesInfo in) throws IOException, ConfigInvalidException, RepositoryNotFoundException {
        try (Repository git = gitMgr.openRepository(allUsersName);){
            VersionedAccountPreferences p = VersionedAccountPreferences.forUser(id);
            p.load(git);
            EditPreferencesInfo editPreferencesInfo = ConfigUtil.loadSection(p.getConfig(), "edit", null, new EditPreferencesInfo(), EditPreferencesInfo.defaults(), in);
            return editPreferencesInfo;
        }
    }
}

