/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.account.externalids;

import com.github.rholder.retry.RetryException;
import com.github.rholder.retry.Retryer;
import com.github.rholder.retry.RetryerBuilder;
import com.github.rholder.retry.StopStrategies;
import com.github.rholder.retry.WaitStrategies;
import com.google.auto.value.AutoValue;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Streams;
import com.google.common.util.concurrent.Runnables;
import com.google.gerrit.common.Nullable;
import com.google.gerrit.metrics.Counter0;
import com.google.gerrit.metrics.Description;
import com.google.gerrit.metrics.MetricMaker;
import com.google.gerrit.reviewdb.client.Account;
import com.google.gerrit.reviewdb.client.Project;
import com.google.gerrit.server.GerritPersonIdent;
import com.google.gerrit.server.IdentifiedUser;
import com.google.gerrit.server.account.AccountCache;
import com.google.gerrit.server.account.externalids.AutoValue_ExternalIdsUpdate_OpenRepo;
import com.google.gerrit.server.account.externalids.AutoValue_ExternalIdsUpdate_RefsMetaExternalIdsUpdate;
import com.google.gerrit.server.account.externalids.ExternalId;
import com.google.gerrit.server.account.externalids.ExternalIdCache;
import com.google.gerrit.server.account.externalids.ExternalIds;
import com.google.gerrit.server.config.AllUsersName;
import com.google.gerrit.server.extensions.events.GitReferenceUpdated;
import com.google.gerrit.server.git.GitRepositoryManager;
import com.google.gerrit.server.git.LockFailureException;
import com.google.gwtorm.server.OrmDuplicateKeyException;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.jgit.errors.ConfigInvalidException;
import org.eclipse.jgit.lib.CommitBuilder;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectInserter;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.lib.RefUpdate;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.notes.NoteMap;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;

public class ExternalIdsUpdate {
    private static final String COMMIT_MSG = "Update external IDs";
    private static final Retryer<RefsMetaExternalIdsUpdate> RETRYER = ExternalIdsUpdate.retryerBuilder().build();
    private final GitRepositoryManager repoManager;
    @Nullable
    private final AccountCache accountCache;
    private final AllUsersName allUsersName;
    private final ExternalIds externalIds;
    private final ExternalIdCache externalIdCache;
    private final PersonIdent committerIdent;
    private final PersonIdent authorIdent;
    @Nullable
    private final IdentifiedUser currentUser;
    private final GitReferenceUpdated gitRefUpdated;
    private final Runnable afterReadRevision;
    private final Retryer<RefsMetaExternalIdsUpdate> retryer;
    private final Counter0 updateCount;

    @VisibleForTesting
    public static RetryerBuilder<RefsMetaExternalIdsUpdate> retryerBuilder() {
        return RetryerBuilder.newBuilder().retryIfException(e -> e instanceof LockFailureException).withWaitStrategy(WaitStrategies.join(WaitStrategies.exponentialWait(2L, TimeUnit.SECONDS), WaitStrategies.randomWait(50L, TimeUnit.MILLISECONDS))).withStopStrategy(StopStrategies.stopAfterDelay(10L, TimeUnit.SECONDS));
    }

    private ExternalIdsUpdate(GitRepositoryManager repoManager, @Nullable AccountCache accountCache, AllUsersName allUsersName, MetricMaker metricMaker, ExternalIds externalIds, ExternalIdCache externalIdCache, PersonIdent committerIdent, PersonIdent authorIdent, @Nullable IdentifiedUser currentUser, GitReferenceUpdated gitRefUpdated) {
        this(repoManager, accountCache, allUsersName, metricMaker, externalIds, externalIdCache, committerIdent, authorIdent, currentUser, gitRefUpdated, Runnables.doNothing(), RETRYER);
    }

    @VisibleForTesting
    public ExternalIdsUpdate(GitRepositoryManager repoManager, @Nullable AccountCache accountCache, AllUsersName allUsersName, MetricMaker metricMaker, ExternalIds externalIds, ExternalIdCache externalIdCache, PersonIdent committerIdent, PersonIdent authorIdent, @Nullable IdentifiedUser currentUser, GitReferenceUpdated gitRefUpdated, Runnable afterReadRevision, Retryer<RefsMetaExternalIdsUpdate> retryer) {
        this.repoManager = Preconditions.checkNotNull(repoManager, "repoManager");
        this.accountCache = accountCache;
        this.allUsersName = Preconditions.checkNotNull(allUsersName, "allUsersName");
        this.committerIdent = Preconditions.checkNotNull(committerIdent, "committerIdent");
        this.externalIds = Preconditions.checkNotNull(externalIds, "externalIds");
        this.externalIdCache = Preconditions.checkNotNull(externalIdCache, "externalIdCache");
        this.authorIdent = Preconditions.checkNotNull(authorIdent, "authorIdent");
        this.currentUser = currentUser;
        this.gitRefUpdated = Preconditions.checkNotNull(gitRefUpdated, "gitRefUpdated");
        this.afterReadRevision = Preconditions.checkNotNull(afterReadRevision, "afterReadRevision");
        this.retryer = Preconditions.checkNotNull(retryer, "retryer");
        this.updateCount = metricMaker.newCounter("notedb/external_id_update_count", new Description("Total number of external ID updates.").setRate().setUnit("updates"));
    }

    public void insert(ExternalId extId) throws IOException, ConfigInvalidException, OrmException {
        this.insert(Collections.singleton(extId));
    }

    public void insert(Collection<ExternalId> extIds) throws IOException, ConfigInvalidException, OrmException {
        RefsMetaExternalIdsUpdate u = this.updateNoteMap(o -> {
            UpdatedExternalIds updatedExtIds = new UpdatedExternalIds();
            for (ExternalId extId : extIds) {
                ExternalId insertedExtId = ExternalIdsUpdate.insert(o.rw(), o.ins(), o.noteMap(), extId);
                updatedExtIds.onUpdate(insertedExtId);
            }
            return updatedExtIds;
        });
        this.externalIdCache.onCreate(u.oldRev(), u.newRev(), u.updatedExtIds().getUpdated());
        this.evictAccounts(u);
    }

    public void upsert(ExternalId extId) throws IOException, ConfigInvalidException, OrmException {
        this.upsert(Collections.singleton(extId));
    }

    public void upsert(Collection<ExternalId> extIds) throws IOException, ConfigInvalidException, OrmException {
        RefsMetaExternalIdsUpdate u = this.updateNoteMap(o -> {
            UpdatedExternalIds updatedExtIds = new UpdatedExternalIds();
            for (ExternalId extId : extIds) {
                ExternalId updatedExtId = ExternalIdsUpdate.upsert(o.rw(), o.ins(), o.noteMap(), extId);
                updatedExtIds.onUpdate(updatedExtId);
            }
            return updatedExtIds;
        });
        this.externalIdCache.onUpdate(u.oldRev(), u.newRev(), u.updatedExtIds().getUpdated());
        this.evictAccounts(u);
    }

    public void delete(ExternalId extId) throws IOException, ConfigInvalidException, OrmException {
        this.delete(Collections.singleton(extId));
    }

    public void delete(Collection<ExternalId> extIds) throws IOException, ConfigInvalidException, OrmException {
        RefsMetaExternalIdsUpdate u = this.updateNoteMap(o -> {
            UpdatedExternalIds updatedExtIds = new UpdatedExternalIds();
            for (ExternalId extId : extIds) {
                ExternalId removedExtId = ExternalIdsUpdate.remove(o.rw(), o.noteMap(), extId);
                updatedExtIds.onRemove(removedExtId);
            }
            return updatedExtIds;
        });
        this.externalIdCache.onRemove(u.oldRev(), u.newRev(), u.updatedExtIds().getRemoved());
        this.evictAccounts(u);
    }

    public void delete(Account.Id accountId, ExternalId.Key extIdKey) throws IOException, ConfigInvalidException, OrmException {
        this.delete(accountId, Collections.singleton(extIdKey));
    }

    public void delete(Account.Id accountId, Collection<ExternalId.Key> extIdKeys) throws IOException, ConfigInvalidException, OrmException {
        RefsMetaExternalIdsUpdate u = this.updateNoteMap(o -> {
            UpdatedExternalIds updatedExtIds = new UpdatedExternalIds();
            for (ExternalId.Key extIdKey : extIdKeys) {
                ExternalId removedExtId = ExternalIdsUpdate.remove(o.rw(), o.noteMap(), extIdKey, accountId);
                updatedExtIds.onRemove(removedExtId);
            }
            return updatedExtIds;
        });
        this.externalIdCache.onRemove(u.oldRev(), u.newRev(), u.updatedExtIds().getRemoved());
        this.evictAccount(accountId);
    }

    public void deleteByKeys(Collection<ExternalId.Key> extIdKeys) throws IOException, ConfigInvalidException, OrmException {
        RefsMetaExternalIdsUpdate u = this.updateNoteMap(o -> {
            UpdatedExternalIds updatedExtIds = new UpdatedExternalIds();
            for (ExternalId.Key extIdKey : extIdKeys) {
                ExternalId extId = ExternalIdsUpdate.remove(o.rw(), o.noteMap(), extIdKey, null);
                updatedExtIds.onRemove(extId);
            }
            return updatedExtIds;
        });
        this.externalIdCache.onRemove(u.oldRev(), u.newRev(), u.updatedExtIds().getRemoved());
        this.evictAccounts(u);
    }

    public void deleteAll(Account.Id accountId) throws IOException, ConfigInvalidException, OrmException {
        this.delete(this.externalIds.byAccount(accountId));
    }

    public void replace(Account.Id accountId, Collection<ExternalId.Key> toDelete, Collection<ExternalId> toAdd) throws IOException, ConfigInvalidException, OrmException {
        ExternalIdsUpdate.checkSameAccount(toAdd, accountId);
        RefsMetaExternalIdsUpdate u = this.updateNoteMap(o -> {
            UpdatedExternalIds updatedExtIds = new UpdatedExternalIds();
            for (ExternalId.Key extIdKey : toDelete) {
                ExternalId removedExtId = ExternalIdsUpdate.remove(o.rw(), o.noteMap(), extIdKey, accountId);
                updatedExtIds.onRemove(removedExtId);
            }
            for (ExternalId extId : toAdd) {
                ExternalId insertedExtId = ExternalIdsUpdate.insert(o.rw(), o.ins(), o.noteMap(), extId);
                updatedExtIds.onUpdate(insertedExtId);
            }
            return updatedExtIds;
        });
        this.externalIdCache.onReplace(u.oldRev(), u.newRev(), accountId, u.updatedExtIds().getRemoved(), u.updatedExtIds().getUpdated());
        this.evictAccount(accountId);
    }

    public void replaceByKeys(Collection<ExternalId.Key> toDelete, Collection<ExternalId> toAdd) throws IOException, ConfigInvalidException, OrmException {
        RefsMetaExternalIdsUpdate u = this.updateNoteMap(o -> {
            UpdatedExternalIds updatedExtIds = new UpdatedExternalIds();
            for (ExternalId.Key extIdKey : toDelete) {
                ExternalId removedExtId = ExternalIdsUpdate.remove(o.rw(), o.noteMap(), extIdKey, null);
                updatedExtIds.onRemove(removedExtId);
            }
            for (ExternalId extId : toAdd) {
                ExternalId insertedExtId = ExternalIdsUpdate.insert(o.rw(), o.ins(), o.noteMap(), extId);
                updatedExtIds.onUpdate(insertedExtId);
            }
            return updatedExtIds;
        });
        this.externalIdCache.onReplace(u.oldRev(), u.newRev(), u.updatedExtIds().getRemoved(), u.updatedExtIds().getUpdated());
        this.evictAccounts(u);
    }

    public void replace(ExternalId toDelete, ExternalId toAdd) throws IOException, ConfigInvalidException, OrmException {
        this.replace(Collections.singleton(toDelete), Collections.singleton(toAdd));
    }

    public void replace(Collection<ExternalId> toDelete, Collection<ExternalId> toAdd) throws IOException, ConfigInvalidException, OrmException {
        Account.Id accountId = ExternalIdsUpdate.checkSameAccount(Iterables.concat(toDelete, toAdd));
        if (accountId == null) {
            return;
        }
        this.replace(accountId, toDelete.stream().map(e -> e.key()).collect(Collectors.toSet()), toAdd);
    }

    public static Account.Id checkSameAccount(Iterable<ExternalId> extIds) {
        return ExternalIdsUpdate.checkSameAccount(extIds, null);
    }

    public static Account.Id checkSameAccount(Iterable<ExternalId> extIds, @Nullable Account.Id accountId) {
        for (ExternalId extId : extIds) {
            if (accountId == null) {
                accountId = extId.accountId();
                continue;
            }
            Preconditions.checkState(accountId.equals(extId.accountId()), "external id %s belongs to account %s, expected account %s", (Object)extId.key().get(), (Object)extId.accountId().get(), (Object)accountId.get());
        }
        return accountId;
    }

    public static ExternalId insert(RevWalk rw, ObjectInserter ins, NoteMap noteMap, ExternalId extId) throws OrmDuplicateKeyException, ConfigInvalidException, IOException {
        if (noteMap.contains(extId.key().sha1())) {
            throw new OrmDuplicateKeyException(String.format("external id %s already exists", extId.key().get()));
        }
        return ExternalIdsUpdate.upsert(rw, ins, noteMap, extId);
    }

    public static ExternalId upsert(RevWalk rw, ObjectInserter ins, NoteMap noteMap, ExternalId extId) throws IOException, ConfigInvalidException {
        byte[] raw;
        ObjectId noteId = extId.key().sha1();
        Config c = new Config();
        if (noteMap.contains(extId.key().sha1())) {
            raw = rw.getObjectReader().open(noteMap.get(noteId), 3).getCachedBytes(524288);
            try {
                c.fromText(new String(raw, StandardCharsets.UTF_8));
            }
            catch (ConfigInvalidException e) {
                throw new ConfigInvalidException(String.format("Invalid external id config for note %s: %s", noteId, e.getMessage()));
            }
        }
        extId.writeToConfig(c);
        raw = c.toText().getBytes(StandardCharsets.UTF_8);
        ObjectId noteData = ins.insert(3, raw);
        noteMap.set(noteId, noteData);
        return ExternalId.create(extId, noteData);
    }

    public static ExternalId remove(RevWalk rw, NoteMap noteMap, ExternalId extId) throws IOException, ConfigInvalidException {
        ObjectId noteId = extId.key().sha1();
        if (!noteMap.contains(noteId)) {
            return null;
        }
        ObjectId noteData = noteMap.get(noteId);
        byte[] raw = rw.getObjectReader().open(noteData, 3).getCachedBytes(524288);
        ExternalId actualExtId = ExternalId.parse(noteId.name(), raw, noteData);
        Preconditions.checkState(extId.equals(actualExtId), "external id %s should be removed, but it's not matching the actual external id %s", (Object)extId.toString(), (Object)actualExtId.toString());
        noteMap.remove(noteId);
        return actualExtId;
    }

    private static ExternalId remove(RevWalk rw, NoteMap noteMap, ExternalId.Key extIdKey, Account.Id expectedAccountId) throws IOException, ConfigInvalidException {
        ObjectId noteId = extIdKey.sha1();
        if (!noteMap.contains(noteId)) {
            return null;
        }
        ObjectId noteData = noteMap.get(noteId);
        byte[] raw = rw.getObjectReader().open(noteData, 3).getCachedBytes(524288);
        ExternalId extId = ExternalId.parse(noteId.name(), raw, noteData);
        if (expectedAccountId != null) {
            Preconditions.checkState(expectedAccountId.equals(extId.accountId()), "external id %s should be removed for account %s, but external id belongs to account %s", (Object)extIdKey.get(), (Object)expectedAccountId.get(), (Object)extId.accountId().get());
        }
        noteMap.remove(noteId);
        return extId;
    }

    private RefsMetaExternalIdsUpdate updateNoteMap(ExternalIdUpdater updater) throws IOException, ConfigInvalidException, OrmException {
        try {
            return this.retryer.call(() -> {
                /*
                 * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                 * 
                 * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                 *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                 *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1050)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                 *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                 *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                 *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                 *     at org.benf.cfr.reader.Main.main(Main.java:54)
                 */
                throw new IllegalStateException("Decompilation failed");
            });
        }
        catch (RetryException | ExecutionException e) {
            if (e.getCause() != null) {
                Throwables.throwIfInstanceOf(e.getCause(), IOException.class);
                Throwables.throwIfInstanceOf(e.getCause(), ConfigInvalidException.class);
                Throwables.throwIfInstanceOf(e.getCause(), OrmException.class);
            }
            throw new OrmException(e);
        }
    }

    private RefsMetaExternalIdsUpdate commit(Repository repo, RevWalk rw, ObjectInserter ins, ObjectId rev, NoteMap noteMap, UpdatedExternalIds updatedExtIds) throws IOException {
        ObjectId newRev = ExternalIdsUpdate.commit(this.allUsersName, repo, rw, ins, rev, noteMap, COMMIT_MSG, this.committerIdent, this.authorIdent, this.currentUser, this.gitRefUpdated);
        this.updateCount.increment();
        return RefsMetaExternalIdsUpdate.create(rev, newRev, updatedExtIds);
    }

    public static ObjectId commit(Project.NameKey project, Repository repo, RevWalk rw, ObjectInserter ins, ObjectId rev, NoteMap noteMap, String commitMessage, PersonIdent committerIdent, PersonIdent authorIdent, @Nullable IdentifiedUser user, GitReferenceUpdated gitRefUpdated) throws IOException {
        CommitBuilder cb = new CommitBuilder();
        cb.setMessage(commitMessage);
        cb.setTreeId(noteMap.writeTree(ins));
        cb.setAuthor(authorIdent);
        cb.setCommitter(committerIdent);
        if (!rev.equals(ObjectId.zeroId())) {
            cb.setParentId(rev);
        } else {
            cb.setParentIds(new ObjectId[0]);
        }
        if (cb.getTreeId() == null) {
            if (rev.equals(ObjectId.zeroId())) {
                cb.setTreeId(ExternalIdsUpdate.emptyTree(ins));
            } else {
                RevCommit p = rw.parseCommit(rev);
                cb.setTreeId(p.getTree());
            }
        }
        ObjectId commitId = ins.insert(cb);
        ins.flush();
        RefUpdate u = repo.updateRef("refs/meta/external-ids");
        u.setRefLogIdent(committerIdent);
        u.setRefLogMessage(COMMIT_MSG, false);
        u.setExpectedOldObjectId(rev);
        u.setNewObjectId(commitId);
        RefUpdate.Result res = u.update();
        switch (res) {
            case NEW: 
            case FAST_FORWARD: 
            case NO_CHANGE: 
            case RENAMED: 
            case FORCED: {
                break;
            }
            case LOCK_FAILURE: {
                throw new LockFailureException("Updating external IDs failed with " + (Object)((Object)res), u);
            }
            default: {
                throw new IOException("Updating external IDs failed with " + (Object)((Object)res));
            }
        }
        gitRefUpdated.fire(project, u, user != null ? user.getAccount() : null);
        return rw.parseCommit(commitId);
    }

    private static ObjectId emptyTree(ObjectInserter ins) throws IOException {
        return ins.insert(2, new byte[0]);
    }

    private void evictAccount(Account.Id accountId) throws IOException {
        if (this.accountCache != null) {
            this.accountCache.evict(accountId);
        }
    }

    private void evictAccounts(RefsMetaExternalIdsUpdate u) throws IOException {
        if (this.accountCache != null) {
            for (Account.Id id : u.updatedExtIds().all().map(ExternalId::accountId).collect(Collectors.toSet())) {
                this.accountCache.evict(id);
            }
        }
    }

    private static /* synthetic */ /* end resource */ void $closeResource(Throwable x0, AutoCloseable x1) {
        if (x0 != null) {
            try {
                x1.close();
            }
            catch (Throwable throwable) {
                x0.addSuppressed(throwable);
            }
        } else {
            x1.close();
        }
    }

    public static class UpdatedExternalIds {
        private Set<ExternalId> updated = new HashSet<ExternalId>();
        private Set<ExternalId> removed = new HashSet<ExternalId>();

        public void onUpdate(ExternalId extId) {
            if (extId != null) {
                this.updated.add(extId);
            }
        }

        public void onRemove(ExternalId extId) {
            if (extId != null) {
                this.removed.add(extId);
            }
        }

        public Set<ExternalId> getUpdated() {
            return ImmutableSet.copyOf(this.updated);
        }

        public Set<ExternalId> getRemoved() {
            return ImmutableSet.copyOf(this.removed);
        }

        public Stream<ExternalId> all() {
            return Streams.concat(this.removed.stream(), this.updated.stream());
        }
    }

    @VisibleForTesting
    @AutoValue
    public static abstract class RefsMetaExternalIdsUpdate {
        static RefsMetaExternalIdsUpdate create(ObjectId oldRev, ObjectId newRev, UpdatedExternalIds updatedExtIds) {
            return new AutoValue_ExternalIdsUpdate_RefsMetaExternalIdsUpdate(oldRev, newRev, updatedExtIds);
        }

        abstract ObjectId oldRev();

        abstract ObjectId newRev();

        abstract UpdatedExternalIds updatedExtIds();
    }

    @AutoValue
    static abstract class OpenRepo {
        OpenRepo() {
        }

        static OpenRepo create(Repository repo, RevWalk rw, ObjectInserter ins, NoteMap noteMap) {
            return new AutoValue_ExternalIdsUpdate_OpenRepo(repo, rw, ins, noteMap);
        }

        abstract Repository repo();

        abstract RevWalk rw();

        abstract ObjectInserter ins();

        abstract NoteMap noteMap();
    }

    @FunctionalInterface
    private static interface ExternalIdUpdater {
        public UpdatedExternalIds update(OpenRepo var1) throws IOException, ConfigInvalidException, OrmException;
    }

    @Singleton
    public static class User {
        private final GitRepositoryManager repoManager;
        private final AccountCache accountCache;
        private final AllUsersName allUsersName;
        private final MetricMaker metricMaker;
        private final ExternalIds externalIds;
        private final ExternalIdCache externalIdCache;
        private final Provider<PersonIdent> serverIdent;
        private final Provider<IdentifiedUser> identifiedUser;
        private final GitReferenceUpdated gitRefUpdated;

        @Inject
        public User(GitRepositoryManager repoManager, AccountCache accountCache, AllUsersName allUsersName, MetricMaker metricMaker, ExternalIds externalIds, ExternalIdCache externalIdCache, @GerritPersonIdent Provider<PersonIdent> serverIdent, Provider<IdentifiedUser> identifiedUser, GitReferenceUpdated gitRefUpdated) {
            this.repoManager = repoManager;
            this.accountCache = accountCache;
            this.allUsersName = allUsersName;
            this.metricMaker = metricMaker;
            this.externalIds = externalIds;
            this.externalIdCache = externalIdCache;
            this.serverIdent = serverIdent;
            this.identifiedUser = identifiedUser;
            this.gitRefUpdated = gitRefUpdated;
        }

        public ExternalIdsUpdate create() {
            IdentifiedUser user = this.identifiedUser.get();
            PersonIdent i = this.serverIdent.get();
            return new ExternalIdsUpdate(this.repoManager, this.accountCache, this.allUsersName, this.metricMaker, this.externalIds, this.externalIdCache, this.createPersonIdent(i, user), i, user, this.gitRefUpdated);
        }

        private PersonIdent createPersonIdent(PersonIdent ident, IdentifiedUser user) {
            return user.newCommitterIdent(ident.getWhen(), ident.getTimeZone());
        }
    }

    @Singleton
    public static class ServerNoReindex {
        private final GitRepositoryManager repoManager;
        private final AllUsersName allUsersName;
        private final MetricMaker metricMaker;
        private final ExternalIds externalIds;
        private final ExternalIdCache externalIdCache;
        private final Provider<PersonIdent> serverIdent;
        private final GitReferenceUpdated gitRefUpdated;

        @Inject
        public ServerNoReindex(GitRepositoryManager repoManager, AllUsersName allUsersName, MetricMaker metricMaker, ExternalIds externalIds, ExternalIdCache externalIdCache, @GerritPersonIdent Provider<PersonIdent> serverIdent, GitReferenceUpdated gitRefUpdated) {
            this.repoManager = repoManager;
            this.allUsersName = allUsersName;
            this.metricMaker = metricMaker;
            this.externalIds = externalIds;
            this.externalIdCache = externalIdCache;
            this.serverIdent = serverIdent;
            this.gitRefUpdated = gitRefUpdated;
        }

        public ExternalIdsUpdate create() {
            PersonIdent i = this.serverIdent.get();
            return new ExternalIdsUpdate(this.repoManager, null, this.allUsersName, this.metricMaker, this.externalIds, this.externalIdCache, i, i, null, this.gitRefUpdated);
        }
    }

    @Singleton
    public static class Server {
        private final GitRepositoryManager repoManager;
        private final AccountCache accountCache;
        private final AllUsersName allUsersName;
        private final MetricMaker metricMaker;
        private final ExternalIds externalIds;
        private final ExternalIdCache externalIdCache;
        private final Provider<PersonIdent> serverIdent;
        private final GitReferenceUpdated gitRefUpdated;

        @Inject
        public Server(GitRepositoryManager repoManager, AccountCache accountCache, AllUsersName allUsersName, MetricMaker metricMaker, ExternalIds externalIds, ExternalIdCache externalIdCache, @GerritPersonIdent Provider<PersonIdent> serverIdent, GitReferenceUpdated gitRefUpdated) {
            this.repoManager = repoManager;
            this.accountCache = accountCache;
            this.allUsersName = allUsersName;
            this.metricMaker = metricMaker;
            this.externalIds = externalIds;
            this.externalIdCache = externalIdCache;
            this.serverIdent = serverIdent;
            this.gitRefUpdated = gitRefUpdated;
        }

        public ExternalIdsUpdate create() {
            PersonIdent i = this.serverIdent.get();
            return new ExternalIdsUpdate(this.repoManager, this.accountCache, this.allUsersName, this.metricMaker, this.externalIds, this.externalIdCache, i, i, null, this.gitRefUpdated);
        }
    }
}

