/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.api.changes;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.gerrit.extensions.api.changes.ChangeApi;
import com.google.gerrit.extensions.api.changes.Changes;
import com.google.gerrit.extensions.client.ListChangesOption;
import com.google.gerrit.extensions.common.ChangeInfo;
import com.google.gerrit.extensions.common.ChangeInput;
import com.google.gerrit.extensions.restapi.IdString;
import com.google.gerrit.extensions.restapi.Response;
import com.google.gerrit.extensions.restapi.RestApiException;
import com.google.gerrit.extensions.restapi.TopLevelResource;
import com.google.gerrit.extensions.restapi.Url;
import com.google.gerrit.reviewdb.client.Change;
import com.google.gerrit.server.api.ApiUtil;
import com.google.gerrit.server.api.changes.ChangeApiImpl;
import com.google.gerrit.server.change.ChangesCollection;
import com.google.gerrit.server.change.CreateChange;
import com.google.gerrit.server.query.change.QueryChanges;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import java.util.List;

@Singleton
class ChangesImpl
implements Changes {
    private final ChangesCollection changes;
    private final ChangeApiImpl.Factory api;
    private final CreateChange createChange;
    private final Provider<QueryChanges> queryProvider;

    @Inject
    ChangesImpl(ChangesCollection changes, ChangeApiImpl.Factory api, CreateChange createChange, Provider<QueryChanges> queryProvider) {
        this.changes = changes;
        this.api = api;
        this.createChange = createChange;
        this.queryProvider = queryProvider;
    }

    @Override
    public ChangeApi id(int id) throws RestApiException {
        return this.id(String.valueOf(id));
    }

    @Override
    public ChangeApi id(String project, String branch, String id) throws RestApiException {
        return this.id(Joiner.on('~').join(ImmutableList.of(Url.encode(project), Url.encode(branch), Url.encode(id))));
    }

    @Override
    public ChangeApi id(String id) throws RestApiException {
        try {
            return this.api.create(this.changes.parse(TopLevelResource.INSTANCE, IdString.fromUrl(id)));
        }
        catch (Exception e) {
            throw ApiUtil.asRestApiException("Cannot parse change", e);
        }
    }

    @Override
    public ChangeApi id(String project, int id) throws RestApiException {
        return this.id(Joiner.on('~').join(ImmutableList.of(Url.encode(project), Url.encode(String.valueOf(id)))));
    }

    @Override
    public ChangeApi create(ChangeInput in) throws RestApiException {
        try {
            ChangeInfo out = (ChangeInfo)((Response)this.createChange.apply(TopLevelResource.INSTANCE, in)).value();
            return this.api.create(this.changes.parse(new Change.Id(out._number)));
        }
        catch (Exception e) {
            throw ApiUtil.asRestApiException("Cannot create change", e);
        }
    }

    @Override
    public Changes.QueryRequest query() {
        return new Changes.QueryRequest(){

            @Override
            public List<ChangeInfo> get() throws RestApiException {
                return ChangesImpl.this.get(this);
            }
        };
    }

    @Override
    public Changes.QueryRequest query(String query) {
        return this.query().withQuery(query);
    }

    private List<ChangeInfo> get(Changes.QueryRequest q) throws RestApiException {
        QueryChanges qc = this.queryProvider.get();
        if (q.getQuery() != null) {
            qc.addQuery(q.getQuery());
        }
        qc.setLimit(q.getLimit());
        qc.setStart(q.getStart());
        for (ListChangesOption option : q.getOptions()) {
            qc.addOption(option);
        }
        try {
            List<?> result = qc.apply(TopLevelResource.INSTANCE);
            if (result.isEmpty()) {
                return ImmutableList.of();
            }
            Object first = Preconditions.checkNotNull(result.iterator().next());
            Preconditions.checkState(first instanceof ChangeInfo);
            List<?> infos = result;
            return ImmutableList.copyOf(infos);
        }
        catch (Exception e) {
            throw ApiUtil.asRestApiException("Cannot query changes", e);
        }
    }
}

