/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.change;

import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.gerrit.common.TimeUtil;
import com.google.gerrit.extensions.api.changes.AbandonInput;
import com.google.gerrit.extensions.api.changes.NotifyHandling;
import com.google.gerrit.extensions.api.changes.RecipientType;
import com.google.gerrit.extensions.common.ChangeInfo;
import com.google.gerrit.extensions.conditions.BooleanCondition;
import com.google.gerrit.extensions.restapi.ResourceConflictException;
import com.google.gerrit.extensions.restapi.RestApiException;
import com.google.gerrit.extensions.webui.UiAction;
import com.google.gerrit.reviewdb.client.Account;
import com.google.gerrit.reviewdb.client.Change;
import com.google.gerrit.reviewdb.client.Project;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.CurrentUser;
import com.google.gerrit.server.change.ChangeJson;
import com.google.gerrit.server.change.ChangeResource;
import com.google.gerrit.server.change.NotifyUtil;
import com.google.gerrit.server.git.AbandonOp;
import com.google.gerrit.server.notedb.ChangeNotes;
import com.google.gerrit.server.permissions.ChangePermission;
import com.google.gerrit.server.permissions.PermissionBackend;
import com.google.gerrit.server.permissions.PermissionBackendException;
import com.google.gerrit.server.query.change.ChangeData;
import com.google.gerrit.server.update.BatchUpdate;
import com.google.gerrit.server.update.RetryHelper;
import com.google.gerrit.server.update.RetryingRestModifyView;
import com.google.gerrit.server.update.UpdateException;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import java.io.IOException;
import java.util.Collection;
import org.eclipse.jgit.errors.ConfigInvalidException;

@Singleton
public class Abandon
extends RetryingRestModifyView<ChangeResource, AbandonInput, ChangeInfo>
implements UiAction<ChangeResource> {
    private final Provider<ReviewDb> dbProvider;
    private final ChangeJson.Factory json;
    private final AbandonOp.Factory abandonOpFactory;
    private final NotifyUtil notifyUtil;

    @Inject
    Abandon(Provider<ReviewDb> dbProvider, ChangeJson.Factory json, RetryHelper retryHelper, AbandonOp.Factory abandonOpFactory, NotifyUtil notifyUtil) {
        super(retryHelper);
        this.dbProvider = dbProvider;
        this.json = json;
        this.abandonOpFactory = abandonOpFactory;
        this.notifyUtil = notifyUtil;
    }

    @Override
    protected ChangeInfo applyImpl(BatchUpdate.Factory updateFactory, ChangeResource req, AbandonInput input) throws RestApiException, UpdateException, OrmException, PermissionBackendException, IOException, ConfigInvalidException {
        ((PermissionBackend.ForChange)req.permissions().database(this.dbProvider)).check(ChangePermission.ABANDON);
        NotifyHandling notify = input.notify == null ? this.defaultNotify(req.getChange()) : input.notify;
        Change change = this.abandon(updateFactory, req.getNotes(), req.getUser(), input.message, notify, this.notifyUtil.resolveAccounts(input.notifyDetails));
        return this.json.noOptions().format(change);
    }

    private NotifyHandling defaultNotify(Change change) {
        return change.hasReviewStarted() ? NotifyHandling.ALL : NotifyHandling.OWNER;
    }

    public Change abandon(BatchUpdate.Factory updateFactory, ChangeNotes notes, CurrentUser user) throws RestApiException, UpdateException {
        return this.abandon(updateFactory, notes, user, "", this.defaultNotify(notes.getChange()), ImmutableListMultimap.of());
    }

    public Change abandon(BatchUpdate.Factory updateFactory, ChangeNotes notes, CurrentUser user, String msgTxt) throws RestApiException, UpdateException {
        return this.abandon(updateFactory, notes, user, msgTxt, this.defaultNotify(notes.getChange()), ImmutableListMultimap.of());
    }

    public Change abandon(BatchUpdate.Factory updateFactory, ChangeNotes notes, CurrentUser user, String msgTxt, NotifyHandling notifyHandling, ListMultimap<RecipientType, Account.Id> accountsToNotify) throws RestApiException, UpdateException {
        Account account = user.isIdentifiedUser() ? user.asIdentifiedUser().getAccount() : null;
        AbandonOp op = this.abandonOpFactory.create(account, msgTxt, notifyHandling, accountsToNotify);
        try (BatchUpdate u = updateFactory.create(this.dbProvider.get(), notes.getProjectName(), user, TimeUtil.nowTs());){
            u.addOp(notes.getChangeId(), op).execute();
        }
        return op.getChange();
    }

    public void batchAbandon(BatchUpdate.Factory updateFactory, Project.NameKey project, CurrentUser user, Collection<ChangeData> changes, String msgTxt, NotifyHandling notifyHandling, ListMultimap<RecipientType, Account.Id> accountsToNotify) throws RestApiException, UpdateException {
        if (changes.isEmpty()) {
            return;
        }
        Account account = user.isIdentifiedUser() ? user.asIdentifiedUser().getAccount() : null;
        try (BatchUpdate u = updateFactory.create(this.dbProvider.get(), project, user, TimeUtil.nowTs());){
            for (ChangeData change : changes) {
                if (!project.equals(change.project())) {
                    throw new ResourceConflictException(String.format("Project name \"%s\" doesn't match \"%s\"", change.project().get(), project.get()));
                }
                u.addOp(change.getId(), this.abandonOpFactory.create(account, msgTxt, notifyHandling, accountsToNotify));
            }
            u.execute();
        }
    }

    public void batchAbandon(BatchUpdate.Factory updateFactory, Project.NameKey project, CurrentUser user, Collection<ChangeData> changes, String msgTxt) throws RestApiException, UpdateException {
        this.batchAbandon(updateFactory, project, user, changes, msgTxt, NotifyHandling.ALL, ImmutableListMultimap.of());
    }

    public void batchAbandon(BatchUpdate.Factory updateFactory, Project.NameKey project, CurrentUser user, Collection<ChangeData> changes) throws RestApiException, UpdateException {
        this.batchAbandon(updateFactory, project, user, changes, "", NotifyHandling.ALL, ImmutableListMultimap.of());
    }

    @Override
    public UiAction.Description getDescription(ChangeResource rsrc) {
        Change change = rsrc.getChange();
        return new UiAction.Description().setLabel("Abandon").setTitle("Abandon the change").setVisible(BooleanCondition.and(change.getStatus().isOpen(), ((PermissionBackend.ForChange)rsrc.permissions().database(this.dbProvider)).testCond(ChangePermission.ABANDON)));
    }
}

