/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.change;

import com.google.common.base.Strings;
import com.google.gerrit.extensions.common.DiffWebLinkInfo;
import com.google.gerrit.extensions.common.EditInfo;
import com.google.gerrit.extensions.registration.DynamicMap;
import com.google.gerrit.extensions.restapi.AcceptsCreate;
import com.google.gerrit.extensions.restapi.AcceptsDelete;
import com.google.gerrit.extensions.restapi.AcceptsPost;
import com.google.gerrit.extensions.restapi.AuthException;
import com.google.gerrit.extensions.restapi.BadRequestException;
import com.google.gerrit.extensions.restapi.BinaryResult;
import com.google.gerrit.extensions.restapi.ChildCollection;
import com.google.gerrit.extensions.restapi.DefaultInput;
import com.google.gerrit.extensions.restapi.IdString;
import com.google.gerrit.extensions.restapi.RawInput;
import com.google.gerrit.extensions.restapi.ResourceConflictException;
import com.google.gerrit.extensions.restapi.ResourceNotFoundException;
import com.google.gerrit.extensions.restapi.Response;
import com.google.gerrit.extensions.restapi.RestApiException;
import com.google.gerrit.extensions.restapi.RestModifyView;
import com.google.gerrit.extensions.restapi.RestReadView;
import com.google.gerrit.extensions.restapi.RestView;
import com.google.gerrit.reviewdb.client.Change;
import com.google.gerrit.reviewdb.client.PatchSet;
import com.google.gerrit.reviewdb.client.Project;
import com.google.gerrit.server.WebLinks;
import com.google.gerrit.server.change.ChangeEditResource;
import com.google.gerrit.server.change.ChangeResource;
import com.google.gerrit.server.change.FileContentUtil;
import com.google.gerrit.server.change.FileInfoJson;
import com.google.gerrit.server.change.RevisionResource;
import com.google.gerrit.server.change.Revisions;
import com.google.gerrit.server.edit.ChangeEdit;
import com.google.gerrit.server.edit.ChangeEditJson;
import com.google.gerrit.server.edit.ChangeEditModifier;
import com.google.gerrit.server.edit.ChangeEditUtil;
import com.google.gerrit.server.edit.UnchangedCommitMessageException;
import com.google.gerrit.server.git.GitRepositoryManager;
import com.google.gerrit.server.patch.PatchListNotAvailableException;
import com.google.gerrit.server.permissions.PermissionBackendException;
import com.google.gerrit.server.project.InvalidChangeOperationException;
import com.google.gerrit.server.project.ProjectCache;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import com.google.inject.assistedinject.Assisted;
import java.io.IOException;
import java.util.List;
import java.util.Optional;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.kohsuke.args4j.Option;

@Singleton
public class ChangeEdits
implements ChildCollection<ChangeResource, ChangeEditResource>,
AcceptsCreate<ChangeResource>,
AcceptsPost<ChangeResource>,
AcceptsDelete<ChangeResource> {
    private final DynamicMap<RestView<ChangeEditResource>> views;
    private final Create.Factory createFactory;
    private final DeleteFile.Factory deleteFileFactory;
    private final Provider<Detail> detail;
    private final ChangeEditUtil editUtil;
    private final Post post;

    @Inject
    ChangeEdits(DynamicMap<RestView<ChangeEditResource>> views, Create.Factory createFactory, Provider<Detail> detail, ChangeEditUtil editUtil, Post post, DeleteFile.Factory deleteFileFactory) {
        this.views = views;
        this.createFactory = createFactory;
        this.detail = detail;
        this.editUtil = editUtil;
        this.post = post;
        this.deleteFileFactory = deleteFileFactory;
    }

    @Override
    public DynamicMap<RestView<ChangeEditResource>> views() {
        return this.views;
    }

    @Override
    public RestView<ChangeResource> list() {
        return this.detail.get();
    }

    @Override
    public ChangeEditResource parse(ChangeResource rsrc, IdString id) throws ResourceNotFoundException, AuthException, IOException, OrmException {
        Optional<ChangeEdit> edit = this.editUtil.byChange(rsrc.getNotes(), rsrc.getUser());
        if (!edit.isPresent()) {
            throw new ResourceNotFoundException(id);
        }
        return new ChangeEditResource(rsrc, edit.get(), id.get());
    }

    public Create create(ChangeResource parent, IdString id) throws RestApiException {
        return this.createFactory.create(id.get());
    }

    public Post post(ChangeResource parent) throws RestApiException {
        return this.post;
    }

    public DeleteFile delete(ChangeResource parent, IdString id) throws RestApiException {
        return this.deleteFileFactory.create(id.get());
    }

    public static class GetMessage
    implements RestReadView<ChangeResource> {
        private final GitRepositoryManager repoManager;
        private final ChangeEditUtil editUtil;
        @Option(name="--base", aliases={"-b"}, usage="whether to load the message on the base revision instead of the change edit")
        private boolean base;

        @Inject
        GetMessage(GitRepositoryManager repoManager, ChangeEditUtil editUtil) {
            this.repoManager = repoManager;
            this.editUtil = editUtil;
        }

        public BinaryResult apply(ChangeResource rsrc) throws AuthException, IOException, ResourceNotFoundException, OrmException {
            Optional<ChangeEdit> edit = this.editUtil.byChange(rsrc.getNotes(), rsrc.getUser());
            if (edit.isPresent()) {
                String msg;
                block13: {
                    if (this.base) {
                        try (Repository repo = this.repoManager.openRepository(rsrc.getProject());
                             RevWalk rw = new RevWalk(repo);){
                            RevCommit commit = rw.parseCommit(ObjectId.fromString(edit.get().getBasePatchSet().getRevision().get()));
                            msg = commit.getFullMessage();
                            break block13;
                        }
                    }
                    msg = edit.get().getEditCommit().getFullMessage();
                }
                return BinaryResult.create(msg).setContentType("text/x-gerrit-commit-message").base64();
            }
            throw new ResourceNotFoundException();
        }
    }

    @Singleton
    public static class EditMessage
    implements RestModifyView<ChangeResource, Input> {
        private final ChangeEditModifier editModifier;
        private final GitRepositoryManager repositoryManager;

        @Inject
        EditMessage(ChangeEditModifier editModifier, GitRepositoryManager repositoryManager) {
            this.editModifier = editModifier;
            this.repositoryManager = repositoryManager;
        }

        @Override
        public Object apply(ChangeResource rsrc, Input input) throws AuthException, IOException, BadRequestException, ResourceConflictException, OrmException, PermissionBackendException {
            if (input == null || Strings.isNullOrEmpty(input.message)) {
                throw new BadRequestException("commit message must be provided");
            }
            Project.NameKey project = rsrc.getProject();
            try (Repository repository = this.repositoryManager.openRepository(project);){
                this.editModifier.modifyMessage(repository, rsrc.getNotes(), input.message);
            }
            catch (UnchangedCommitMessageException e) {
                throw new ResourceConflictException(e.getMessage());
            }
            return Response.none();
        }

        public static class Input {
            @DefaultInput
            public String message;
        }
    }

    @Singleton
    public static class GetMeta
    implements RestReadView<ChangeEditResource> {
        private final WebLinks webLinks;

        @Inject
        GetMeta(WebLinks webLinks) {
            this.webLinks = webLinks;
        }

        public FileInfo apply(ChangeEditResource rsrc) {
            FileInfo r = new FileInfo();
            ChangeEdit edit = rsrc.getChangeEdit();
            Change change = edit.getChange();
            List<DiffWebLinkInfo> links = this.webLinks.getDiffLinks(change.getProject().get(), change.getChangeId(), edit.getBasePatchSet().getPatchSetId(), edit.getBasePatchSet().getRefName(), rsrc.getPath(), 0, edit.getRefName(), rsrc.getPath());
            r.webLinks = links.isEmpty() ? null : links;
            return r;
        }

        public static class FileInfo {
            public List<DiffWebLinkInfo> webLinks;
        }
    }

    public static class Get
    implements RestReadView<ChangeEditResource> {
        private final FileContentUtil fileContentUtil;
        private final ProjectCache projectCache;
        @Option(name="--base", aliases={"-b"}, usage="whether to load the content on the base revision instead of the change edit")
        private boolean base;

        @Inject
        Get(FileContentUtil fileContentUtil, ProjectCache projectCache) {
            this.fileContentUtil = fileContentUtil;
            this.projectCache = projectCache;
        }

        public Response<BinaryResult> apply(ChangeEditResource rsrc) throws IOException {
            try {
                ChangeEdit edit = rsrc.getChangeEdit();
                return Response.ok(this.fileContentUtil.getContent(this.projectCache.checkedGet(rsrc.getChangeResource().getProject()), this.base ? ObjectId.fromString(edit.getBasePatchSet().getRevision().get()) : edit.getEditCommit(), rsrc.getPath(), null));
            }
            catch (BadRequestException | ResourceNotFoundException e) {
                return Response.none();
            }
        }
    }

    @Singleton
    public static class DeleteContent
    implements RestModifyView<ChangeEditResource, Input> {
        private final ChangeEditModifier editModifier;
        private final GitRepositoryManager repositoryManager;

        @Inject
        DeleteContent(ChangeEditModifier editModifier, GitRepositoryManager repositoryManager) {
            this.editModifier = editModifier;
            this.repositoryManager = repositoryManager;
        }

        public Response<?> apply(ChangeEditResource rsrc, Input input) throws AuthException, ResourceConflictException, OrmException, IOException, PermissionBackendException {
            return this.apply(rsrc.getChangeResource(), rsrc.getPath());
        }

        public Response<?> apply(ChangeResource rsrc, String filePath) throws AuthException, IOException, OrmException, ResourceConflictException, PermissionBackendException {
            try (Repository repository = this.repositoryManager.openRepository(rsrc.getProject());){
                this.editModifier.deleteFile(repository, rsrc.getNotes(), filePath);
            }
            catch (InvalidChangeOperationException e) {
                throw new ResourceConflictException(e.getMessage());
            }
            return Response.none();
        }

        public static class Input {
        }
    }

    @Singleton
    public static class Put
    implements RestModifyView<ChangeEditResource, Input> {
        private final ChangeEditModifier editModifier;
        private final GitRepositoryManager repositoryManager;

        @Inject
        Put(ChangeEditModifier editModifier, GitRepositoryManager repositoryManager) {
            this.editModifier = editModifier;
            this.repositoryManager = repositoryManager;
        }

        public Response<?> apply(ChangeEditResource rsrc, Input input) throws AuthException, ResourceConflictException, IOException, OrmException, PermissionBackendException {
            return this.apply(rsrc.getChangeResource(), rsrc.getPath(), input.content);
        }

        public Response<?> apply(ChangeResource rsrc, String path, RawInput newContent) throws ResourceConflictException, AuthException, IOException, OrmException, PermissionBackendException {
            if (Strings.isNullOrEmpty(path) || path.charAt(0) == '/') {
                throw new ResourceConflictException("Invalid path: " + path);
            }
            try (Repository repository = this.repositoryManager.openRepository(rsrc.getProject());){
                this.editModifier.modifyFile(repository, rsrc.getNotes(), path, newContent);
            }
            catch (InvalidChangeOperationException e) {
                throw new ResourceConflictException(e.getMessage());
            }
            return Response.none();
        }

        public static class Input {
            @DefaultInput
            public RawInput content;
        }
    }

    @Singleton
    public static class Post
    implements RestModifyView<ChangeResource, Input> {
        private final ChangeEditModifier editModifier;
        private final GitRepositoryManager repositoryManager;

        @Inject
        Post(ChangeEditModifier editModifier, GitRepositoryManager repositoryManager) {
            this.editModifier = editModifier;
            this.repositoryManager = repositoryManager;
        }

        public Response<?> apply(ChangeResource resource, Input input) throws AuthException, IOException, ResourceConflictException, OrmException, PermissionBackendException {
            Project.NameKey project = resource.getProject();
            try (Repository repository = this.repositoryManager.openRepository(project);){
                if (Post.isRestoreFile(input)) {
                    this.editModifier.restoreFile(repository, resource.getNotes(), input.restorePath);
                } else if (Post.isRenameFile(input)) {
                    this.editModifier.renameFile(repository, resource.getNotes(), input.oldPath, input.newPath);
                } else {
                    this.editModifier.createEdit(repository, resource.getNotes());
                }
            }
            catch (InvalidChangeOperationException e) {
                throw new ResourceConflictException(e.getMessage());
            }
            return Response.none();
        }

        private static boolean isRestoreFile(Input input) {
            return input != null && !Strings.isNullOrEmpty(input.restorePath);
        }

        private static boolean isRenameFile(Input input) {
            return input != null && !Strings.isNullOrEmpty(input.oldPath) && !Strings.isNullOrEmpty(input.newPath);
        }

        public static class Input {
            public String restorePath;
            public String oldPath;
            public String newPath;
        }
    }

    public static class Detail
    implements RestReadView<ChangeResource> {
        private final ChangeEditUtil editUtil;
        private final ChangeEditJson editJson;
        private final FileInfoJson fileInfoJson;
        private final Revisions revisions;
        private String base;
        private boolean list;
        private boolean downloadCommands;

        @Option(name="--base", metaVar="revision-id")
        public void setBase(String base) {
            this.base = base;
        }

        @Option(name="--list")
        public void setList(boolean list) {
            this.list = list;
        }

        @Option(name="--download-commands")
        public void setDownloadCommands(boolean downloadCommands) {
            this.downloadCommands = downloadCommands;
        }

        @Inject
        Detail(ChangeEditUtil editUtil, ChangeEditJson editJson, FileInfoJson fileInfoJson, Revisions revisions) {
            this.editJson = editJson;
            this.editUtil = editUtil;
            this.fileInfoJson = fileInfoJson;
            this.revisions = revisions;
        }

        public Response<EditInfo> apply(ChangeResource rsrc) throws AuthException, IOException, ResourceNotFoundException, OrmException, PermissionBackendException {
            Optional<ChangeEdit> edit = this.editUtil.byChange(rsrc.getNotes(), rsrc.getUser());
            if (!edit.isPresent()) {
                return Response.none();
            }
            EditInfo editInfo = this.editJson.toEditInfo(edit.get(), this.downloadCommands);
            if (this.list) {
                PatchSet basePatchSet = null;
                if (this.base != null) {
                    RevisionResource baseResource = this.revisions.parse(rsrc, IdString.fromDecoded(this.base));
                    basePatchSet = baseResource.getPatchSet();
                }
                try {
                    editInfo.files = this.fileInfoJson.toFileInfoMap(rsrc.getChange(), edit.get().getEditCommit(), basePatchSet);
                }
                catch (PatchListNotAvailableException e) {
                    throw new ResourceNotFoundException(e.getMessage());
                }
            }
            return Response.ok(editInfo);
        }
    }

    public static class DeleteFile
    implements RestModifyView<ChangeResource, Input> {
        private final DeleteContent deleteContent;
        private final String path;

        @Inject
        DeleteFile(DeleteContent deleteContent, @Assisted String path) {
            this.deleteContent = deleteContent;
            this.path = path;
        }

        public Response<?> apply(ChangeResource rsrc, Input in) throws IOException, AuthException, ResourceConflictException, OrmException, PermissionBackendException {
            return this.deleteContent.apply(rsrc, this.path);
        }

        static interface Factory {
            public DeleteFile create(String var1);
        }

        public static class Input {
        }
    }

    public static class Create
    implements RestModifyView<ChangeResource, Put.Input> {
        private final Put putEdit;
        private final String path;

        @Inject
        Create(Put putEdit, @Assisted String path) {
            this.putEdit = putEdit;
            this.path = path;
        }

        public Response<?> apply(ChangeResource resource, Put.Input input) throws AuthException, ResourceConflictException, IOException, OrmException, PermissionBackendException {
            this.putEdit.apply(resource, this.path, input.content);
            return Response.none();
        }

        static interface Factory {
            public Create create(String var1);
        }
    }
}

