/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.change;

import com.google.gerrit.extensions.api.changes.FixInput;
import com.google.gerrit.extensions.client.ListChangesOption;
import com.google.gerrit.extensions.common.ChangeInfo;
import com.google.gerrit.extensions.restapi.Response;
import com.google.gerrit.extensions.restapi.RestApiException;
import com.google.gerrit.extensions.restapi.RestModifyView;
import com.google.gerrit.extensions.restapi.RestReadView;
import com.google.gerrit.server.CurrentUser;
import com.google.gerrit.server.change.ChangeJson;
import com.google.gerrit.server.change.ChangeResource;
import com.google.gerrit.server.permissions.GlobalPermission;
import com.google.gerrit.server.permissions.PermissionBackend;
import com.google.gerrit.server.permissions.PermissionBackendException;
import com.google.gerrit.server.project.NoSuchProjectException;
import com.google.gerrit.server.project.ProjectControl;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.io.IOException;

public class Check
implements RestReadView<ChangeResource>,
RestModifyView<ChangeResource, FixInput> {
    private final PermissionBackend permissionBackend;
    private final Provider<CurrentUser> user;
    private final ChangeJson.Factory jsonFactory;
    private final ProjectControl.GenericFactory projectControlFactory;

    @Inject
    Check(PermissionBackend permissionBackend, Provider<CurrentUser> user, ChangeJson.Factory json, ProjectControl.GenericFactory projectControlFactory) {
        this.permissionBackend = permissionBackend;
        this.user = user;
        this.jsonFactory = json;
        this.projectControlFactory = projectControlFactory;
    }

    public Response<ChangeInfo> apply(ChangeResource rsrc) throws RestApiException, OrmException {
        return Response.withMustRevalidate(this.newChangeJson().format(rsrc));
    }

    public Response<ChangeInfo> apply(ChangeResource rsrc, FixInput input) throws RestApiException, OrmException, PermissionBackendException, NoSuchProjectException, IOException {
        if (!rsrc.isUserOwner() && !this.projectControlFactory.controlFor(rsrc.getProject(), rsrc.getUser()).isOwner()) {
            this.permissionBackend.user(this.user).check(GlobalPermission.MAINTAIN_SERVER);
        }
        return Response.withMustRevalidate(this.newChangeJson().fix(input).format(rsrc));
    }

    private ChangeJson newChangeJson() {
        return this.jsonFactory.create(ListChangesOption.CHECK, new ListChangesOption[0]);
    }
}

