/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.change;

import com.google.gerrit.extensions.api.changes.DeleteReviewerInput;
import com.google.gerrit.extensions.api.changes.NotifyHandling;
import com.google.gerrit.reviewdb.client.Change;
import com.google.gerrit.reviewdb.client.ChangeMessage;
import com.google.gerrit.reviewdb.client.PatchSet;
import com.google.gerrit.server.ChangeUtil;
import com.google.gerrit.server.change.DeleteReviewer;
import com.google.gerrit.server.change.NotifyUtil;
import com.google.gerrit.server.mail.Address;
import com.google.gerrit.server.mail.send.DeleteReviewerSender;
import com.google.gerrit.server.update.BatchUpdateOp;
import com.google.gerrit.server.update.ChangeContext;
import com.google.gerrit.server.update.Context;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import com.google.inject.assistedinject.Assisted;
import java.util.Collections;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeleteReviewerByEmailOp
implements BatchUpdateOp {
    private static final Logger log = LoggerFactory.getLogger(DeleteReviewer.class);
    private final DeleteReviewerSender.Factory deleteReviewerSenderFactory;
    private final NotifyUtil notifyUtil;
    private final Address reviewer;
    private final DeleteReviewerInput input;
    private ChangeMessage changeMessage;
    private Change change;

    @Inject
    DeleteReviewerByEmailOp(DeleteReviewerSender.Factory deleteReviewerSenderFactory, NotifyUtil notifyUtil, @Assisted Address reviewer, @Assisted DeleteReviewerInput input) {
        this.deleteReviewerSenderFactory = deleteReviewerSenderFactory;
        this.notifyUtil = notifyUtil;
        this.reviewer = reviewer;
        this.input = input;
    }

    @Override
    public boolean updateChange(ChangeContext ctx) throws OrmException {
        this.change = ctx.getChange();
        PatchSet.Id psId = ctx.getChange().currentPatchSetId();
        String msg = "Removed reviewer " + this.reviewer;
        this.changeMessage = new ChangeMessage(new ChangeMessage.Key(this.change.getId(), ChangeUtil.messageUuid()), ctx.getAccountId(), ctx.getWhen(), psId);
        this.changeMessage.setMessage(msg);
        ctx.getUpdate(psId).setChangeMessage(msg);
        ctx.getUpdate(psId).removeReviewerByEmail(this.reviewer);
        return true;
    }

    @Override
    public void postUpdate(Context ctx) {
        if (this.input.notify == null) {
            this.input.notify = this.change.isWorkInProgress() ? NotifyHandling.NONE : NotifyHandling.ALL;
        }
        if (!NotifyUtil.shouldNotify(this.input.notify, this.input.notifyDetails)) {
            return;
        }
        try {
            DeleteReviewerSender cm = this.deleteReviewerSenderFactory.create(ctx.getProject(), this.change.getId());
            cm.setFrom(ctx.getAccountId());
            cm.addReviewersByEmail(Collections.singleton(this.reviewer));
            cm.setChangeMessage(this.changeMessage.getMessage(), this.changeMessage.getWrittenOn());
            cm.setNotify(this.input.notify);
            cm.setAccountsToNotify(this.notifyUtil.resolveAccounts(this.input.notifyDetails));
            cm.send();
        }
        catch (Exception err) {
            log.error("Cannot email update for change " + this.change.getId(), err);
        }
    }

    public static interface Factory {
        public DeleteReviewerByEmailOp create(Address var1, DeleteReviewerInput var2);
    }
}

