/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.change;

import com.google.common.collect.ImmutableList;
import com.google.gerrit.extensions.common.CommitInfo;
import com.google.gerrit.extensions.restapi.BadRequestException;
import com.google.gerrit.extensions.restapi.CacheControl;
import com.google.gerrit.extensions.restapi.Response;
import com.google.gerrit.extensions.restapi.RestReadView;
import com.google.gerrit.reviewdb.client.Project;
import com.google.gerrit.server.change.ChangeJson;
import com.google.gerrit.server.change.RevisionResource;
import com.google.gerrit.server.git.GitRepositoryManager;
import com.google.gerrit.server.patch.MergeListBuilder;
import com.google.inject.Inject;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.kohsuke.args4j.Option;

public class GetMergeList
implements RestReadView<RevisionResource> {
    private final GitRepositoryManager repoManager;
    private final ChangeJson.Factory json;
    @Option(name="--parent", usage="Uninteresting parent (1-based, default = 1)")
    private int uninterestingParent = 1;
    @Option(name="--links", usage="Include weblinks")
    private boolean addLinks;

    @Inject
    GetMergeList(GitRepositoryManager repoManager, ChangeJson.Factory json) {
        this.repoManager = repoManager;
        this.json = json;
    }

    public void setUninterestingParent(int uninterestingParent) {
        this.uninterestingParent = uninterestingParent;
    }

    public void setAddLinks(boolean addLinks) {
        this.addLinks = addLinks;
    }

    public Response<List<CommitInfo>> apply(RevisionResource rsrc) throws BadRequestException, IOException {
        Project.NameKey p = rsrc.getChange().getProject();
        Throwable throwable = null;
        try (Repository repo = this.repoManager.openRepository(p);){
            Response<List<CommitInfo>> response;
            RevCommit commit;
            Throwable throwable2;
            RevWalk rw;
            block15: {
                rw = new RevWalk(repo);
                throwable2 = null;
                String rev = rsrc.getPatchSet().getRevision().get();
                commit = rw.parseCommit(ObjectId.fromString(rev));
                rw.parseBody(commit);
                if (this.uninterestingParent < 1 || this.uninterestingParent > commit.getParentCount()) {
                    throw new BadRequestException("No such parent: " + this.uninterestingParent);
                }
                if (commit.getParentCount() >= 2) break block15;
                Response<List<CommitInfo>> response2 = GetMergeList.createResponse(rsrc, ImmutableList.of());
                GetMergeList.$closeResource(throwable2, rw);
                return response2;
            }
            try {
                List<RevCommit> commits = MergeListBuilder.build(rw, commit, this.uninterestingParent);
                ArrayList<CommitInfo> result = new ArrayList<CommitInfo>(commits.size());
                ChangeJson changeJson = this.json.noOptions();
                for (RevCommit c : commits) {
                    result.add(changeJson.toCommit(rsrc.getProject(), rw, c, this.addLinks, true));
                }
                response = GetMergeList.createResponse(rsrc, result);
            }
            catch (Throwable throwable3) {
                try {
                    try {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    catch (Throwable throwable4) {
                        GetMergeList.$closeResource(throwable2, rw);
                        throw throwable4;
                    }
                }
                catch (Throwable throwable5) {
                    throwable = throwable5;
                    throw throwable5;
                }
            }
            GetMergeList.$closeResource(throwable2, rw);
            return response;
        }
    }

    private static Response<List<CommitInfo>> createResponse(RevisionResource rsrc, List<CommitInfo> result) {
        Response<List<CommitInfo>> r = Response.ok(result);
        if (rsrc.isCacheable()) {
            r.caching(CacheControl.PRIVATE(7L, TimeUnit.DAYS));
        }
        return r;
    }
}

